/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseCharacterStreamWrapper;
import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseData;
import com.microsoft.jdbc.base.BaseInputStreamWrapper;
import com.microsoft.jdbc.base.BaseParameter;
import com.microsoft.jdbc.base.BaseParameters;
import com.microsoft.jdbc.base.BaseResultSetMetaData;
import com.microsoft.jdbc.base.BaseStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class BasePreparedStatement
extends BaseStatement
implements PreparedStatement {
    private static String footprint = "$Revision:   1.58.1.4.1.1  $";
    private Vector parameterSets;
    BaseParameters currentParameters;
    private boolean doingBatch = false;
    private boolean internalAddBatchForNonBatchExecution = false;

    public BasePreparedStatement(BaseConnection baseConnection, String string, int n2, int n3) throws SQLException {
        super(baseConnection, n2, n3);
        this.preProcessSQL(string);
        try {
            this.implStatement.prepare();
        }
        catch (SQLException sQLException) {
            this.downgradeAndRetryPrepare(sQLException, string);
        }
        this.commonTransitionToState(2);
        this.parameterSets = new Vector();
        this.currentParameters = new BaseParameters(this.implStatement.sql.getParameterCount());
        this.resultSetConcurrency = this.concurrencyStrategy == 1 ? 1007 : 1008;
        this.resultSetScrollType = this.scrollingStrategy == 1 ? 1003 : (this.scrollingStrategy == 3 || this.scrollingStrategy == 2 ? 1004 : 1005);
    }

    public void addBatch() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.internalAddBatchForNonBatchExecution) {
                this.parameterSets.removeAllElements();
                this.parameterSets.addElement(this.currentParameters);
            } else {
                BaseParameters baseParameters = new BaseParameters(this.currentParameters);
                this.parameterSets.addElement(baseParameters);
            }
        }
    }

    public final void addBatch(String string) throws SQLException {
        throw this.exceptions.getException(6012, "addBatch(String sql)");
    }

    public void clearBatch() throws SQLException {
        this.parameterSets.removeAllElements();
    }

    public void clearParameters() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n2 = this.parameterSets.size();
            this.currentParameters.clearInput();
        }
    }

    public void close() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            if (this.state != 4) {
                this.clearParameters();
            }
            super.close();
        }
    }

    void downgradeAndRetryPrepare(SQLException sQLException, String string) throws SQLException {
        if (!this.downgrade()) {
            throw sQLException;
        }
        this.preProcessSQL(string);
        this.implStatement.prepare();
    }

    public boolean execute() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.commonTransitionToState(2);
            boolean bl = super.executeInternal();
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean execute(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            throw this.exceptions.getException(6012, "execute(String sql)");
        }
    }

    public int[] executeBatch() throws SQLException {
        int[] nArray = null;
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block7: {
                this.validateClosedState();
                int n2 = this.parameterSets.size();
                if (n2 == 0) {
                    int[] nArray2 = new int[]{};
                    Object var4_5 = null;
                    return nArray2;
                }
                try {
                    this.doingBatch = true;
                    if (this.implStatement.supportsBatchParameters() && !this.overrideNativeBatchSupport()) {
                        this.commonTransitionToState(1);
                        this.commonExecute();
                        nArray = this.implStatement.getBatchRowsAffectedCount();
                        break block7;
                    }
                    nArray = this.executeBatchEmulation();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.clearBatch();
                    this.doingBatch = false;
                    throw throwable;
                }
            }
            Object var7_6 = null;
            this.clearBatch();
            this.doingBatch = false;
        }
        return nArray;
    }

    /*
     * Exception decompiling
     */
    protected int[] executeBatchEmulation() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ResultSet executeQuery() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.parameterSets.size() > 0) {
                throw this.exceptions.getException(6054);
            }
            this.commonTransitionToState(2);
            ResultSet resultSet = super.executeQueryInternal();
            Object var3_3 = null;
            return resultSet;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw this.exceptions.getException(6012, "executeQuery(String sql)");
    }

    public int executeUpdate() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.commonTransitionToState(2);
            int n2 = super.executeUpdateInternal();
            Object var3_3 = null;
            return n2;
        }
    }

    public int executeUpdate(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            throw this.exceptions.getException(6012, "executeUpdate(String sql)");
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.currentColumns == null) {
                this.currentColumns = this.describeColumns();
            }
            if (this.currentColumns == null) {
                ResultSetMetaData resultSetMetaData = null;
                Object var3_4 = null;
                return resultSetMetaData;
            }
            BaseResultSetMetaData baseResultSetMetaData = new BaseResultSetMetaData(this, this.exceptions);
            Object var3_5 = null;
            return baseResultSetMetaData;
        }
    }

    void postImplExecute(boolean bl) throws SQLException {
        super.postImplExecute(bl);
        this.clearBatch();
    }

    void preImplExecute() throws SQLException {
        if (!this.doingBatch && this.parameterSets.size() != 1) {
            this.internalAddBatchForNonBatchExecution = true;
            this.addBatch();
            this.internalAddBatchForNonBatchExecution = false;
        }
        this.validateParameters();
        int n2 = this.parameterSets.size();
        Vector vector = new Vector(n2);
        int n3 = 0;
        while (n3 < n2) {
            vector.addElement(this.parameterSets.elementAt(n3));
            ++n3;
        }
        this.implStatement.setParameters(vector);
        super.preImplExecute();
    }

    public void setArray(int n2, Array array) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String[] stringArray = new String[]{"PreparedStatement.setArray"};
            throw this.exceptions.getException(6004, stringArray);
        }
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper(inputStream, n3, this.connection, this.exceptions);
            baseInputStreamWrapper.setIsInputStream();
            this.setObjectInternal(n2, baseInputStreamWrapper, 1015, -1, -1);
        }
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, bigDecimal, 1008, 2, -1);
        }
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper(inputStream, n3, this.connection, this.exceptions);
            baseInputStreamWrapper.setIsInputStream();
            this.setObjectInternal(n2, baseInputStreamWrapper, 1014, -4, -1);
        }
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, blob, 1020, 2004, -1);
        }
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, new Boolean(bl), 1009, -7, -1);
        }
    }

    public void setByte(int n2, byte by) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, new Byte(by), 1001, -6, -1);
        }
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, byArray, 1002, -3, -1);
        }
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            BaseCharacterStreamWrapper baseCharacterStreamWrapper = new BaseCharacterStreamWrapper(reader, n3, this.connection, this.exceptions);
            baseCharacterStreamWrapper.setIsInputStream();
            this.setObjectInternal(n2, baseCharacterStreamWrapper, 1018, -1, -1);
        }
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, clob, 1021, 2005, -1);
        }
    }

    public void setDate(int n2, Date date) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, date, 1011, 91, -1);
        }
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, BaseData.applyCalender(date, calendar, true), 1011, 91, -1);
        }
    }

    public void setDouble(int n2, double d2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, new Double(d2), 1007, 8, -1);
        }
    }

    public void setFloat(int n2, float f2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, new Float(f2), 1006, 7, -1);
        }
    }

    public void setInt(int n2, int n3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, new Integer(n3), 1004, 4, -1);
        }
    }

    public void setLong(int n2, long l2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, new Long(l2), 1005, -5, -1);
        }
    }

    public void setNull(int n2, int n3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, null, 1019, n3, -1);
        }
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setNull(n2, n3);
        }
    }

    public void setObject(int n2, Object object) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int n3 = BaseData.getJavaObjectType(object, 0);
            if (n3 == 1000) {
                throw this.exceptions.getException(6034);
            }
            object = this.wrapStreamFromSetObject(object);
            this.setObjectInternal(n2, object, n3, this.implStatement.implConnection.mapJavaTypeToSQLType(n3), -1);
        }
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int n4 = BaseData.getJavaObjectType(object, n3);
            if (n4 == 1000) {
                throw this.exceptions.getException(6034);
            }
            object = this.wrapStreamFromSetObject(object);
            this.setObjectInternal(n2, object, n4, n3, -1);
        }
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int n5 = BaseData.getJavaObjectType(object, n3);
            if (n5 == 1000) {
                throw this.exceptions.getException(6070);
            }
            object = this.wrapStreamFromSetObject(object);
            this.setObjectInternal(n2, object, n5, n3, n4);
        }
    }

    public void setObjectInternal(int n2, Object object, int n3, int n4, int n5) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateParameterIndex(n2);
            this.validateSqlType(n4);
            if (n5 != -1 && (n4 == 3 || n4 == 2)) {
                BaseData baseData = new BaseData(n3, object);
                object = baseData.getBigDecimal(n5, this.exceptions);
                n3 = 1008;
            }
            this.currentParameters.set(n2, 1, new BaseParameter(n4, n3, object));
        }
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String[] stringArray = new String[]{"PreparedStatement.setRef"};
            throw this.exceptions.getException(6004, stringArray);
        }
    }

    public void setShort(int n2, short s2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, new Short(s2), 1003, 5, -1);
        }
    }

    public void setString(int n2, String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, string, 1010, 12, -1);
        }
    }

    public void setTime(int n2, Time time) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, time, 1012, 92, -1);
        }
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, BaseData.applyCalender(time, calendar, true), 1012, 92, -1);
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, timestamp, 1013, 93, -1);
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.setObjectInternal(n2, BaseData.applyCalender(timestamp, calendar, true), 1013, 93, -1);
        }
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String[] stringArray = new String[]{"PreparedStatement.setUnicodeStream"};
            throw this.exceptions.getException(6004, stringArray);
        }
    }

    void validateParameterIndex(int n2) throws SQLException {
        if (!this.currentParameters.isValidOrdinal(n2)) {
            throw this.exceptions.getException(6011, "07009");
        }
    }

    private void validateParameters() throws SQLException {
        int n2 = this.parameterSets.size();
        int n3 = 0;
        while (n3 < n2) {
            BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(n3);
            this.validateParameters(baseParameters);
            ++n3;
        }
    }

    private void validateParameters(BaseParameters baseParameters) throws SQLException {
        if (baseParameters == null || !baseParameters.haveMinimalBindings()) {
            throw this.exceptions.getException(6011, "07009");
        }
    }

    void validateSqlType(int n2) throws SQLException {
        switch (n2) {
            case 0: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                throw this.exceptions.getException(6023, "HY004");
            }
        }
    }

    Object wrapStreamFromSetObject(Object object) {
        if (object instanceof InputStream) {
            BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper((InputStream)object, -1L, this.connection, this.exceptions);
            baseInputStreamWrapper.setIsInputStream();
            object = baseInputStreamWrapper;
        } else if (object instanceof Reader) {
            BaseCharacterStreamWrapper baseCharacterStreamWrapper = new BaseCharacterStreamWrapper((Reader)object, -1L, this.connection, this.exceptions);
            baseCharacterStreamWrapper.setIsInputStream();
            object = baseCharacterStreamWrapper;
        }
        return object;
    }
}

