/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseParameter;
import com.microsoft.util.UtilDebug;

public class BaseParameters {
    private static String footprint = "$Revision:   1.7.1.0  $";
    private BaseParameter[] parametersIn;
    private BaseParameter[] parametersOut;

    public BaseParameters(int n2) {
        this.parametersIn = new BaseParameter[n2];
        this.parametersOut = new BaseParameter[n2];
    }

    public BaseParameters(BaseParameters baseParameters) {
        this.parametersIn = new BaseParameter[baseParameters.parametersIn.length];
        this.parametersOut = new BaseParameter[baseParameters.parametersOut.length];
        int n2 = 0;
        while (n2 < this.parametersIn.length) {
            if (baseParameters.parametersIn[n2] != null) {
                this.parametersIn[n2] = new BaseParameter(baseParameters.parametersIn[n2]);
            }
            if (baseParameters.parametersOut[n2] != null) {
                this.parametersOut[n2] = new BaseParameter(baseParameters.parametersOut[n2]);
            }
            ++n2;
        }
    }

    public void clearInput() {
        int n2 = 0;
        while (n2 < this.count()) {
            this.parametersIn[n2] = null;
            ++n2;
        }
    }

    public int count() {
        return this.parametersIn.length;
    }

    public boolean directionSet(int n2) {
        boolean bl = false;
        return bl;
    }

    public BaseParameter get(int n2, int n3) {
        BaseParameter baseParameter = null;
        if (n3 == 1) {
            baseParameter = this.parametersIn[n2 - 1];
        } else if (n3 == 2) {
            baseParameter = this.parametersOut[n2 - 1];
        } else {
            UtilDebug.assert("IN / OUT parameters are maintained as separate instances", false);
        }
        return baseParameter;
    }

    protected boolean haveMinimalBindings() {
        boolean bl = true;
        int n2 = this.count();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            if (this.parametersIn[n5] != null) {
                ++n3;
            } else if (this.parametersOut[n5] != null) {
                ++n4;
            }
            ++n5;
        }
        if (n3 + n4 < n2) {
            bl = false;
        }
        return bl;
    }

    boolean isValidOrdinal(int n2) {
        return n2 > 0 && n2 <= this.count();
    }

    public void set(int n2, int n3, BaseParameter baseParameter) {
        if (n3 == 1) {
            this.parametersIn[n2 - 1] = baseParameter;
        } else if (n3 == 2) {
            this.parametersOut[n2 - 1] = baseParameter;
        } else {
            UtilDebug.assert("IN / OUT parameters are maintained as separate instances", false);
        }
    }
}

