/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseLongData;
import java.io.IOException;
import java.io.InputStream;

public class BaseInputStreamWrapper
extends InputStream
implements BaseLongData {
    private static String footprint = "$Revision:   1.12.1.0  $";
    BaseConnection connection;
    Object synchronizer;
    InputStream is;
    boolean closed = false;
    long numTotalBytesInStream;
    long numBytesReturned = 0L;
    long maxBytesToReturn = Long.MAX_VALUE;
    boolean isOutputStream = true;
    BaseExceptions exceptions;

    BaseInputStreamWrapper(InputStream inputStream, long l2, BaseConnection baseConnection, BaseExceptions baseExceptions) {
        this.is = inputStream;
        this.exceptions = baseExceptions;
        this.numTotalBytesInStream = l2;
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    public int available() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            int n2 = this.is.available();
            Object var3_3 = null;
            return n2;
        }
    }

    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.is.close();
                this.closed = true;
            }
        }
    }

    public long length() {
        return this.numTotalBytesInStream;
    }

    public synchronized void mark(int n2) {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.is.mark(n2);
            }
        }
    }

    public boolean markSupported() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                boolean bl = this.is.markSupported();
                Object var3_3 = null;
                return bl;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numBytesReturned == this.maxBytesToReturn) {
                return -1;
            }
            int n2 = this.is.read();
            if (this.numTotalBytesInStream != -1L) {
                boolean bl = false;
                if (n2 != -1) {
                    ++this.numBytesReturned;
                    if (this.numBytesReturned > this.numTotalBytesInStream) {
                        return -2;
                    }
                } else if (this.numBytesReturned != this.numTotalBytesInStream) {
                    return -2;
                }
                if (!bl) return n2;
                return -2;
            }
            if (n2 <= -1) return n2;
            ++this.numBytesReturned;
            return n2;
        }
    }

    public int read(byte[] byArray) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            int n2 = this.read(byArray, 0, byArray.length);
            Object var4_4 = null;
            return n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numBytesReturned >= this.maxBytesToReturn) {
                return -1;
            }
            if (byArray.length - n2 < n3) {
                throw new IOException(this.exceptions.getException(6066).getMessage());
            }
            if (this.numBytesReturned + (long)n3 > this.maxBytesToReturn) {
                n3 = new Long(this.maxBytesToReturn - this.numBytesReturned).intValue();
            }
            int n4 = this.is.read(byArray, n2, n3);
            if (this.numTotalBytesInStream != -1L) {
                boolean bl = false;
                if (n4 != -1) {
                    this.numBytesReturned += (long)n4;
                    if (this.numBytesReturned > this.numTotalBytesInStream) {
                        return -2;
                    }
                } else if (this.numBytesReturned != this.numTotalBytesInStream) {
                    return -2;
                }
                if (!bl) return n4;
                return -2;
            }
            if (n4 <= -1) return n4;
            this.numBytesReturned += (long)n4;
            return n4;
        }
    }

    public synchronized void reset() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            this.is.reset();
        }
    }

    void setIsInputStream() {
        this.isOutputStream = false;
    }

    public long skip(long l2) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            long l3 = this.is.skip(l2);
            Object var6_4 = null;
            return l3;
        }
    }

    void validateClosedState() throws IOException {
        if (this.closed || this.connection != null && this.connection.isClosed()) {
            throw new IOException(this.exceptions.getException(6010).getMessage());
        }
    }
}

