/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseColumn;
import com.microsoft.jdbc.base.BaseData;
import com.microsoft.jdbc.base.BaseFileChunkCharStream;
import com.microsoft.jdbc.base.BaseFileChunkInputStream;
import com.microsoft.jdbc.base.BaseImplBlob;
import com.microsoft.jdbc.base.BaseImplClob;
import com.microsoft.jdbc.base.BaseImplServiceResultSet;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilPagedTempBuffer;
import com.microsoft.util.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.sql.SQLException;

public final class BaseImplStaticCursorResultSet
extends BaseImplServiceResultSet {
    private static String footprint = "$Revision:   1.16.1.4.1.0  $";
    private File longDataFileHandle;
    private RandomAccessFile longDataFile;
    UtilPagedTempBuffer rowDataBuff;
    UtilPagedTempBuffer rowPositionBuff;
    private int rowsFetchedFromSubResultSet = 0;
    private BaseData[] rowData;
    private boolean endOfResultSetReached = false;
    byte[] byteArrayForReading;
    static int DEFAULT_BUFF_INCREMENT = 1024;

    private void cacheBinaryStream(int n2, InputStream inputStream) throws IOException, UtilException {
        this.rowDataBuff.writeInt(n2);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l2 = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        byte[] byArray = new byte[1024];
        int n3 = inputStream.read(byArray, 0, 1024);
        while (n3 != -1) {
            this.longDataFile.write(byArray, 0, n3);
            l2 += (long)n3;
            n3 = inputStream.read(byArray, 0, 1024);
        }
        this.rowDataBuff.writeLong(l2);
    }

    private void cacheBlob(BaseImplBlob baseImplBlob) throws SQLException, IOException, UtilException {
        this.rowDataBuff.writeInt(1020);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeBlob(this.longDataFile, baseImplBlob);
    }

    private void cacheCharacterStream(int n2, Reader reader) throws IOException, UtilException {
        this.rowDataBuff.writeInt(n2);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l2 = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        char[] cArray = new char[1024];
        int n3 = reader.read(cArray, 0, 1024);
        while (n3 != -1) {
            int n4 = 0;
            while (n4 < n3) {
                this.longDataFile.writeChar(cArray[n4]);
                ++n4;
            }
            l2 += (long)(n3 * 2);
            n3 = reader.read(cArray, 0, 1024);
        }
        this.rowDataBuff.writeLong(l2);
    }

    private void cacheClob(BaseImplClob baseImplClob) throws SQLException, IOException, UtilException {
        this.rowDataBuff.writeInt(1021);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeClob(this.longDataFile, baseImplClob);
    }

    void cacheCurrentRow() throws SQLException {
        try {
            this.rowPositionBuff.writeLong(this.rowDataBuff.getSize());
            int n2 = 0;
            while (n2 < this.columns.count(0)) {
                BaseColumn baseColumn = this.columns.get(n2 + 1);
                BaseData baseData = this.subImplResultSet.getData(n2 + 1, baseColumn.baseDataType);
                switch (baseData.type) {
                    case 1001: 
                    case 1002: 
                    case 1003: 
                    case 1004: 
                    case 1005: 
                    case 1006: 
                    case 1007: 
                    case 1008: 
                    case 1009: 
                    case 1010: 
                    case 1011: 
                    case 1012: 
                    case 1013: {
                        this.rowDataBuff.writeInt(baseData.type);
                        String string = baseData.getString(-1, this.implStatement.implConnection.exceptions);
                        byte[] byArray = string.getBytes();
                        this.rowDataBuff.writeInt(byArray.length);
                        this.rowDataBuff.write(this.rowDataBuff.getSize(), byArray);
                        break;
                    }
                    case 1019: {
                        this.rowDataBuff.writeInt(1019);
                        this.rowDataBuff.writeInt(0);
                        break;
                    }
                    case 1014: 
                    case 1015: {
                        this.cacheBinaryStream(baseData.type, (InputStream)baseData.data);
                        break;
                    }
                    case 1020: {
                        this.cacheBlob((BaseImplBlob)baseData.data);
                        break;
                    }
                    case 1018: {
                        this.cacheCharacterStream(1018, (Reader)baseData.data);
                        break;
                    }
                    case 1021: {
                        this.cacheClob((BaseImplClob)baseData.data);
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6040);
        }
    }

    public void close() throws SQLException {
        super.close();
        try {
            this.rowDataBuff.truncate();
            this.rowPositionBuff.truncate();
            this.longDataFile.close();
            this.longDataFileHandle.delete();
        }
        catch (Exception exception) {}
    }

    private boolean fetch(int n2) throws SQLException {
        boolean bl = true;
        if (n2 > this.rowsFetchedFromSubResultSet) {
            bl = this.fetchAndCache(n2 - this.rowsFetchedFromSubResultSet);
        }
        return bl;
    }

    boolean fetchAndCache(int n2) throws SQLException {
        boolean bl = true;
        int n3 = 0;
        while (bl && n3 < n2) {
            bl = this.endOfResultSetReached ? false : this.subImplResultSet.positionCursor(this.rowsFetchedFromSubResultSet + 1);
            if (bl) {
                ++this.rowsFetchedFromSubResultSet;
                this.cacheCurrentRow();
            } else {
                this.endOfResultSetReached = true;
                if (this.notificationSink != null) {
                    this.notificationSink.endOfResultSetReached(this.rowsFetchedFromSubResultSet);
                }
            }
            ++n3;
        }
        return bl;
    }

    private void getCachedBinaryStream(int n2, long l2, BaseData baseData) throws IOException, UtilException {
        long l3 = this.rowDataBuff.readLong(l2);
        long l4 = this.rowDataBuff.readLong(l2 + 8L);
        BaseFileChunkInputStream baseFileChunkInputStream = new BaseFileChunkInputStream(this.longDataFile, l3, l4);
        baseData.data = baseFileChunkInputStream;
        baseData.type = n2;
    }

    private void getCachedBlob(long l2, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l2);
        baseData.data = this.subImplResultSet.readBlob(this.longDataFile);
        baseData.type = 1020;
    }

    private void getCachedCharStream(int n2, long l2, BaseData baseData) throws IOException, UtilException {
        long l3 = this.rowDataBuff.readLong(l2);
        long l4 = this.rowDataBuff.readLong(l2 + 8L);
        BaseFileChunkCharStream baseFileChunkCharStream = new BaseFileChunkCharStream(this.longDataFile, l3, l4);
        baseData.data = baseFileChunkCharStream;
        baseData.type = n2;
    }

    private void getCachedClob(long l2, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l2);
        baseData.data = this.subImplResultSet.readClob(this.longDataFile);
        baseData.type = 1021;
    }

    boolean getCachedRow(int n2) throws SQLException {
        boolean bl = false;
        try {
            long l2 = n2 * 8;
            long l3 = this.rowPositionBuff.readLong((int)l2);
            this.intializeRow();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < this.columns.count(0)) {
                int n4 = this.rowDataBuff.readInt(l3);
                l3 += 4L;
                if (n4 == 1015 || n4 == 1014) {
                    this.getCachedBinaryStream(n4, l3, this.rowData[n3]);
                    l3 += 16L;
                } else if (n4 == 1018) {
                    this.getCachedCharStream(n4, l3, this.rowData[n3]);
                    l3 += 16L;
                } else if (n4 == 1020) {
                    this.getCachedBlob(this.rowDataBuff.readLong(l3), this.rowData[n3]);
                    l3 += 8L;
                } else if (n4 == 1021) {
                    this.getCachedClob(this.rowDataBuff.readLong(l3), this.rowData[n3]);
                    l3 += 8L;
                } else {
                    int n5 = this.rowDataBuff.readInt(l3);
                    l3 += 4L;
                    if (n4 != 1019) {
                        stringBuffer.setLength(0);
                        if (n5 > this.byteArrayForReading.length) {
                            int n6 = n5 + DEFAULT_BUFF_INCREMENT;
                            this.byteArrayForReading = new byte[n6];
                        }
                        this.rowDataBuff.read(l3, this.byteArrayForReading, 0, n5);
                        l3 += (long)n5;
                        this.rowData[n3].data = new String(this.byteArrayForReading, 0, n5);
                        this.rowData[n3].type = 1010;
                    }
                    switch (n4) {
                        case 1001: {
                            this.rowData[n3].data = new Byte(this.rowData[n3].getByte(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1002: {
                            this.rowData[n3].data = this.rowData[n3].getBytes(-1, this.implStatement.implConnection.exceptions);
                            break;
                        }
                        case 1003: {
                            this.rowData[n3].data = new Short(this.rowData[n3].getShort(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1004: {
                            this.rowData[n3].data = new Integer(this.rowData[n3].getInteger(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1005: {
                            this.rowData[n3].data = new Long(this.rowData[n3].getLong(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1006: {
                            this.rowData[n3].data = new Float(this.rowData[n3].getFloat(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1007: {
                            this.rowData[n3].data = new Double(this.rowData[n3].getDouble(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1008: {
                            this.rowData[n3].data = this.rowData[n3].getBigDecimal(this.implStatement.implConnection.exceptions);
                            break;
                        }
                        case 1009: {
                            this.rowData[n3].data = new Boolean(this.rowData[n3].getBoolean(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1011: {
                            this.rowData[n3].data = this.rowData[n3].getDate(this.implStatement.implConnection.exceptions);
                            break;
                        }
                        case 1012: {
                            this.rowData[n3].data = this.rowData[n3].getTime(this.implStatement.implConnection.exceptions);
                            break;
                        }
                        case 1013: {
                            this.rowData[n3].data = this.rowData[n3].getTimestamp(this.implStatement.implConnection.exceptions);
                            break;
                        }
                        case 1019: {
                            this.rowData[n3].data = null;
                            break;
                        }
                    }
                    this.rowData[n3].type = n4;
                }
                ++n3;
            }
            bl = true;
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6041);
        }
        return bl;
    }

    public int getColumnAccess() {
        return 2;
    }

    public BaseData getData(int n2, int n3) throws SQLException {
        return this.rowData[n2 - 1];
    }

    public int getScrollType() {
        return 1004;
    }

    private void intializeRow() {
        if (this.rowData == null) {
            this.rowData = new BaseData[this.columns.count(0)];
            int n2 = 0;
            while (n2 < this.columns.count(0)) {
                BaseColumn baseColumn = this.columns.get(n2 + 1);
                this.rowData[n2] = new BaseData();
                ++n2;
            }
        }
    }

    public boolean positionCursor(int n2) throws SQLException {
        boolean bl = this.fetch(n2);
        if (bl) {
            this.fetch(n2 + 1);
        }
        if (bl) {
            bl = n2 > this.rowsFetchedFromSubResultSet ? false : this.getCachedRow(n2 - 1);
        }
        return bl;
    }

    public void postSetupInitialize() throws SQLException {
        this.rowDataBuff = new UtilPagedTempBuffer();
        this.rowPositionBuff = new UtilPagedTempBuffer();
        this.byteArrayForReading = new byte[DEFAULT_BUFF_INCREMENT];
        this.setupTempFiles();
        super.postSetupInitialize();
        this.positionCursor(1);
    }

    public void setFetchSize(int n2) {
    }

    private void setupTempFiles() throws SQLException {
        try {
            this.longDataFileHandle = UtilTempFile.createTempFile("scb_");
            this.longDataFile = new RandomAccessFile(this.longDataFileHandle, "rw");
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039);
        }
    }
}

