/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseColumn;
import com.microsoft.jdbc.base.BaseData;
import com.microsoft.jdbc.base.BaseImplServiceResultSet;
import com.microsoft.jdbc.base.BaseResultSetSortDescriptor;
import com.microsoft.util.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;

public final class BaseImplSortCursorResultSet
extends BaseImplServiceResultSet {
    private static String footprint = "$Revision:   1.6.1.0.1.0  $";
    private File rowPositionFileHandle;
    private RandomAccessFile rowPositionFile;
    boolean haveSortedRows = false;
    BaseResultSetSortDescriptor sortDescriptor;
    private BaseData[] sortedRow;
    private BaseData[] nextRowToBeSorted;
    int maxCursorPosition = 0;

    public void close() throws SQLException {
        super.close();
        try {
            this.rowPositionFile.close();
            this.rowPositionFileHandle.delete();
        }
        catch (IOException iOException) {}
    }

    private boolean compareCurrentRows() throws SQLException {
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.sortDescriptor.getSortCount() && n3 == 0) {
            int n4 = this.sortDescriptor.getSortColumnOrdinal(n2);
            n3 = BaseData.compare(this.nextRowToBeSorted[n4 - 1], this.sortedRow[n4 - 1], BaseData.mapJDBCTypeToJavaObjectType(this.columns.get((int)n4).type), this.implStatement.implConnection.exceptions);
            ++n2;
        }
        return n3 >= 0;
    }

    public void endOfResultSetReached(int n2) {
        this.maxCursorPosition = n2;
        if (this.notificationSink != null) {
            this.notificationSink.endOfResultSetReached(n2);
        }
    }

    private void fetchAndSortRows() throws SQLException {
        boolean bl;
        int n2 = 1;
        do {
            if (!(bl = this.subImplResultSet.positionCursor(n2))) continue;
            this.getCurrentFromSubResultSet(this.nextRowToBeSorted, false);
            this.insertSubResultSetRowIntoSortList(n2);
            ++n2;
        } while (bl);
        this.haveSortedRows = true;
    }

    public int getColumnAccess() {
        return 2;
    }

    private void getCurrentFromSubResultSet(BaseData[] baseDataArray, boolean bl) throws SQLException {
        if (bl) {
            int n2 = this.sortDescriptor.getSortCount();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.sortDescriptor.getSortColumnOrdinal(n3);
                BaseData baseData = this.subImplResultSet.getData(n4, this.columns.get((int)n4).baseDataType);
                baseDataArray[n4 - 1].data = baseData.data;
                baseDataArray[n4 - 1].type = baseData.type;
                ++n3;
            }
        } else {
            int n5 = this.columns.count(1);
            int n6 = 1;
            while (n6 <= n5) {
                BaseData baseData = this.subImplResultSet.getData(n6, this.columns.get((int)n6).baseDataType);
                baseDataArray[n6 - 1].data = baseData.data;
                baseDataArray[n6 - 1].type = baseData.type;
                ++n6;
            }
        }
    }

    public BaseData getData(int n2, int n3) throws SQLException {
        return this.sortedRow[n2 - 1];
    }

    private void getSortedFromSubResultSet(int n2, boolean bl) throws SQLException {
        try {
            this.rowPositionFile.seek((n2 - 1) * 4);
            n2 = this.rowPositionFile.readInt();
            this.subImplResultSet.positionCursor(n2);
            this.getCurrentFromSubResultSet(this.sortedRow, bl);
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039);
        }
    }

    private void initializeRows() {
        int n2 = this.columns.count(1);
        this.sortedRow = new BaseData[n2];
        this.nextRowToBeSorted = new BaseData[n2];
        int n3 = 0;
        while (n3 < n2) {
            BaseColumn baseColumn = this.columns.get(n3 + 1);
            this.sortedRow[n3] = new BaseData();
            this.nextRowToBeSorted[n3] = new BaseData();
            ++n3;
        }
    }

    private void insertSubResultSetRowIntoSortList(int n2) throws SQLException {
        try {
            int n3;
            int n4;
            int n5 = 0;
            boolean bl = true;
            if (n2 != 1) {
                int n6;
                n4 = 1;
                n3 = n2;
                int n7 = (n4 + n3) / 2;
                boolean bl2 = false;
                do {
                    n6 = n7;
                    this.getSortedFromSubResultSet(n7, true);
                    bl = this.compareCurrentRows();
                    if (bl) {
                        n4 = n7;
                        bl2 = true;
                        continue;
                    }
                    n3 = n7;
                    bl2 = false;
                } while (n6 != (n7 = (n4 + n3) / 2));
                n5 = n7 - 1 + (bl2 ? 1 : 0);
            }
            n4 = n2;
            n3 = 0;
            while (n5 < n2) {
                if (n5 != n2 - 1) {
                    this.rowPositionFile.seek(n5 * 4);
                    n3 = this.rowPositionFile.readInt();
                }
                this.rowPositionFile.seek(n5 * 4);
                this.rowPositionFile.writeInt(n4);
                n4 = n3;
                ++n5;
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6044);
        }
    }

    public boolean positionCursor(int n2) throws SQLException {
        boolean bl;
        if (!this.haveSortedRows) {
            this.initializeRows();
            this.fetchAndSortRows();
        }
        if (n2 <= this.maxCursorPosition) {
            this.getSortedFromSubResultSet(n2, false);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void postSetupInitialize() throws SQLException {
        this.setupTempFile();
        super.postSetupInitialize();
    }

    public void setFetchSize(int n2) {
    }

    public void setSortCriteria(BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        this.sortDescriptor = baseResultSetSortDescriptor;
    }

    private void setupTempFile() throws SQLException {
        try {
            this.rowPositionFileHandle = UtilTempFile.createTempFile("srt_");
            this.rowPositionFile = new RandomAccessFile(this.rowPositionFileHandle, "rw");
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039);
        }
    }
}

