/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplCachedClob;
import com.microsoft.jdbc.base.BaseImplClob;
import com.microsoft.util.UtilBoyerMooreSearchStrategy;
import com.microsoft.util.UtilBruteForceSearchStrategy;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilSearchStrategy;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class BaseImplSearchableClob
extends BaseImplCachedClob {
    private static String footprint = "$Revision:   1.1.1.0  $";
    private UtilSearchStrategy searchStrategy = new UtilBoyerMooreSearchStrategy();

    public BaseImplSearchableClob(BaseImplClob baseImplClob, BaseExceptions baseExceptions) {
        super(baseImplClob, baseExceptions);
    }

    public long find(String string, long l2) throws SQLException {
        byte[] byArray;
        UtilSearchStrategy utilSearchStrategy = this.searchStrategy;
        if (string.length() == 1) {
            utilSearchStrategy = new UtilBruteForceSearchStrategy();
        }
        if (l2 > Integer.MAX_VALUE) {
            throw this.exceptions.getException(6069);
        }
        this.fetchDataToCache(l2, new Long(this.getLength() - l2 - 1L).intValue());
        String string2 = BaseImplClob.getEncodingName(this.getCharacterEncoding());
        int n2 = BaseImplClob.getBytesPerChar(this);
        int n3 = new Long(l2).intValue() * n2;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw this.exceptions.getException(unsupportedEncodingException);
        }
        try {
            int n4 = utilSearchStrategy.find(this.getCachedData(), byArray, n3);
            if (n4 > 0) {
                n4 /= n2;
            }
            return n4;
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public boolean supportsSearch() {
        return true;
    }
}

