/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplClob;
import com.microsoft.jdbc.base.BaseImplClobService;
import java.sql.SQLException;

public class BaseImplChunkedClob
extends BaseImplClobService {
    private static String footprint = "$Revision:   1.1.1.0  $";
    private int maxChunkSize;

    public BaseImplChunkedClob(int n2, BaseImplClob baseImplClob, BaseExceptions baseExceptions) {
        super(baseImplClob, baseExceptions);
        this.maxChunkSize = n2 / BaseImplClob.getBytesPerChar(this.subImplClob);
    }

    public long getMaxChunkSize() {
        return 0L;
    }

    public int readData(byte[] byArray, int n2, long l2, int n3) throws SQLException {
        int n4 = n3;
        int n5 = BaseImplClob.getBytesPerChar(this.subImplClob);
        while (n4 > 0) {
            int n6 = this.maxChunkSize;
            if (n4 < this.maxChunkSize) {
                n6 = n4;
            }
            int n7 = this.subImplClob.readData(byArray, n2, l2, n6);
            int n8 = n7 / n5;
            n4 -= n8;
            n2 += n7;
            l2 += (long)n8;
        }
        return n3 * n5;
    }

    public int writeData(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n3;
        int n5 = BaseImplClob.getBytesPerChar(this.subImplClob);
        int n6 = this.maxChunkSize / n5;
        while (n4 > 0) {
            int n7 = n6;
            if (n4 < n6) {
                n7 = n4;
            }
            int n8 = this.subImplClob.writeData(l2, byArray, n2, n7);
            int n9 = n8 * n5;
            n4 -= n8;
            n2 += n9;
            l2 += (long)n8;
        }
        return n3;
    }
}

