/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplBlob;
import com.microsoft.jdbc.base.BaseImplBlobService;
import com.microsoft.util.UtilDebug;
import java.sql.SQLException;

public class BaseImplCachedBlob
extends BaseImplBlobService {
    private static String footprint = "$Revision:   1.3.1.0  $";
    private int cacheStartOffset = -1;
    private int cacheEndOffset = -1;
    private byte[] cachedData = null;

    public BaseImplCachedBlob(BaseImplBlob baseImplBlob, BaseExceptions baseExceptions) {
        super(baseImplBlob, baseExceptions);
    }

    private void createCacheBuffer() throws SQLException {
        if (this.cachedData == null) {
            int n2;
            try {
                n2 = new Long(this.subImplBlob.getLength()).intValue();
            }
            catch (Exception exception) {
                throw this.exceptions.getException(6067);
            }
            this.cachedData = new byte[n2 + 1];
        }
    }

    protected void fetchDataToCache(long l2, int n2) throws SQLException {
        UtilDebug.assert("blobOffset must be positive", l2 > 0L);
        UtilDebug.assert("numBytesToRead must be non-negative", n2 >= 0);
        this.createCacheBuffer();
        if (l2 + (long)n2 > Integer.MAX_VALUE) {
            throw this.exceptions.getException(6067);
        }
        int n3 = new Long(l2).intValue();
        int n4 = new Long(l2 + (long)n2).intValue();
        if (this.cacheStartOffset == -1 || this.cacheEndOffset == -1) {
            UtilDebug.assert("Invalid Cache State", this.cacheStartOffset == -1 && this.cacheEndOffset == -1);
            int n5 = n4 - n3;
            if (n5 > 0) {
                this.subImplBlob.readData(this.cachedData, n3, n3, n5);
                this.cacheStartOffset = n3;
                this.cacheEndOffset = n4 - 1;
            }
        } else {
            int n6;
            if (n3 < this.cacheStartOffset && (n6 = this.cacheStartOffset - n3) > 0) {
                this.subImplBlob.readData(this.cachedData, n3, n3, n6);
                this.cacheStartOffset = n3;
            }
            if (n4 > this.cacheEndOffset && (n6 = n4 - (n3 = this.cacheEndOffset + 1)) > 0) {
                this.subImplBlob.readData(this.cachedData, n3, n3, n6);
                this.cacheEndOffset = n4 - 1;
            }
        }
    }

    protected byte[] getCachedData() {
        return this.cachedData;
    }

    public int readData(byte[] byArray, int n2, long l2, int n3) throws SQLException {
        this.fetchDataToCache(l2, n3);
        int n4 = new Long(l2).intValue();
        System.arraycopy(this.cachedData, n4, byArray, n2, n3);
        return n3;
    }
}

