/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseLongData;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

class BaseFileChunkInputStream
extends InputStream
implements BaseLongData {
    private static String footprint = "$Revision:   1.3.1.0  $";
    RandomAccessFile file;
    long length;
    long position;
    long offset;

    protected BaseFileChunkInputStream(RandomAccessFile randomAccessFile, long l2, long l3) {
        this.file = randomAccessFile;
        this.offset = l2;
        this.length = l3;
        this.position = 0L;
    }

    public int available() throws IOException {
        return (int)(this.length - this.position);
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int n2) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n2;
        if (this.position == 0L) {
            this.file.seek(this.offset);
        }
        if (this.position == this.length) {
            n2 = -1;
        } else {
            n2 = this.file.readByte() & 0xFF;
            ++this.position;
        }
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length && n3 > -1) {
            n3 = this.read();
            if (n3 != -1) {
                byArray[n4] = (byte)n3;
                ++n2;
            }
            ++n4;
        }
        return n2 == 0 ? -1 : n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3 && n5 > -1) {
            n5 = this.read();
            if (n5 != -1) {
                byArray[n2 + n6] = (byte)n5;
                ++n4;
            }
            ++n6;
        }
        return n4 == 0 ? -1 : n4;
    }

    public synchronized void reset() throws IOException {
    }

    public long skip(long l2) throws IOException {
        long l3 = this.length - this.position;
        if (l2 > l3) {
            l2 = l3;
        }
        this.file.skipBytes((int)l2);
        return l2;
    }
}

