/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseBlob;
import com.microsoft.jdbc.base.BaseCharacterStreamWrapper;
import com.microsoft.jdbc.base.BaseClob;
import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplBlob;
import com.microsoft.jdbc.base.BaseImplClob;
import com.microsoft.jdbc.base.BaseInputStreamWrapper;
import com.microsoft.util.UtilASCIIInputStreamToCharacterReader;
import com.microsoft.util.UtilBinaryToASCIIInputStream;
import com.microsoft.util.UtilCharacterReaderToASCIIInputStream;
import com.microsoft.util.UtilDataConversions;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilStringFunctions;
import com.microsoft.util.UtilTransliterator;
import com.microsoft.util.UtilUCS2InputStreamToCharacterReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class BaseData {
    private static String footprint = "$Revision:   1.63.1.2.1.0  $";
    public static final int UNKNOWN_DATA_OBJECT = 1000;
    public static final int BYTE = 1001;
    public static final int BYTE_ARRAY = 1002;
    public static final int SHORT = 1003;
    public static final int INTEGER = 1004;
    public static final int LONG = 1005;
    public static final int FLOAT = 1006;
    public static final int DOUBLE = 1007;
    public static final int BIGDECIMAL = 1008;
    public static final int BOOLEAN = 1009;
    public static final int STRING = 1010;
    public static final int DATE = 1011;
    public static final int TIME = 1012;
    public static final int TIMESTAMP = 1013;
    public static final int BINARYINPUTSTREAM = 1014;
    public static final int ASCIIINPUTSTREAM = 1015;
    public static final int UTF8INPUTSTREAM = 1016;
    public static final int UCS2INPUTSTREAM = 1017;
    public static final int CHARACTERSTREAMREADER = 1018;
    public static final int NULL = 1019;
    public static final int BLOB = 1020;
    public static final int CLOB = 1021;
    private static final int DEFAULT_CHUNK_LEN = 10240;
    private static final int MAX_CHUNK_LEN = Integer.MAX_VALUE;
    public int type;
    public Object data;

    BaseData() {
    }

    public BaseData(int n2, Object object) {
        this.type = n2;
        this.data = object;
    }

    public BaseData(Object object) {
        this.setData(object);
    }

    static Date applyCalender(Date date, Calendar calendar, boolean bl) {
        calendar = (Calendar)calendar.clone();
        if (bl) {
            calendar.setTime(date);
            int n2 = calendar.get(1) - 1900;
            int n3 = calendar.get(2);
            int n4 = calendar.get(5);
            return new Date(n2, n3, n4);
        }
        calendar.clear();
        calendar.set(date.getYear() + 1900, date.getMonth(), date.getDate(), 0, 0, 0);
        return new Date(calendar.getTime().getTime());
    }

    static Time applyCalender(Time time, Calendar calendar, boolean bl) {
        calendar = (Calendar)calendar.clone();
        if (bl) {
            calendar.setTime(time);
            int n2 = calendar.get(11);
            int n3 = calendar.get(12);
            int n4 = calendar.get(13);
            return new Time(n2, n3, n4);
        }
        calendar.clear();
        calendar.set(1970, 0, 1, time.getHours(), time.getMinutes(), time.getSeconds());
        return new Time(calendar.getTime().getTime());
    }

    static Timestamp applyCalender(Timestamp timestamp, Calendar calendar, boolean bl) {
        calendar = (Calendar)calendar.clone();
        if (bl) {
            calendar.setTime(timestamp);
            int n2 = calendar.get(1) - 1900;
            int n3 = calendar.get(2);
            int n4 = calendar.get(5);
            int n5 = calendar.get(11);
            int n6 = calendar.get(12);
            int n7 = calendar.get(13);
            int n8 = timestamp.getNanos();
            timestamp = new Timestamp(n2, n3, n4, n5, n6, n7, n8);
        } else {
            int n9 = timestamp.getYear();
            int n10 = timestamp.getMonth();
            int n11 = timestamp.getDate();
            int n12 = timestamp.getHours();
            int n13 = timestamp.getMinutes();
            int n14 = timestamp.getSeconds();
            int n15 = timestamp.getNanos();
            calendar.clear();
            calendar.set(n9 + 1900, n10, n11, n12, n13, n14);
            timestamp = new Timestamp(calendar.getTime().getTime());
            timestamp.setNanos(n15);
        }
        return timestamp;
    }

    public static int compare(BaseData baseData, BaseData baseData2, int n2, BaseExceptions baseExceptions) throws SQLException {
        int n3 = 0;
        switch (n2) {
            case 1010: {
                String string = baseData.getString(-1, baseExceptions);
                String string2 = baseData2.getString(-1, baseExceptions);
                n3 = UtilStringFunctions.CompareStrings(string, string2);
                break;
            }
            case 1004: {
                int n4 = baseData.getInteger(baseExceptions);
                int n5 = baseData2.getInteger(baseExceptions);
                if (n4 > n5) {
                    n3 = 1;
                    break;
                }
                if (n4 < n5) {
                    n3 = -1;
                    break;
                }
                n3 = 0;
                break;
            }
            case 1003: {
                short s2 = baseData.getShort(baseExceptions);
                short s3 = baseData2.getShort(baseExceptions);
                if (s2 > s3) {
                    n3 = 1;
                    break;
                }
                if (s2 < s3) {
                    n3 = -1;
                    break;
                }
                n3 = 0;
                break;
            }
            case 1009: {
                boolean bl = baseData.getBoolean(baseExceptions);
                boolean bl2 = baseData2.getBoolean(baseExceptions);
                if (bl && !bl2) {
                    n3 = 1;
                    break;
                }
                if (!bl && bl2) {
                    n3 = -1;
                    break;
                }
                n3 = 0;
                break;
            }
        }
        return n3;
    }

    public InputStream getASCIIStream(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        try {
            InputStream inputStream = null;
            int n3 = -1;
            switch (this.type) {
                case 1015: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 1014: {
                    inputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    break;
                }
                case 1002: {
                    inputStream = new UtilBinaryToASCIIInputStream(new ByteArrayInputStream((byte[])this.data));
                    n3 = ((byte[])this.data).length;
                    break;
                }
                case 1010: {
                    inputStream = UtilDataConversions.stringToASCIIInputStream((String)this.data);
                    n3 = ((String)this.data).length();
                    break;
                }
                case 1018: {
                    inputStream = new UtilCharacterReaderToASCIIInputStream((Reader)this.data);
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n3, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n2;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public BigDecimal getBigDecimal(int n2, BaseExceptions baseExceptions) throws SQLException {
        try {
            BigDecimal bigDecimal = this.getBigDecimal(baseExceptions);
            if (bigDecimal != null) {
                try {
                    bigDecimal = bigDecimal.setScale(n2, 7);
                }
                catch (ArithmeticException arithmeticException) {
                    bigDecimal = bigDecimal.setScale(n2, 4);
                }
            }
            return bigDecimal;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public BigDecimal getBigDecimal(BaseExceptions baseExceptions) throws SQLException {
        try {
            BigDecimal bigDecimal = null;
            switch (this.type) {
                case 1008: {
                    bigDecimal = (BigDecimal)this.data;
                    break;
                }
                case 1010: {
                    bigDecimal = new BigDecimal(((String)this.data).trim());
                    break;
                }
                case 1001: {
                    bigDecimal = new BigDecimal(((Byte)this.data).toString());
                    break;
                }
                case 1015: 
                case 1017: {
                    String string = this.getString(-1, baseExceptions);
                    bigDecimal = new BigDecimal(string.trim());
                    break;
                }
                case 1003: 
                case 1004: 
                case 1005: {
                    bigDecimal = new BigDecimal(this.data.toString());
                    break;
                }
                case 1007: {
                    bigDecimal = new BigDecimal((Double)this.data);
                    break;
                }
                case 1006: {
                    bigDecimal = new BigDecimal(((Float)this.data).doubleValue());
                    break;
                }
                case 1009: {
                    if (((Boolean)this.data).booleanValue()) {
                        bigDecimal = new BigDecimal(1.0);
                        break;
                    }
                    bigDecimal = new BigDecimal(0.0);
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return bigDecimal;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public InputStream getBinaryStream(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        try {
            InputStream inputStream = null;
            int n3 = -1;
            switch (this.type) {
                case 1014: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 1002: {
                    inputStream = new ByteArrayInputStream((byte[])this.data);
                    n3 = ((byte[])this.data).length;
                    break;
                }
                case 1020: {
                    inputStream = ((Blob)this.data).getBinaryStream();
                    n3 = (int)((Blob)this.data).length();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n3, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n2;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public Blob getBlob(BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        try {
            Blob blob = null;
            switch (this.type) {
                case 1020: {
                    if (this.data instanceof BaseImplBlob) {
                        blob = new BaseBlob((BaseImplBlob)this.data, baseConnection, baseExceptions);
                        break;
                    }
                    blob = (Blob)this.data;
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return blob;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public boolean getBoolean(BaseExceptions baseExceptions) throws SQLException {
        try {
            boolean bl = false;
            switch (this.type) {
                case 1009: {
                    bl = (Boolean)this.data;
                    break;
                }
                case 1010: 
                case 1015: 
                case 1017: {
                    String[] stringArray;
                    String string;
                    if (this.type == 1010) {
                        string = ((String)this.data).trim();
                    } else {
                        stringArray = this.getString(-1, baseExceptions);
                        string = stringArray.trim();
                    }
                    if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1")) {
                        bl = true;
                        break;
                    }
                    if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("0")) {
                        bl = false;
                        break;
                    }
                    stringArray = new String[]{new String("Error converting the string '" + (String)this.data + "' to boolean.")};
                    throw baseExceptions.getException(6002, stringArray);
                }
                case 1001: {
                    bl = (Byte)this.data != 0;
                    break;
                }
                case 1003: {
                    bl = (Short)this.data != 0;
                    break;
                }
                case 1004: {
                    bl = (Integer)this.data != 0;
                    break;
                }
                case 1005: {
                    bl = (Long)this.data != 0L;
                    break;
                }
                case 1006: {
                    bl = (double)((Float)this.data).floatValue() != 0.0;
                    break;
                }
                case 1007: {
                    bl = (Double)this.data != 0.0;
                    break;
                }
                case 1008: {
                    bl = ((BigDecimal)this.data).doubleValue() != 0.0;
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return bl;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public byte getByte(BaseExceptions baseExceptions) throws SQLException {
        try {
            byte by = 0;
            switch (this.type) {
                case 1001: {
                    by = (Byte)this.data;
                    break;
                }
                case 1010: {
                    by = Byte.parseByte(((String)this.data).trim());
                    break;
                }
                case 1003: {
                    by = ((Short)this.data).byteValue();
                    break;
                }
                case 1004: {
                    by = ((Integer)this.data).byteValue();
                    break;
                }
                case 1005: {
                    by = ((Long)this.data).byteValue();
                    break;
                }
                case 1006: {
                    by = ((Float)this.data).byteValue();
                    break;
                }
                case 1007: {
                    by = ((Double)this.data).byteValue();
                    break;
                }
                case 1008: {
                    Integer n2 = new Integer(((BigDecimal)this.data).intValue());
                    by = n2.byteValue();
                    break;
                }
                case 1009: {
                    if (((Boolean)this.data).booleanValue()) {
                        by = 1;
                        break;
                    }
                    by = 0;
                    break;
                }
                case 1015: 
                case 1017: {
                    String string = this.getString(-1, baseExceptions);
                    by = Byte.parseByte(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return by;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public byte[] getBytes(int n2, BaseExceptions baseExceptions) throws SQLException {
        return this.getBytes(n2, null, baseExceptions);
    }

    public byte[] getBytes(int n2, UtilTransliterator utilTransliterator, BaseExceptions baseExceptions) throws SQLException {
        try {
            Object object;
            Object object2 = null;
            switch (this.type) {
                case 1002: {
                    object2 = (byte[])this.data;
                    break;
                }
                case 1019: {
                    return null;
                }
                case 1010: {
                    object2 = BaseData.stringToBytes((String)this.data, utilTransliterator, baseExceptions);
                    break;
                }
                case 1018: {
                    object = this.getString(-1, baseExceptions);
                    object2 = BaseData.stringToBytes((String)object, utilTransliterator, baseExceptions);
                    break;
                }
                case 1014: {
                    object = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    boolean bl = false;
                    while (!bl) {
                        int n3;
                        try {
                            n3 = ((InputStream)this.data).read(byArray, 0, byArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n3 == -1) {
                            bl = true;
                            try {
                                ((InputStream)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        if (n3 == -2) {
                            throw baseExceptions.getException(6032);
                        }
                        ((ByteArrayOutputStream)object).write(byArray, 0, n3);
                    }
                    object2 = ((ByteArrayOutputStream)object).toByteArray();
                    break;
                }
                case 1015: 
                case 1017: {
                    object = this.getString(-1, baseExceptions);
                    object2 = BaseData.stringToBytes((String)object, utilTransliterator, baseExceptions);
                    break;
                }
                case 1020: {
                    object = new BaseBlob((BaseImplBlob)this.data, null, baseExceptions);
                    int n4 = (int)((BaseBlob)object).length();
                    if (n2 >= 0 && n4 > n2) {
                        n4 = n2;
                    }
                    object2 = ((BaseBlob)object).getBytes(1L, n4);
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (n2 != -1 && ((byte[])object2).length > n2) {
                object = new byte[n2];
                System.arraycopy(object2, 0, object, 0, n2);
                object2 = object;
            }
            return object2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public Reader getCharacterStreamReader(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        try {
            Reader reader = null;
            int n3 = -1;
            switch (this.type) {
                case 1018: {
                    reader = (Reader)this.data;
                    break;
                }
                case 1010: {
                    reader = new StringReader((String)this.data);
                    n3 = ((String)this.data).length();
                    break;
                }
                case 1015: {
                    reader = new UtilASCIIInputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n3 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 1002: {
                    String string = UtilDataConversions.bytesToString((byte[])this.data, ((byte[])this.data).length);
                    reader = new StringReader(string);
                    n3 = ((byte[])this.data).length;
                    break;
                }
                case 1014: {
                    UtilBinaryToASCIIInputStream utilBinaryToASCIIInputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    if (this.data instanceof BaseInputStreamWrapper) {
                        n3 = (int)((BaseInputStreamWrapper)this.data).length();
                    }
                    reader = new UtilASCIIInputStreamToCharacterReader(utilBinaryToASCIIInputStream);
                    break;
                }
                case 1017: {
                    reader = new UtilUCS2InputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n3 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 1021: {
                    reader = ((Clob)this.data).getCharacterStream();
                    n3 = (int)((Clob)this.data).length();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            if (reader != null) {
                if (!(reader instanceof BaseCharacterStreamWrapper)) {
                    reader = new BaseCharacterStreamWrapper(reader, n3, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseCharacterStreamWrapper)reader).maxCharsToReturn = n2 / 2;
                }
            }
            return reader;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public Clob getClob(BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        try {
            Clob clob = null;
            switch (this.type) {
                case 1021: {
                    if (this.data == null) break;
                    if (this.data instanceof BaseImplClob) {
                        clob = new BaseClob((BaseImplClob)this.data, baseConnection, baseExceptions);
                        break;
                    }
                    clob = (Clob)this.data;
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return clob;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public Date getDate(BaseExceptions baseExceptions) throws SQLException {
        try {
            Date date = null;
            switch (this.type) {
                case 1011: {
                    date = (Date)this.data;
                    break;
                }
                case 1010: {
                    date = Date.valueOf(((String)this.data).trim());
                    break;
                }
                case 1015: 
                case 1017: {
                    date = Date.valueOf(this.getString(-1, baseExceptions).trim());
                    break;
                }
                case 1013: {
                    Timestamp timestamp = (Timestamp)this.data;
                    date = new Date(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return date;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public Date getDate(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        try {
            switch (this.type) {
                case 1011: {
                    return BaseData.applyCalender((Date)this.data, calendar, false);
                }
                case 1013: {
                    Date date = this.getDate(baseExceptions);
                    return BaseData.applyCalender(date, calendar, false);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public double getDouble(BaseExceptions baseExceptions) throws SQLException {
        try {
            double d2 = 0.0;
            switch (this.type) {
                case 1007: {
                    d2 = (Double)this.data;
                    break;
                }
                case 1010: {
                    d2 = Double.valueOf(((String)this.data).trim());
                    break;
                }
                case 1001: {
                    d2 = ((Byte)this.data).doubleValue();
                    break;
                }
                case 1003: {
                    d2 = ((Short)this.data).doubleValue();
                    break;
                }
                case 1004: {
                    d2 = ((Integer)this.data).doubleValue();
                    break;
                }
                case 1005: {
                    d2 = ((Long)this.data).doubleValue();
                    break;
                }
                case 1006: {
                    d2 = ((Float)this.data).doubleValue();
                    break;
                }
                case 1008: {
                    d2 = ((BigDecimal)this.data).doubleValue();
                    break;
                }
                case 1009: {
                    if (((Boolean)this.data).booleanValue()) {
                        d2 = 1.0;
                        break;
                    }
                    d2 = 0.0;
                    break;
                }
                case 1015: 
                case 1017: {
                    String string = this.getString(-1, baseExceptions);
                    d2 = Double.valueOf(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return d2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public float getFloat(BaseExceptions baseExceptions) throws SQLException {
        try {
            float f2 = 0.0f;
            switch (this.type) {
                case 1006: {
                    f2 = ((Float)this.data).floatValue();
                    break;
                }
                case 1010: {
                    f2 = Float.valueOf(((String)this.data).trim()).floatValue();
                    break;
                }
                case 1001: {
                    f2 = ((Byte)this.data).floatValue();
                    break;
                }
                case 1003: {
                    f2 = ((Short)this.data).floatValue();
                    break;
                }
                case 1004: {
                    f2 = ((Integer)this.data).floatValue();
                    break;
                }
                case 1005: {
                    f2 = ((Long)this.data).floatValue();
                    break;
                }
                case 1007: {
                    f2 = ((Double)this.data).floatValue();
                    break;
                }
                case 1008: {
                    f2 = ((BigDecimal)this.data).floatValue();
                    break;
                }
                case 1009: {
                    if (((Boolean)this.data).booleanValue()) {
                        f2 = 1.0f;
                        break;
                    }
                    f2 = 0.0f;
                    break;
                }
                case 1015: 
                case 1017: {
                    String string = this.getString(-1, baseExceptions);
                    f2 = Float.valueOf(string.trim()).floatValue();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return f2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public int getInteger(BaseExceptions baseExceptions) throws SQLException {
        try {
            int n2 = 0;
            switch (this.type) {
                case 1004: {
                    n2 = (Integer)this.data;
                    break;
                }
                case 1001: {
                    n2 = ((Byte)this.data).byteValue();
                    break;
                }
                case 1003: {
                    n2 = ((Short)this.data).intValue();
                    break;
                }
                case 1005: {
                    n2 = ((Long)this.data).intValue();
                    break;
                }
                case 1006: {
                    n2 = ((Float)this.data).intValue();
                    break;
                }
                case 1007: {
                    n2 = ((Double)this.data).intValue();
                    break;
                }
                case 1008: {
                    n2 = ((BigDecimal)this.data).intValue();
                    break;
                }
                case 1009: {
                    if (((Boolean)this.data).booleanValue()) {
                        n2 = 1;
                        break;
                    }
                    n2 = 0;
                    break;
                }
                case 1015: 
                case 1017: {
                    String string = this.getString(-1, baseExceptions);
                    n2 = Integer.parseInt(string.trim());
                    break;
                }
                case 1010: {
                    n2 = Integer.parseInt(((String)this.data).trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return n2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getJavaObjectType(Object object, int n2) {
        int n3 = 1000;
        if (object == null) {
            return 1019;
        }
        if (object instanceof Integer) {
            return 1004;
        }
        if (object instanceof Byte) {
            return 1001;
        }
        if (object instanceof Short) {
            return 1003;
        }
        if (object instanceof Long) {
            return 1005;
        }
        if (object instanceof Float) {
            return 1006;
        }
        if (object instanceof Double) {
            return 1007;
        }
        if (object instanceof BigDecimal) {
            return 1008;
        }
        if (object instanceof Boolean) {
            return 1009;
        }
        if (object instanceof String) {
            return 1010;
        }
        if (object instanceof Date) {
            return 1011;
        }
        if (object instanceof Time) {
            return 1012;
        }
        if (object instanceof Timestamp) {
            return 1013;
        }
        if (object instanceof Blob) return 1020;
        if (object instanceof BaseImplBlob) {
            return 1020;
        }
        if (object instanceof Clob) return 1021;
        if (object instanceof BaseImplClob) {
            return 1021;
        }
        if (object instanceof Reader) {
            return 1018;
        }
        if (object instanceof InputStream) {
            switch (n2) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return 1014;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    return 1015;
                }
                default: {
                    return n3;
                }
            }
        }
        String string = object.getClass().getName();
        if (!string.equals("[B")) return n3;
        return 1002;
    }

    public long getLong(BaseExceptions baseExceptions) throws SQLException {
        try {
            long l2 = 0L;
            switch (this.type) {
                case 1005: {
                    l2 = (Long)this.data;
                    break;
                }
                case 1001: {
                    l2 = ((Byte)this.data).byteValue();
                    break;
                }
                case 1003: {
                    l2 = ((Short)this.data).longValue();
                    break;
                }
                case 1004: {
                    l2 = ((Integer)this.data).longValue();
                    break;
                }
                case 1006: {
                    l2 = ((Float)this.data).longValue();
                    break;
                }
                case 1007: {
                    l2 = ((Double)this.data).longValue();
                    break;
                }
                case 1008: {
                    l2 = ((BigDecimal)this.data).longValue();
                    break;
                }
                case 1009: {
                    if (((Boolean)this.data).booleanValue()) {
                        l2 = 1L;
                        break;
                    }
                    l2 = 0L;
                    break;
                }
                case 1015: 
                case 1017: {
                    String string = this.getString(-1, baseExceptions);
                    l2 = Long.parseLong(string.trim());
                    break;
                }
                case 1010: {
                    l2 = Long.parseLong(((String)this.data).trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return l2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public Object getObject(int n2, int n3, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        Object object = null;
        switch (n2) {
            case 1009: {
                if (this.type == 1009) {
                    object = this.data;
                    break;
                }
                object = new Boolean(this.getBoolean(baseExceptions));
                break;
            }
            case 1004: {
                if (this.type == 1004) {
                    object = this.data;
                    break;
                }
                object = new Integer(this.getInteger(baseExceptions));
                break;
            }
            case 1005: {
                if (this.type == 1005) {
                    object = this.data;
                    break;
                }
                object = new Long(this.getLong(baseExceptions));
                break;
            }
            case 1006: {
                if (this.type == 1006) {
                    object = this.data;
                    break;
                }
                object = new Float(this.getFloat(baseExceptions));
                break;
            }
            case 1007: {
                if (this.type == 1007) {
                    object = this.data;
                    break;
                }
                object = new Double(this.getDouble(baseExceptions));
                break;
            }
            case 1010: {
                object = this.getString(n3, baseExceptions);
                break;
            }
            case 1002: {
                object = this.getBytes(n3, baseExceptions);
                break;
            }
            case 1020: {
                object = this.getBlob(baseConnection, baseExceptions);
                break;
            }
            case 1021: {
                object = this.getClob(baseConnection, baseExceptions);
                break;
            }
            default: {
                object = this.data;
            }
        }
        return object;
    }

    public short getShort(BaseExceptions baseExceptions) throws SQLException {
        try {
            short s2 = 0;
            switch (this.type) {
                case 1003: {
                    s2 = (Short)this.data;
                    break;
                }
                case 1010: {
                    s2 = Short.parseShort(((String)this.data).trim());
                    break;
                }
                case 1001: {
                    s2 = ((Byte)this.data).byteValue();
                    break;
                }
                case 1004: {
                    s2 = ((Integer)this.data).shortValue();
                    break;
                }
                case 1005: {
                    s2 = ((Long)this.data).shortValue();
                    break;
                }
                case 1006: {
                    s2 = ((Float)this.data).shortValue();
                    break;
                }
                case 1007: {
                    s2 = ((Double)this.data).shortValue();
                    break;
                }
                case 1008: {
                    Integer n2 = new Integer(((BigDecimal)this.data).intValue());
                    s2 = n2.shortValue();
                    break;
                }
                case 1009: {
                    if (((Boolean)this.data).booleanValue()) {
                        s2 = 1;
                        break;
                    }
                    s2 = 0;
                    break;
                }
                case 1015: 
                case 1017: {
                    String string = this.getString(-1, baseExceptions);
                    s2 = Short.parseShort(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return s2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public String getString(int n2, BaseExceptions baseExceptions) throws SQLException {
        try {
            String string = null;
            switch (this.type) {
                case 1010: {
                    string = (String)this.data;
                }
                case 1019: {
                    return string;
                }
                case 1002: {
                    string = UtilDataConversions.bytesToString((byte[])this.data, ((byte[])this.data).length);
                    break;
                }
                case 1014: {
                    byte[] byArray = this.getBytes(n2, baseExceptions);
                    string = UtilDataConversions.bytesToString(byArray, byArray.length);
                    break;
                }
                case 1015: 
                case 1017: {
                    long l2;
                    int n3 = -1;
                    if (this.data instanceof BaseInputStreamWrapper && (l2 = ((BaseInputStreamWrapper)this.data).numTotalBytesInStream) > 0L && l2 <= Integer.MAX_VALUE) {
                        n3 = new Long(l2).intValue();
                    }
                    if (n3 == -1) {
                        n3 = 10240;
                    }
                    StringBuffer stringBuffer = new StringBuffer(n3);
                    boolean bl = false;
                    byte[] byArray = new byte[n3];
                    boolean bl2 = false;
                    while (!bl2) {
                        int n4;
                        try {
                            n4 = ((InputStream)this.data).read(byArray, 0, byArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n4 == -1) {
                            bl2 = true;
                            try {
                                ((InputStream)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        if (n4 == -2) {
                            throw baseExceptions.getException(6032);
                        }
                        if (this.type == 1015) {
                            stringBuffer.append(UtilDataConversions.ASCIIBytesToString(byArray, n4));
                            continue;
                        }
                        stringBuffer.append(UtilDataConversions.UCS2BytesToString(byArray, n4));
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 1018: {
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = false;
                    char[] cArray = new char[1024];
                    boolean bl3 = false;
                    while (!bl3) {
                        int n5;
                        try {
                            n5 = ((Reader)this.data).read(cArray, 0, cArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n5 == -1) {
                            bl3 = true;
                            try {
                                ((Reader)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        if (n5 == -2) {
                            throw baseExceptions.getException(6032);
                        }
                        stringBuffer.append(cArray, 0, n5);
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 1021: {
                    Clob clob = this.getClob(null, baseExceptions);
                    int n6 = new Long(clob.length()).intValue();
                    if (n2 >= 0 && n6 > n2) {
                        n6 = n2;
                    }
                    string = clob.getSubString(1L, n6);
                    break;
                }
                case 1020: {
                    Blob blob = this.getBlob(null, baseExceptions);
                    int n7 = new Long(blob.length()).intValue();
                    if (n2 >= 0 && n7 > n2 / 2) {
                        n7 = n2 / 2;
                    }
                    byte[] byArray = blob.getBytes(1L, n7);
                    string = UtilDataConversions.bytesToString(byArray, byArray.length);
                    break;
                }
                case 1016: {
                    this.unsupportedConversion(baseExceptions);
                }
                default: {
                    string = this.data.toString();
                }
            }
            if (n2 != -1 && string.length() > n2) {
                string = string.substring(0, n2);
            }
            return string;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public Time getTime(BaseExceptions baseExceptions) throws SQLException {
        try {
            Time time = null;
            switch (this.type) {
                case 1012: {
                    time = (Time)this.data;
                    break;
                }
                case 1010: {
                    time = Time.valueOf(((String)this.data).trim());
                    break;
                }
                case 1013: {
                    Timestamp timestamp = (Timestamp)this.data;
                    time = new Time(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
                    break;
                }
                case 1015: 
                case 1017: {
                    String string = this.getString(-1, baseExceptions);
                    time = Time.valueOf(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return time;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public Time getTime(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        try {
            switch (this.type) {
                case 1012: {
                    return BaseData.applyCalender((Time)this.data, calendar, false);
                }
                case 1013: {
                    Time time = this.getTime(baseExceptions);
                    return BaseData.applyCalender(time, calendar, false);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public Timestamp getTimestamp(BaseExceptions baseExceptions) throws SQLException {
        try {
            Timestamp timestamp = null;
            switch (this.type) {
                case 1013: {
                    timestamp = (Timestamp)this.data;
                    break;
                }
                case 1010: {
                    timestamp = Timestamp.valueOf(((String)this.data).trim());
                    break;
                }
                case 1015: 
                case 1017: {
                    String string = this.getString(-1, baseExceptions);
                    timestamp = Timestamp.valueOf(string.trim());
                    break;
                }
                case 1011: 
                case 1012: {
                    if (this.data == null) break;
                    Calendar calendar = Calendar.getInstance();
                    if (this.type == 1012) {
                        calendar.setTime((Time)this.data);
                        calendar.set(1, 1970);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                    } else {
                        calendar.setTime((Date)this.data);
                        calendar.set(10, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                    timestamp = new Timestamp(calendar.getTime().getTime());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            return timestamp;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public Timestamp getTimestamp(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        try {
            switch (this.type) {
                case 1013: {
                    return BaseData.applyCalender((Timestamp)this.data, calendar, false);
                }
                case 1012: {
                    return new BaseData(1012, BaseData.applyCalender((Time)this.data, calendar, false)).getTimestamp(baseExceptions);
                }
                case 1011: {
                    return new BaseData(1011, BaseData.applyCalender((Date)this.data, calendar, false)).getTimestamp(baseExceptions);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public InputStream getUCS2InputStream(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        try {
            InputStream inputStream = null;
            switch (this.type) {
                case 1017: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, -1L, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n2;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    public InputStream getUTF8InputStream(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        try {
            InputStream inputStream = null;
            switch (this.type) {
                case 1016: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
                case 1019: 
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, -1L, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n2;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6025);
        }
    }

    static boolean isStreamed(int n2) {
        switch (n2) {
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: 
            case 1018: 
            case 1020: 
            case 1021: {
                return true;
            }
        }
        return false;
    }

    static int mapJDBCTypeToJavaObjectType(int n2) {
        int n3 = 0;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                n3 = 1010;
                break;
            }
            case 2: 
            case 3: {
                n3 = 1008;
                break;
            }
            case -7: {
                n3 = 1009;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                n3 = 1004;
                break;
            }
            case -5: {
                n3 = 1005;
                break;
            }
            case 7: {
                n3 = 1006;
                break;
            }
            case 6: 
            case 8: {
                n3 = 1007;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                n3 = 1002;
                break;
            }
            case 91: {
                n3 = 1011;
                break;
            }
            case 92: {
                n3 = 1012;
                break;
            }
            case 93: {
                n3 = 1013;
                break;
            }
            case 0: {
                n3 = 1019;
                break;
            }
            case 2004: {
                n3 = 1020;
                break;
            }
            case 2005: {
                n3 = 1021;
                break;
            }
        }
        return n3;
    }

    static String mapJDBCTypeToJavaObjectTypeName(int n2) {
        String string = null;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                string = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                string = "java.math.BigDecimal";
                break;
            }
            case -7: {
                string = "java.lang.Boolean";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = "java.lang.Integer";
                break;
            }
            case -5: {
                string = "java.lang.Long";
                break;
            }
            case 7: {
                string = "java.lang.Float";
                break;
            }
            case 6: 
            case 8: {
                string = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "byte[]";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case 92: {
                string = "java.sql.Time";
                break;
            }
            case 93: {
                string = "java.sql.Timestamp";
                break;
            }
            case 2005: {
                string = "java.sql.Clob";
                break;
            }
            case 2004: {
                string = "java.sql.Blob";
                break;
            }
            case 2003: {
                string = "java.sql.Array";
                break;
            }
            case 2006: {
                string = "java.sql.Ref";
                break;
            }
            case 2002: {
                string = "java.sql.Struct";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public void setData(int n2, Object object) {
        this.type = n2;
        this.data = object;
    }

    public void setData(Object object) {
        this.type = BaseData.getJavaObjectType(object, 0);
        this.data = object;
    }

    public static byte[] stringToBytes(String string, UtilTransliterator utilTransliterator, BaseExceptions baseExceptions) throws SQLException {
        byte[] byArray = null;
        if (utilTransliterator != null) {
            try {
                byArray = utilTransliterator.encode(string);
            }
            catch (UtilException utilException) {
                throw baseExceptions.getException(6025);
            }
        } else {
            int n2 = string.length();
            if (n2 % 2 != 0) {
                throw baseExceptions.getException(6033);
            }
            byte[] byArray2 = new byte[n2 / 2];
            boolean bl = true;
            int n3 = 0;
            while (n3 < n2) {
                byte by;
                char c2 = string.charAt(n3);
                if (c2 >= '0' && c2 <= '9') {
                    by = (byte)(c2 - 48);
                } else if (c2 >= 'a' && c2 <= 'f') {
                    by = (byte)(c2 - 97 + 10);
                } else if (c2 >= 'A' && c2 <= 'F') {
                    by = (byte)(c2 - 65 + 10);
                } else {
                    throw baseExceptions.getException(6033);
                }
                if (bl) {
                    byArray2[n3 / 2] = (byte)(by << 4);
                    bl = false;
                } else {
                    int n4 = n3 / 2;
                    byArray2[n4] = (byte)(byArray2[n4] + by);
                    bl = true;
                }
                ++n3;
            }
            byArray = byArray2;
        }
        return byArray;
    }

    final void unsupportedConversion(BaseExceptions baseExceptions) throws SQLException {
        switch (this.type) {
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: {
                try {
                    ((InputStream)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 1018: {
                try {
                    ((Reader)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 1020: {
                try {
                    ((BaseImplBlob)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 1021: {
                try {
                    ((BaseImplClob)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
        }
        throw baseExceptions.getException(6009);
    }
}

