/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseImplConnection;
import java.sql.SQLException;
import java.util.Vector;

public final class BaseConnectionPool {
    private static String footprint = "$Revision:   1.5.1.0  $";
    Vector physicalConnectionPool = new Vector();

    protected void add(BaseImplConnection baseImplConnection) {
        this.physicalConnectionPool.addElement(baseImplConnection);
    }

    public void close() {
        int n2 = this.physicalConnectionPool.size();
        int n3 = 0;
        while (n3 < n2) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n3);
            if (baseImplConnection.getReferenceCount() == 0) {
                try {
                    baseImplConnection.close();
                }
                catch (SQLException sQLException) {}
            }
            ++n3;
        }
    }

    protected int count() {
        return this.physicalConnectionPool.size();
    }

    protected int countActiveConnections() {
        int n2 = 0;
        int n3 = this.physicalConnectionPool.size();
        int n4 = 0;
        while (n4 < n3) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n4);
            if (baseImplConnection.getReferenceCount() > 0) {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    protected int countUseableConnections(int n2) {
        int n3 = 0;
        int n4 = this.physicalConnectionPool.size();
        int n5 = 0;
        while (n5 < n4) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n5);
            if (baseImplConnection.getReferenceCount() < n2) {
                ++n3;
            }
            ++n5;
        }
        return n3;
    }

    protected void finalize() {
        this.close();
    }

    protected BaseImplConnection getUseableConnection(int n2) {
        BaseImplConnection baseImplConnection = null;
        int n3 = this.physicalConnectionPool.size();
        int n4 = 0;
        while (n4 < n3) {
            baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n4);
            if (baseImplConnection.getReferenceCount() < n2) break;
            ++n4;
        }
        return baseImplConnection;
    }

    public void reset() throws SQLException {
        int n2 = this.physicalConnectionPool.size();
        int n3 = 0;
        while (n3 < n2) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n3);
            baseImplConnection.reset();
            ++n3;
        }
    }

    public void setCatalog(String string) throws SQLException {
        int n2 = this.physicalConnectionPool.size();
        int n3 = 0;
        while (n3 < n2) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n3);
            baseImplConnection.setCatalog(string);
            ++n3;
        }
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        int n3 = this.physicalConnectionPool.size();
        int n4 = 0;
        while (n4 < n3) {
            BaseImplConnection baseImplConnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(n4);
            baseImplConnection.setTransactionIsolation(n2);
            ++n4;
        }
    }
}

