/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseCallableStatement;
import com.microsoft.jdbc.base.BaseClassUtility;
import com.microsoft.jdbc.base.BaseConnectionPool;
import com.microsoft.jdbc.base.BaseConnectionProperties;
import com.microsoft.jdbc.base.BaseConnectionStartup;
import com.microsoft.jdbc.base.BaseDatabaseMetaData;
import com.microsoft.jdbc.base.BaseDriverPropertyInfos;
import com.microsoft.jdbc.base.BaseEscapeTranslator;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplConnection;
import com.microsoft.jdbc.base.BaseImplDatabaseMetaData;
import com.microsoft.jdbc.base.BaseLicenseUtility;
import com.microsoft.jdbc.base.BasePreparedStatement;
import com.microsoft.jdbc.base.BaseStatement;
import com.microsoft.jdbc.base.BaseWarnings;
import com.microsoft.jdbc.extensions.ExtEmbeddedConnection;
import com.microsoft.util.UtilDebug;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class BaseConnection
implements Connection,
ExtEmbeddedConnection {
    private static String footprint = "$Revision:   1.68.1.2.1.2  $";
    protected String driverName;
    protected BaseConnectionProperties connectProps;
    UtilDebug debug;
    private BaseImplConnection primaryImplConnection;
    private int numberOpenObjectsPerConnection;
    private BaseConnectionPool secondaryImplConnections;
    private int maxConnections;
    private BaseDatabaseMetaData databaseMetaData;
    private boolean inManualTransactionMode;
    private boolean readOnlyMode;
    private String currentCatalog;
    private String originalCatalog;
    private int currentTransactionIsolation = -1;
    private int originalTransactionIsolation = -1;
    protected BaseWarnings warnings;
    protected BaseExceptions exceptions;
    private boolean lockedEmbedding;
    BaseEscapeTranslator escapeTranslator;

    public final synchronized void clearWarnings() throws SQLException {
        this.warnings.clear();
    }

    public final synchronized void close() throws SQLException {
        if (!this.isClosedUnSync()) {
            this.commonCloseReset();
            this.commonClose();
        }
    }

    public final synchronized void closeXA(boolean bl) throws SQLException {
        if (!this.isClosedUnSync() && !this.lockedEmbedding) {
            this.commonCloseResetXA(bl);
            this.commonClose();
        }
    }

    public final synchronized void commit() throws SQLException {
        this.validateClosedState();
        if (this.inManualTransactionMode) {
            this.primaryImplConnection.commitTransaction();
        }
    }

    final void commonClose() throws SQLException {
        this.primaryImplConnection.removeReference();
        this.primaryImplConnection.close();
        this.primaryImplConnection = null;
        this.secondaryImplConnections.close();
    }

    final void commonCloseReset() throws SQLException {
        block2: {
            this.clearWarnings();
            if (!this.inManualTransactionMode) break block2;
            try {
                this.primaryImplConnection.rollbackTransaction();
            }
            catch (SQLException sQLException) {}
        }
    }

    final void commonCloseResetXA(boolean bl) throws SQLException {
        block2: {
            this.clearWarnings();
            if (bl || !this.inManualTransactionMode) break block2;
            try {
                this.primaryImplConnection.rollbackTransaction();
            }
            catch (SQLException sQLException) {}
        }
    }

    final void commonReset() throws SQLException {
        if (this.originalCatalog != null && this.currentCatalog != null && !this.originalCatalog.equals(this.currentCatalog)) {
            this.setCatalog(this.originalCatalog);
        }
        if (this.originalTransactionIsolation != -1 && this.originalTransactionIsolation != this.currentTransactionIsolation) {
            this.setTransactionIsolation(this.originalTransactionIsolation);
        }
        if (this.inManualTransactionMode) {
            this.setAutoCommit(true);
        }
        this.setReadOnly(false);
        this.primaryImplConnection.reset();
        this.secondaryImplConnections.reset();
    }

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return null;
    }

    protected abstract BaseImplConnection createImplConnection(BaseConnectionProperties var1) throws SQLException;

    public abstract BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties var1) throws SQLException;

    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public final synchronized Statement createStatement(int n2, int n3) throws SQLException {
        this.validateClosedState();
        this.validatedUnlocked();
        this.validateTypeAndConcurrency("createStatement", n2, n3);
        BaseStatement baseStatement = new BaseStatement(this, n2, n3);
        this.postDownGradeWarnings(baseStatement, n2, n3);
        return baseStatement;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            this.log("BaseConnection closed");
        }
        finally {
            Object var2_1 = null;
            super.finalize();
        }
    }

    public final synchronized boolean getAutoCommit() throws SQLException {
        this.validateClosedState();
        return this.inManualTransactionMode ^ true;
    }

    public boolean getBatchIsJDBCCompliant() {
        return true;
    }

    public final synchronized String getCatalog() throws SQLException {
        this.validateClosedState();
        if (this.currentCatalog == null) {
            this.currentCatalog = this.primaryImplConnection.getCatalog();
            if (this.originalCatalog == null) {
                this.originalCatalog = this.currentCatalog;
            }
        }
        return this.currentCatalog;
    }

    public BaseConnectionProperties getConnectProperties() {
        return this.connectProps;
    }

    int getEmptyRowInsertSyntax() {
        return this.primaryImplConnection.getEmptyRowInsertSyntax();
    }

    public final BaseEscapeTranslator getEscapeTranslator() throws SQLException {
        if (this.escapeTranslator == null) {
            this.escapeTranslator = this.createEscapeTranslator();
        }
        return this.escapeTranslator;
    }

    /*
     * Enabled aggressive block sorting
     */
    final synchronized BaseImplConnection getImplConnection(boolean bl) throws SQLException {
        BaseImplConnection baseImplConnection;
        block13: {
            baseImplConnection = null;
            if (this.primaryImplConnection.getReferenceCount() <= this.numberOpenObjectsPerConnection) {
                baseImplConnection = this.primaryImplConnection;
            } else {
                if (this.inManualTransactionMode) {
                    if (this.primaryImplConnection.getReferenceCount() == 1 && this.secondaryImplConnections.countActiveConnections() == 0) {
                        baseImplConnection = this.primaryImplConnection;
                        break block13;
                    } else {
                        if (this.numberOpenObjectsPerConnection == 1) {
                            throw this.exceptions.getException(6022, "08007");
                        }
                        throw this.exceptions.getException(6024, "08007");
                    }
                }
                if (this.secondaryImplConnections.countUseableConnections(this.numberOpenObjectsPerConnection) > 0) {
                    baseImplConnection = this.secondaryImplConnections.getUseableConnection(this.numberOpenObjectsPerConnection);
                } else if ((this.maxConnections == 0 || this.maxConnections > this.secondaryImplConnections.count() + 2) && this.numberOpenObjectsPerConnection == 1) {
                    baseImplConnection = this.getNewImplConnection(bl, 0);
                    if (this.currentCatalog != null && this.originalCatalog != null) {
                        if (!this.currentCatalog.equals(this.originalCatalog)) {
                            baseImplConnection.setCatalog(this.currentCatalog);
                        }
                        if (this.originalTransactionIsolation != -1 && this.originalTransactionIsolation != this.currentTransactionIsolation) {
                            baseImplConnection.setTransactionIsolation(this.currentTransactionIsolation);
                        }
                    }
                    this.secondaryImplConnections.add(baseImplConnection);
                } else {
                    throw this.exceptions.getException(6024);
                }
            }
        }
        baseImplConnection.addReference();
        return baseImplConnection;
    }

    protected abstract void getImplPropertyInfo(BaseDriverPropertyInfos var1);

    public final synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.validateClosedState();
        if (this.databaseMetaData == null) {
            BaseImplDatabaseMetaData baseImplDatabaseMetaData = this.createImplDatabaseMetaData(this.connectProps);
            baseImplDatabaseMetaData.setup(this);
            this.databaseMetaData = new BaseDatabaseMetaData(this, baseImplDatabaseMetaData);
        }
        return this.databaseMetaData;
    }

    private BaseImplConnection getNewImplConnection(boolean bl, int n2) throws SQLException {
        BaseImplConnection baseImplConnection = this.createImplConnection(this.connectProps);
        baseImplConnection.setup(this.connectProps, this.warnings, this.exceptions);
        baseImplConnection.setReadOnly(this.readOnlyMode);
        if (bl) {
            if (n2 > 0) {
                BaseConnectionStartup baseConnectionStartup = new BaseConnectionStartup(baseImplConnection, n2, this.exceptions);
            } else {
                baseImplConnection.open();
            }
        }
        return baseImplConnection;
    }

    public final BaseDriverPropertyInfos getPropertyInfo() {
        BaseDriverPropertyInfos baseDriverPropertyInfos = new BaseDriverPropertyInfos();
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.getImplPropertyInfo(baseDriverPropertyInfos);
        }
        if (!this.getBatchIsJDBCCompliant()) {
            baseDriverPropertyInfos.put("batchPerformanceWorkaround", "Batch Performance Workaround", "false", null, false);
        }
        return baseDriverPropertyInfos;
    }

    public final synchronized int getTransactionIsolation() throws SQLException {
        this.validateClosedState();
        if (this.currentTransactionIsolation == -1) {
            this.currentTransactionIsolation = this.primaryImplConnection.getTransactionIsolation();
            if (this.originalTransactionIsolation == -1) {
                this.originalTransactionIsolation = this.currentTransactionIsolation;
            }
        }
        return this.currentTransactionIsolation;
    }

    public final Map getTypeMap() throws SQLException {
        return new HashMap();
    }

    public final synchronized SQLWarning getWarnings() {
        return this.warnings.get();
    }

    public final synchronized boolean isClosed() {
        return this.isClosedUnSync();
    }

    final boolean isClosedUnSync() {
        boolean bl = this.primaryImplConnection == null;
        return bl;
    }

    public final synchronized boolean isReadOnly() throws SQLException {
        this.validateClosedState();
        return this.readOnlyMode;
    }

    public void log(String string) {
    }

    public static Properties makeSpyProperties(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf(61);
            if (n2 == -1) continue;
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            ((Hashtable)properties).put(string3, string4);
        }
        return properties;
    }

    public final String nativeSQL(String string) throws SQLException {
        this.validateClosedState();
        return string;
    }

    public final void open(BaseConnectionProperties baseConnectionProperties, BaseExceptions baseExceptions) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.driverName = BaseClassUtility.getRootName(this);
            this.connectProps = baseConnectionProperties;
            this.exceptions = baseExceptions;
            this.debug = this.debug;
            this.warnings = new BaseWarnings(this.driverName);
            this.maxConnections = 0;
            this.readOnlyMode = false;
            this.inManualTransactionMode = false;
            this.secondaryImplConnections = new BaseConnectionPool();
            int n2 = 0;
            if (baseConnectionProperties.get("loginTimeout") != null) {
                n2 = Integer.valueOf(baseConnectionProperties.get("loginTimeout"));
            }
            this.primaryImplConnection = this.getNewImplConnection(true, n2);
            this.primaryImplConnection.addReference();
            this.setupNumberObjectsPerConnection();
            this.lockedEmbedding = BaseLicenseUtility.isLocked(this);
        }
    }

    boolean performsConnectionCloning() {
        return this.numberOpenObjectsPerConnection == 1;
    }

    private void postDownGradeWarnings(BaseStatement baseStatement, int n2, int n3) throws SQLException {
        if (n2 != baseStatement.getResultSetType()) {
            this.warnings.add(6047, "01000");
        }
        if (n3 != baseStatement.getResultSetConcurrency()) {
            this.warnings.add(6048, "01000");
        }
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public final synchronized CallableStatement prepareCall(String string, int n2, int n3) throws SQLException {
        this.validateClosedState();
        this.validatedUnlocked();
        this.validateTypeAndConcurrency("prepareCall", n2, n3);
        BaseCallableStatement baseCallableStatement = new BaseCallableStatement(this, string, n2, n3);
        this.postDownGradeWarnings(baseCallableStatement, n2, n3);
        return baseCallableStatement;
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public final synchronized PreparedStatement prepareStatement(String string, int n2, int n3) throws SQLException {
        this.validateClosedState();
        this.validatedUnlocked();
        this.validateTypeAndConcurrency("prepareStatement", n2, n3);
        BasePreparedStatement basePreparedStatement = new BasePreparedStatement(this, string, n2, n3);
        this.postDownGradeWarnings(basePreparedStatement, n2, n3);
        return basePreparedStatement;
    }

    public final synchronized void reset() throws SQLException {
        if (!this.isClosedUnSync()) {
            this.commonCloseReset();
            this.commonReset();
        }
    }

    public final synchronized void resetXA(boolean bl) throws SQLException {
        if (!this.isClosedUnSync()) {
            this.commonCloseResetXA(bl);
            this.commonReset();
        }
    }

    public final synchronized void rollback() throws SQLException {
        this.validateClosedState();
        if (this.inManualTransactionMode) {
            this.primaryImplConnection.rollbackTransaction();
        }
    }

    public final synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.validateClosedState();
        if (bl) {
            if (this.inManualTransactionMode) {
                this.primaryImplConnection.stopManualTransactionMode();
                this.inManualTransactionMode = false;
            }
        } else if (!this.inManualTransactionMode) {
            if (this.secondaryImplConnections.countActiveConnections() > 0) {
                throw this.exceptions.getException(6027);
            }
            this.primaryImplConnection.startManualTransactionMode();
            this.inManualTransactionMode = true;
        }
    }

    public final synchronized void setCatalog(String string) throws SQLException {
        this.validateClosedState();
        if (this.currentCatalog != null && this.currentCatalog.equals(string)) {
            return;
        }
        if (this.originalCatalog == null) {
            this.originalCatalog = this.getCatalog();
        }
        this.primaryImplConnection.setCatalog(string);
        this.secondaryImplConnections.setCatalog(string);
        this.currentCatalog = new String(string);
    }

    public final synchronized void setReadOnly(boolean bl) throws SQLException {
        this.validateClosedState();
        this.readOnlyMode = bl;
        this.primaryImplConnection.setReadOnly(bl);
    }

    public final synchronized void setTransactionIsolation(int n2) throws SQLException {
        if (n2 == 2112) {
            this.lockedEmbedding = false;
            return;
        }
        this.validateClosedState();
        if (this.originalTransactionIsolation == -1) {
            this.originalTransactionIsolation = this.primaryImplConnection.getTransactionIsolation();
        }
        this.primaryImplConnection.setTransactionIsolation(n2);
        this.secondaryImplConnections.setTransactionIsolation(n2);
        this.currentTransactionIsolation = n2;
    }

    public final void setTypeMap(Map map) throws SQLException {
    }

    private final void setupNumberObjectsPerConnection() throws SQLException {
        this.numberOpenObjectsPerConnection = 1;
        BaseImplDatabaseMetaData baseImplDatabaseMetaData = this.createImplDatabaseMetaData(this.connectProps);
        baseImplDatabaseMetaData.setup(this);
        if (baseImplDatabaseMetaData.maxStatements == null) {
            baseImplDatabaseMetaData.initializeNonResultSetMetaData(101);
        }
        this.numberOpenObjectsPerConnection = baseImplDatabaseMetaData.maxStatements;
        if (this.numberOpenObjectsPerConnection == 0) {
            this.numberOpenObjectsPerConnection = Integer.MAX_VALUE;
        }
    }

    public final boolean unlock(String string) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            if (this.lockedEmbedding) {
                this.lockedEmbedding = BaseLicenseUtility.unlock(string) ^ true;
            }
            boolean bl = this.lockedEmbedding ^ true;
            Object var4_4 = null;
            return bl;
        }
    }

    final synchronized void validateClosedState() throws SQLException {
        if (this.isClosedUnSync()) {
            throw this.exceptions.getException(6010);
        }
    }

    final void validateTypeAndConcurrency(String string, int n2, int n3) throws SQLException {
        boolean bl = false;
        switch (n2) {
            default: {
                bl = true;
            }
            case 1003: 
            case 1004: 
            case 1005: 
        }
        switch (n3) {
            default: {
                bl = true;
            }
            case 1007: 
            case 1008: 
        }
        if (bl) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    final void validatedUnlocked() throws SQLException {
        if (this.lockedEmbedding) {
            throw this.exceptions.getException(6051);
        }
    }
}

