/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseColumn;
import com.microsoft.jdbc.base.BaseData;
import java.util.Vector;

public class BaseColumns {
    private static String footprint = "$Revision:   1.14.1.0  $";
    private Vector columns = new Vector();
    public static final int COUNT_ALL = 0;
    public static final int COUNT_EXPOSED = 1;
    public static final int COUNT_HIDDEN = 2;
    public static final int COUNT_KEY = 3;
    public static final int COUNT_AUTOINCREMENT = 4;
    private boolean countsValid = false;
    private int hiddenCount;
    private int exposedCount;
    private int allCount;
    private int keyCount;
    private int autoincrementCount;

    public void add(BaseColumn baseColumn) {
        this.columns.addElement(baseColumn);
        this.countsValid = false;
    }

    private void calculateCounts() {
        this.allCount = this.columns.size();
        this.hiddenCount = 0;
        this.exposedCount = 0;
        this.keyCount = 0;
        this.autoincrementCount = 0;
        int n2 = 0;
        while (n2 < this.allCount) {
            BaseColumn baseColumn = (BaseColumn)this.columns.elementAt(n2);
            if (baseColumn.isHidden) {
                ++this.hiddenCount;
            } else {
                ++this.exposedCount;
            }
            if (baseColumn.isKey) {
                ++this.keyCount;
            }
            if (baseColumn.isAutoIncrement && !baseColumn.isHidden) {
                ++this.autoincrementCount;
            }
            ++n2;
        }
        this.countsValid = true;
    }

    public int count(int n2) {
        if (!this.countsValid) {
            this.calculateCounts();
        }
        if (n2 == 0) {
            return this.allCount;
        }
        if (n2 == 1) {
            return this.exposedCount;
        }
        if (n2 == 2) {
            return this.hiddenCount;
        }
        if (n2 == 3) {
            return this.keyCount;
        }
        if (n2 == 4) {
            return this.autoincrementCount;
        }
        return 0;
    }

    public BaseColumn get(int n2) {
        BaseColumn baseColumn = (BaseColumn)this.columns.elementAt(n2 - 1);
        return baseColumn;
    }

    public int getOrdinal(String string) {
        int n2 = this.count(0);
        int n3 = 1;
        while (n3 <= n2) {
            if (string.equalsIgnoreCase(this.get((int)n3).name)) {
                return n3;
            }
            ++n3;
        }
        return 0;
    }

    public boolean isValidColumnOrdinal(int n2) {
        return n2 > 0 && n2 <= this.count(1);
    }

    public void markColumnsAsKeyStartingAt(int n2, boolean bl) {
        this.allCount = this.columns.size();
        int n3 = n2 - 1;
        while (n3 < this.allCount) {
            BaseColumn baseColumn = (BaseColumn)this.columns.elementAt(n3);
            if (baseColumn.isSearchable && !baseColumn.isHidden && !BaseData.isStreamed(baseColumn.baseDataType)) {
                baseColumn.isKey = true;
            }
            if (bl) {
                baseColumn.isHidden = true;
            }
            ++n3;
        }
        this.countsValid = false;
    }

    public void reset() {
        if (this.columns != null) {
            this.columns.setSize(0);
        }
        this.countsValid = false;
    }

    public void resetCount() {
        this.countsValid = false;
    }
}

