/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseExceptions;
import java.io.IOException;
import java.io.Reader;

public class BaseCharacterStreamWrapper
extends Reader {
    private static String footprint = "$Revision:   1.8.1.0  $";
    BaseConnection connection;
    Object synchronizer;
    Reader rdr;
    boolean closed;
    long numTotalCharsInReader;
    long numCharsReturned;
    long maxCharsToReturn = Long.MAX_VALUE;
    BaseExceptions exceptions;
    boolean isOutputStream = true;

    BaseCharacterStreamWrapper(Reader reader, long l2, BaseConnection baseConnection, BaseExceptions baseExceptions) {
        this.rdr = reader;
        this.exceptions = baseExceptions;
        this.numTotalCharsInReader = l2;
        this.numCharsReturned = 0L;
        this.closed = false;
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.rdr.close();
                this.closed = true;
            }
        }
    }

    public long length() {
        return this.numTotalCharsInReader;
    }

    public synchronized void mark(int n2) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.rdr.mark(n2);
            }
        }
    }

    public boolean markSupported() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                boolean bl = this.rdr.markSupported();
                Object var3_4 = null;
                return bl;
            }
            boolean bl = false;
            Object var3_5 = null;
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numCharsReturned == this.maxCharsToReturn) {
                return -1;
            }
            int n2 = this.rdr.read();
            if (this.numTotalCharsInReader == -1L) return n2;
            boolean bl = false;
            if (n2 != -1) {
                ++this.numCharsReturned;
                if (this.numCharsReturned > this.numTotalCharsInReader) {
                    return -2;
                }
            } else if (this.numCharsReturned != this.numTotalCharsInReader) {
                return -2;
            }
            if (!bl) return n2;
            return -2;
        }
    }

    public int read(char[] cArray) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            int n2 = this.read(cArray, 0, cArray.length);
            Object var4_4 = null;
            return n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n2, int n3) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numCharsReturned == this.maxCharsToReturn) {
                return -1;
            }
            if (cArray.length - n2 < n3) {
                throw new IOException(this.exceptions.getException(6066).getMessage());
            }
            if (this.numCharsReturned + (long)n3 > this.maxCharsToReturn) {
                n3 = new Long(this.maxCharsToReturn - this.numCharsReturned).intValue();
            }
            int n4 = this.rdr.read(cArray, n2, n3);
            if (this.numTotalCharsInReader == -1L) return n4;
            boolean bl = false;
            if (n4 != -1) {
                this.numCharsReturned += (long)n4;
                if (this.numCharsReturned > this.numTotalCharsInReader) {
                    return -2;
                }
            } else if (this.numCharsReturned != this.numTotalCharsInReader) {
                return -2;
            }
            if (!bl) return n4;
            return -2;
        }
    }

    public synchronized void reset() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            this.rdr.reset();
        }
    }

    void setConnection(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.synchronizer = baseConnection;
    }

    void setIsInputStream() {
        this.isOutputStream = false;
    }

    public long skip(long l2) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            long l3 = this.rdr.skip(l2);
            Object var6_4 = null;
            return l3;
        }
    }

    void validateClosedState() throws IOException {
        if (this.closed || this.connection != null && this.connection.isClosed()) {
            throw new IOException(this.exceptions.getException(6010).getMessage());
        }
    }
}

