/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseData;
import com.microsoft.jdbc.base.BaseParameter;
import com.microsoft.jdbc.base.BasePreparedStatement;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class BaseCallableStatement
extends BasePreparedStatement
implements CallableStatement {
    private static String footprint = "$Revision:   1.23.1.1.1.0  $";
    boolean lastGetWasNull = false;

    public BaseCallableStatement(BaseConnection baseConnection, String string, int n2, int n3) throws SQLException {
        super(baseConnection, string, n2, n3);
    }

    BaseParameter getAndValidateOutParameter(int n2) throws SQLException {
        this.validateParameterIndex(n2);
        BaseParameter baseParameter = this.currentParameters.get(n2, 2);
        if (baseParameter == null) {
            throw this.exceptions.getException(6011, "07009");
        }
        if (baseParameter.type != 1019 && baseParameter.data == null) {
            this.closeCurrentResults();
            while (this.currentResultType != 1) {
                if (this.currentResultType == 3) {
                    this.warnings.add(6082);
                } else {
                    this.warnings.add(6081);
                }
                this.getNextResultType();
            }
            if (baseParameter.type != 1019 && baseParameter.data == null) {
                throw this.exceptions.getException(6026);
            }
        }
        return baseParameter;
    }

    public Array getArray(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String[] stringArray = new String[]{"CallableStatement.getArray"};
            throw this.exceptions.getException(6004, stringArray);
        }
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            BigDecimal bigDecimal = baseParameter.getBigDecimal(this.exceptions);
            Object var4_5 = null;
            return bigDecimal;
        }
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            BigDecimal bigDecimal = baseParameter.getBigDecimal(n3, this.exceptions);
            Object var5_6 = null;
            return bigDecimal;
        }
    }

    public Blob getBlob(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            Blob blob = baseParameter.getBlob(this.connection, this.exceptions);
            Object var4_5 = null;
            return blob;
        }
    }

    public boolean getBoolean(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            boolean bl = baseParameter.getBoolean(this.exceptions);
            Object var4_5 = null;
            return bl;
        }
    }

    public byte getByte(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            byte by = baseParameter.getByte(this.exceptions);
            Object var4_5 = null;
            return by;
        }
    }

    public byte[] getBytes(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            byte[] byArray = baseParameter.getBytes(-1, baseParameter.getTransliterator(), this.exceptions);
            Object var4_5 = null;
            return byArray;
        }
    }

    public Clob getClob(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            Clob clob = baseParameter.getClob(this.connection, this.exceptions);
            Object var4_5 = null;
            return clob;
        }
    }

    public Date getDate(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            Date date = baseParameter.getDate(this.exceptions);
            Object var4_5 = null;
            return date;
        }
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            Date date = baseParameter.getDate(calendar, this.exceptions);
            Object var5_6 = null;
            return date;
        }
    }

    public double getDouble(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            double d2 = baseParameter.getDouble(this.exceptions);
            Object var5_5 = null;
            return d2;
        }
    }

    public float getFloat(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            float f2 = baseParameter.getFloat(this.exceptions);
            Object var4_5 = null;
            return f2;
        }
    }

    public int getInt(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            int n3 = baseParameter.getInteger(this.exceptions);
            Object var4_5 = null;
            return n3;
        }
    }

    public long getLong(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            long l2 = baseParameter.getLong(this.exceptions);
            Object var5_5 = null;
            return l2;
        }
    }

    public Object getObject(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            boolean bl = this.lastGetWasNull = baseParameter.type == 1019;
            if (this.lastGetWasNull) {
                Object var2_4 = null;
                Object var4_6 = null;
                return var2_4;
            }
            int n3 = BaseData.mapJDBCTypeToJavaObjectType(baseParameter.sqlType);
            Object object = baseParameter.getObject(n3, -1, this.connection, this.exceptions);
            Object var4_7 = null;
            return object;
        }
    }

    public Object getObject(int n2, Map map) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            Object object = this.getObject(n2);
            Object var5_5 = null;
            return object;
        }
    }

    public Ref getRef(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String[] stringArray = new String[]{"CallableStatement.getRef"};
            throw this.exceptions.getException(6004, stringArray);
        }
    }

    public short getShort(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            short s2 = baseParameter.getShort(this.exceptions);
            Object var4_5 = null;
            return s2;
        }
    }

    public String getString(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            String string = baseParameter.getString(-1, this.exceptions);
            Object var4_5 = null;
            return string;
        }
    }

    public Time getTime(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            Time time = baseParameter.getTime(this.exceptions);
            Object var4_5 = null;
            return time;
        }
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            Time time = baseParameter.getTime(calendar, this.exceptions);
            Object var5_6 = null;
            return time;
        }
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            Timestamp timestamp = baseParameter.getTimestamp(this.exceptions);
            Object var4_5 = null;
            return timestamp;
        }
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.type == 1019;
            Timestamp timestamp = baseParameter.getTimestamp(calendar, this.exceptions);
            Object var5_6 = null;
            return timestamp;
        }
    }

    public void registerOutParameter(int n2, int n3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateSqlType(n3);
            BaseParameter baseParameter = new BaseParameter(n3, 1000, null);
            this.currentParameters.set(n2, 2, baseParameter);
        }
    }

    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseParameter baseParameter = new BaseParameter(n3, 1000, null, n4);
            this.currentParameters.set(n2, 2, baseParameter);
        }
    }

    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.registerOutParameter(n2, n3);
        }
    }

    public boolean wasNull() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = this.lastGetWasNull;
            Object var3_3 = null;
            return bl;
        }
    }
}

