/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplBlob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class BaseBlobOutputStream
extends OutputStream {
    private static String footprint = "$Revision:   1.0.1.0  $";
    private BaseImplBlob implBlob;
    private Object synchronizer;
    private BaseExceptions exceptions;
    private long curPosition;

    public BaseBlobOutputStream(BaseImplBlob baseImplBlob, long l2, Object object, BaseExceptions baseExceptions) {
        this.implBlob = baseImplBlob;
        this.synchronizer = object;
        this.exceptions = baseExceptions;
        this.curPosition = l2 >= 1L ? l2 : 1L;
    }

    public void close() throws IOException {
        this.implBlob = null;
    }

    void validateClosed() throws IOException {
        if (this.implBlob == null) {
            SQLException sQLException = this.exceptions.getException(6010);
            throw new IOException(sQLException.getMessage());
        }
    }

    public void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosed();
            if (n3 == 0) {
                Object var5_5 = null;
                return;
            }
            if (n2 < 0 || n2 + n3 > byArray.length) {
                String[] stringArray = new String[]{new String("write")};
                SQLException sQLException = this.exceptions.getException(6070, stringArray);
                throw new IOException(sQLException.getMessage());
            }
            try {
                int n4 = this.implBlob.writeData(this.curPosition, byArray, n2, n3);
                this.curPosition += (long)n4;
                if (n4 != n3) {
                    throw this.exceptions.getException(6080);
                }
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
    }
}

