/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplBlob;
import com.microsoft.util.UtilDebug;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class BaseBlobInputStream
extends InputStream {
    private static String footprint = "$Revision:   1.4.1.0  $";
    private long currentPosition;
    private long dataLength;
    private BaseImplBlob implBlob;
    BaseExceptions exceptions;

    public BaseBlobInputStream(BaseImplBlob baseImplBlob, BaseExceptions baseExceptions) throws SQLException {
        UtilDebug.assert("Must supplay a BaseImplBlob derivative", baseImplBlob != null);
        UtilDebug.assert("Must supply an exception generator", baseExceptions != null);
        this.currentPosition = 1L;
        this.implBlob = baseImplBlob;
        this.dataLength = baseImplBlob.getLength();
        this.exceptions = baseExceptions;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.currentPosition > this.dataLength) {
            return -1;
        }
        try {
            int n2 = this.implBlob.readData(byArray, 0, this.currentPosition, 1);
            if (n2 == 0) {
                return -1;
            }
            ++this.currentPosition;
            return byArray[0] & 0xFF;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.currentPosition > this.dataLength) {
            return -1;
        }
        long l2 = this.dataLength - (this.currentPosition - 1L);
        if (l2 < Integer.MAX_VALUE && n3 > (n4 = new Long(l2).intValue())) {
            n3 = n4;
        }
        try {
            int n5 = this.implBlob.readData(byArray, n2, this.currentPosition, n3);
            if (n5 == 0) {
                return -1;
            }
            this.currentPosition += (long)n5;
            return n5;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }
}

