/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.wrapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class WrapperException
extends Exception {
    private int _errorCode = 0;
    private String[] _tokens = null;
    private String _functionName = null;

    private WrapperException() {
    }

    public WrapperException(String string) {
        super(string);
    }

    public WrapperException(int n2, String string, String[] stringArray) {
        this._errorCode = n2;
        this._functionName = string;
        this._tokens = stringArray;
    }

    public String getMessage() {
        if (this._errorCode != 0) {
            return "DB2 error code " + this._errorCode + " in function " + this._functionName;
        }
        return super.getMessage();
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            byteArrayOutputStream.flush();
            String string = byteArrayOutputStream.toString();
            printWriter.close();
            byteArrayOutputStream.close();
            return string;
        }
        catch (IOException iOException) {
            return "getStackTrace - exception: " + iOException.getMessage();
        }
    }

    public final void setErrorCode(int n2) {
        this._errorCode = n2;
    }

    public final int getErrorCode() {
        return this._errorCode;
    }

    public final int getAndResetErrorCode() {
        int n2 = this._errorCode;
        this._errorCode = 0;
        return n2;
    }

    public final void setFunctionName(String string) {
        this._functionName = string;
    }

    public final String getFunctionName() {
        return this._functionName;
    }

    public final String getAndResetFunctionName() {
        String string = this._functionName;
        this._functionName = null;
        return string;
    }

    public final void setTokens(String[] stringArray) {
        this._tokens = stringArray;
    }

    public final String[] getTokens() {
        return this._tokens;
    }

    public final String[] getAndResetTokens() {
        String[] stringArray = this._tokens;
        this._tokens = null;
        return stringArray;
    }
}

