/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.wrapper;

import com.ibm.db2.wrapper.Nickname;
import com.ibm.db2.wrapper.RemoteUser;
import com.ibm.db2.wrapper.ServerInfo;
import com.ibm.db2.wrapper.ServerInfoPacker;
import com.ibm.db2.wrapper.SqlqgBaseClass;
import com.ibm.db2.wrapper.Wrapper;
import com.ibm.db2.wrapper.WrapperException;
import java.util.Hashtable;

public class Server
extends SqlqgBaseClass {
    protected static final int RELATIONAL_KIND = 0;
    protected static final int GENERIC_KIND = 1;
    private String _name = null;
    private int _kind = 1;
    private Wrapper _wrapper = null;
    private String _type = null;
    private String _version = null;
    private Hashtable _users = null;
    protected Hashtable _nicknames = null;
    private ServerInfo _serverInfo = null;

    protected Server(String string, int n2, Wrapper wrapper) {
        this._wrapper = wrapper;
        this._name = string;
        this._kind = n2;
        this._users = new Hashtable();
        this._nicknames = new Hashtable();
    }

    public final String getName() {
        return this._name;
    }

    public final int getKind() {
        return this._kind;
    }

    public String getType() {
        return this._type;
    }

    public String getVersion() {
        return this._version;
    }

    public final ServerInfo getInfo() {
        return this._serverInfo;
    }

    private final RemoteUser getRemoteUser(String string) throws Exception {
        RemoteUser remoteUser = (RemoteUser)this._users.get(string);
        if (remoteUser == null) {
            remoteUser = this.createRemoteUser(string);
            this._users.put(string, remoteUser);
        }
        return remoteUser;
    }

    public final RemoteUser findRemoteUser(String string) {
        return (RemoteUser)this._users.get(string);
    }

    private final void addRemoteUser(RemoteUser remoteUser) throws WrapperException {
        if (this._users.get(remoteUser.getLocalName()) != null) {
            throw new WrapperException("Duplicate user mapping");
        }
        this._users.put(remoteUser.getLocalName(), remoteUser);
    }

    private void dropRemoteUser(RemoteUser remoteUser) {
        this._users.remove(remoteUser.getLocalName());
    }

    private void dropAllRemoteUsers() {
        this._users.clear();
        this._users = null;
    }

    private final Nickname getNickname(String string, String string2) throws Exception {
        Nickname nickname = (Nickname)this._nicknames.get(string + "." + string2);
        if (nickname == null) {
            nickname = this.createNickname(string, string2);
            this._nicknames.put(string + "." + string2, nickname);
        }
        return nickname;
    }

    private final void addNickname(Nickname nickname) throws WrapperException {
        if (this._nicknames.get(nickname.getLocalSchema() + "." + nickname.getLocalName()) != null) {
            throw new WrapperException("Duplicate nickname");
        }
        this._nicknames.put(nickname.getLocalSchema() + "." + nickname.getLocalName(), nickname);
    }

    private void dropNickname(Nickname nickname) {
        this._nicknames.remove(nickname.getLocalSchema() + "." + nickname.getLocalName());
    }

    private void dropAllNicknames() {
        this._nicknames.clear();
        this._nicknames = null;
    }

    private final void initializeMyServer(byte[] byArray) throws Exception {
        ServerInfoPacker serverInfoPacker = new ServerInfoPacker();
        this._serverInfo = serverInfoPacker.unpack(byArray);
        this._type = this._serverInfo != null ? this._serverInfo.getType() : null;
        this._version = this._serverInfo != null ? this._serverInfo.getVersion() : null;
        this.initializeMyServer(this._serverInfo);
    }

    protected void initializeMyServer(ServerInfo serverInfo) throws Exception {
    }

    protected RemoteUser createRemoteUser(String string) throws Exception {
        throw new WrapperException("Method not implemented");
    }

    protected Nickname createNickname(String string, String string2) throws Exception {
        throw new WrapperException("Method not implemented");
    }

    public final Wrapper getWrapper() {
        return this._wrapper;
    }

    protected void finalize() {
        this.dropAllNicknames();
        this.dropAllRemoteUsers();
    }
}

