/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.wrapper;

import com.ibm.db2.wrapper.Data;
import com.ibm.db2.wrapper.WrapperException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public final class RuntimeData
extends Data {
    private int _index;
    private byte _invariant;
    private int _actualLength;
    private boolean _forBitData;
    private boolean _nullable;
    private short _nullIndicator;
    private short _type;
    private int _maxLength;
    private byte _precision;
    private byte _scale;
    private short _codepage;
    private String _name;
    private short _remoteType;
    private int _remoteLength;
    private byte _remotePrecision;
    private byte _remoteScale;
    private boolean _indexValid = false;
    private boolean _invariantValid = false;
    private boolean _actualLengthValid = false;
    private boolean _forBitDataValid = false;
    private boolean _nullableValid = false;
    private boolean _nullIndicatorValid = false;
    private boolean _typeValid = false;
    private boolean _maxLengthValid = false;
    private boolean _precisionValid = false;
    private boolean _scaleValid = false;
    private boolean _codepageValid = false;
    private boolean _nameValid = false;
    private boolean _remoteTypeValid = false;
    private boolean _remoteLengthValid = false;
    private boolean _remotePrecisionValid = false;
    private boolean _remoteScaleValid = false;
    private long _cRuntimeData;

    protected RuntimeData(long l2) {
        this._cRuntimeData = l2;
    }

    protected long getCRuntimeData() {
        return this._cRuntimeData;
    }

    public int getDataIndex() {
        if (!this._indexValid) {
            this._index = RuntimeData.nativeGetDataIndex(this._cRuntimeData);
            this._indexValid = true;
        }
        return this._index;
    }

    public byte getInvariant() {
        if (!this._invariantValid) {
            this._invariant = RuntimeData.nativeGetInvariant(this._cRuntimeData);
            this._invariantValid = true;
        }
        return this._invariant;
    }

    public int getActualLength() {
        if (!this._actualLengthValid) {
            this._actualLength = RuntimeData.nativeGetActualLength(this._cRuntimeData);
            this._actualLengthValid = true;
        }
        return this._actualLength;
    }

    public void setActualLength(int n2) {
        RuntimeData.nativeSetActualLength(this._cRuntimeData, n2);
        this._actualLength = n2;
        this._actualLengthValid = true;
    }

    protected byte[] getData() {
        return RuntimeData.nativeGetData(this._cRuntimeData);
    }

    private void setData(byte[] byArray) throws WrapperException {
        if (byArray == null) {
            this.setDataNull();
        } else {
            RuntimeData.nativeSetData(this._cRuntimeData, byArray, byArray.length);
        }
    }

    public void setDataNull() throws WrapperException {
        RuntimeData.nativeSetDataNull(this._cRuntimeData);
    }

    public void clearNullIndicator() throws WrapperException {
        RuntimeData.nativeClearNullIndicator(this._cRuntimeData);
    }

    public void setFriendlyDivBy0() throws WrapperException {
        RuntimeData.nativeSetFriendlyDivBy0(this._cRuntimeData);
    }

    public void setFriendlyException() throws WrapperException {
        RuntimeData.nativeSetFriendlyException(this._cRuntimeData);
    }

    public boolean isDataNull() {
        return RuntimeData.nativeIsDataNull(this._cRuntimeData) != 0;
    }

    public boolean isDataNullable() {
        if (!this._nullableValid) {
            this._nullable = RuntimeData.nativeIsDataNullable(this._cRuntimeData) != 0;
            this._nullableValid = true;
        }
        return this._nullable;
    }

    public boolean isSemanticNull() {
        return RuntimeData.nativeIsSemanticNull(this._cRuntimeData) != 0;
    }

    public boolean checkFriendlyDivBy0() {
        return RuntimeData.nativeCheckFriendlyDivBy0(this._cRuntimeData) != 0;
    }

    public boolean checkFriendlyException() {
        return RuntimeData.nativeCheckFriendlyException(this._cRuntimeData) != 0;
    }

    public boolean getForBitData() {
        if (!this._forBitDataValid) {
            this._forBitData = RuntimeData.nativeGetForBitData(this._cRuntimeData) == 1;
            this._forBitDataValid = true;
        }
        return this._forBitData;
    }

    public short getNullIndicator() {
        if (!this._nullIndicatorValid) {
            this._nullIndicator = RuntimeData.nativeGetNullIndicator(this._cRuntimeData);
            this._nullIndicatorValid = true;
        }
        return this._nullIndicator;
    }

    public void setNullIndicator(short s2) {
        RuntimeData.nativeSetNullIndicator(this._cRuntimeData, s2);
        this._nullIndicator = s2;
        this._nullIndicatorValid = true;
    }

    public short getDataType() {
        if (!this._typeValid) {
            this._type = RuntimeData.nativeGetDataType(this._cRuntimeData);
            this._typeValid = true;
        }
        return this._type;
    }

    public int getMaximumLength() {
        if (!this._maxLengthValid) {
            this._maxLength = RuntimeData.nativeGetMaximumLength(this._cRuntimeData);
            this._maxLengthValid = true;
        }
        return this._maxLength;
    }

    public byte getPrecision() {
        if (!this._precisionValid) {
            this._precision = RuntimeData.nativeGetPrecision(this._cRuntimeData);
            this._precisionValid = true;
        }
        return this._precision;
    }

    public void setPrecision(byte by) {
        RuntimeData.nativeSetPrecision(this._cRuntimeData, by);
        this._precision = by;
        this._precisionValid = true;
    }

    public byte getScale() {
        if (!this._scaleValid) {
            this._scale = RuntimeData.nativeGetScale(this._cRuntimeData);
            this._scaleValid = true;
        }
        return this._scale;
    }

    public void setScale(byte by) {
        RuntimeData.nativeSetScale(this._cRuntimeData, by);
        this._scale = by;
        this._scaleValid = true;
    }

    public short getCodepage() {
        if (!this._codepageValid) {
            this._codepage = RuntimeData.nativeGetCodepage(this._cRuntimeData);
            this._codepageValid = true;
        }
        return this._codepage;
    }

    public String getName() {
        if (!this._nameValid) {
            this._name = RuntimeData.nativeGetName(this._cRuntimeData);
            this._nameValid = true;
        }
        return this._name;
    }

    public short getRemoteType() {
        if (!this._remoteTypeValid) {
            this._remoteType = RuntimeData.nativeGetRemoteType(this._cRuntimeData);
            this._remoteTypeValid = true;
        }
        return this._remoteType;
    }

    public int getRemoteLength() {
        if (!this._remoteLengthValid) {
            this._remoteLength = RuntimeData.nativeGetRemoteLength(this._cRuntimeData);
            this._remoteLengthValid = true;
        }
        return this._remoteLength;
    }

    public byte getRemotePrecision() {
        if (!this._remotePrecisionValid) {
            this._remotePrecision = RuntimeData.nativeGetRemotePrecision(this._cRuntimeData);
            this._remotePrecisionValid = true;
        }
        return this._remotePrecision;
    }

    public byte getRemoteScale() {
        if (!this._remoteScaleValid) {
            this._remoteScale = RuntimeData.nativeGetRemoteScale(this._cRuntimeData);
            this._remoteScaleValid = true;
        }
        return this._remoteScale;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws WrapperException {
        if (this.getDataType() != 484) {
            throw new WrapperException("Invalid data type");
        }
        this._data = bigDecimal;
        this.setData(this.getInternalData());
    }

    public void setBinary(byte[] byArray) throws WrapperException {
        if (!this.getForBitData()) {
            throw new WrapperException("Invalid data type");
        }
        this._data = byArray;
        this.setData(this.getInternalData());
    }

    public void setByte(byte by) throws WrapperException {
        short s2 = this.getDataType();
        if (s2 != 480 && s2 != 483 && s2 != 496 && s2 != 500 && s2 != 492) {
            throw new WrapperException("Invalid data type");
        }
        this._data = new Byte(by);
        this.setData(this.getInternalData());
    }

    public void setDate(Date date) throws WrapperException {
        if (this.getDataType() != 384) {
            throw new WrapperException("Invalid data type");
        }
        this._data = date;
        this.setData(this.getInternalData());
    }

    public void setDouble(double d2) throws WrapperException {
        short s2 = this.getDataType();
        if (s2 != 480 && s2 != 483) {
            throw new WrapperException("Invalid data type");
        }
        this._data = new Double(d2);
        this.setData(this.getInternalData());
    }

    public void setFloat(float f2) throws WrapperException {
        short s2 = this.getDataType();
        if (s2 != 480 && s2 != 483) {
            throw new WrapperException("Invalid data type");
        }
        this._data = new Float(f2);
        this.setData(this.getInternalData());
    }

    public void setInt(int n2) throws WrapperException {
        short s2 = this.getDataType();
        if (s2 != 480 && s2 != 483 && s2 != 496 && s2 != 500 && s2 != 492) {
            throw new WrapperException("Invalid data type");
        }
        this._data = new Integer(n2);
        this.setData(this.getInternalData());
    }

    public void setLong(long l2) throws WrapperException {
        short s2 = this.getDataType();
        if (s2 != 480 && s2 != 483 && s2 != 496 && s2 != 500 && s2 != 492) {
            throw new WrapperException("Invalid data type");
        }
        this._data = new Long(l2);
        this.setData(this.getInternalData());
    }

    public void setObject(Object object) throws WrapperException {
        this._data = object;
    }

    public void setShort(short s2) throws WrapperException {
        short s3 = this.getDataType();
        if (s3 != 480 && s3 != 483 && s3 != 496 && s3 != 500 && s3 != 492) {
            throw new WrapperException("Invalid data type");
        }
        this._data = new Short(s2);
        this.setData(this.getInternalData());
    }

    public void setString(String string) throws WrapperException {
        short s2 = this.getDataType();
        if (s2 != 452 && s2 != 448 || this.getForBitData()) {
            throw new WrapperException("Invalid data type");
        }
        this._data = string;
        this.setData(this.getInternalData());
    }

    public void setTime(Time time) throws WrapperException {
        if (this.getDataType() != 388) {
            throw new WrapperException("Invalid data type");
        }
        this._data = time;
        this.setData(this.getInternalData());
    }

    public void setTimestamp(Timestamp timestamp) throws WrapperException {
        if (this.getDataType() != 392) {
            throw new WrapperException("Invalid data type");
        }
        this._data = timestamp;
        this.setData(this.getInternalData());
    }

    private byte[] getInternalData() throws WrapperException {
        if (this._data == null) {
            return null;
        }
        short s2 = this.getDataType();
        switch (s2) {
            case 496: {
                return Data.encodeLong(((Number)this._data).intValue(), 4);
            }
            case 500: {
                return Data.encodeLong(((Number)this._data).shortValue(), 2);
            }
            case 480: {
                return Data.encodeLong(Double.doubleToLongBits(((Number)this._data).doubleValue()), 8);
            }
            case 483: {
                return Data.encodeLong(Float.floatToIntBits(((Number)this._data).floatValue()), 4);
            }
            case 492: {
                return Data.encodeLong(((Number)this._data).longValue(), 8);
            }
            case 448: 
            case 452: {
                if (this.getForBitData()) {
                    return (byte[])this._data;
                }
                return Data.encodeUTF8String((String)this._data);
            }
            case 484: {
                return ((BigDecimal)this._data).toString().getBytes();
            }
            case 384: {
                return Data.packDate((Date)this._data);
            }
            case 388: {
                return Data.packTime((Time)this._data);
            }
            case 392: {
                return Data.packTimestamp((Timestamp)this._data);
            }
        }
        throw new WrapperException("Data type not specified or not supported (" + s2 + ")");
    }

    private static final synchronized native int nativeGetDataIndex(long var0);

    private static final synchronized native byte nativeGetInvariant(long var0);

    private static final synchronized native int nativeGetActualLength(long var0);

    private static final synchronized native void nativeSetActualLength(long var0, int var2);

    private static final synchronized native byte[] nativeGetData(long var0);

    private static final synchronized native void nativeSetData(long var0, byte[] var2, int var3);

    private static final synchronized native void nativeSetDataNull(long var0) throws WrapperException;

    private static final synchronized native void nativeClearNullIndicator(long var0) throws WrapperException;

    private static final synchronized native void nativeSetFriendlyDivBy0(long var0) throws WrapperException;

    private static final synchronized native void nativeSetFriendlyException(long var0) throws WrapperException;

    private static final synchronized native int nativeIsDataNull(long var0);

    private static final synchronized native int nativeIsDataNullable(long var0);

    private static final synchronized native int nativeIsSemanticNull(long var0);

    private static final synchronized native int nativeCheckFriendlyDivBy0(long var0);

    private static final synchronized native int nativeCheckFriendlyException(long var0);

    private static final synchronized native byte nativeGetForBitData(long var0);

    private static final synchronized native short nativeGetNullIndicator(long var0);

    private static final synchronized native void nativeSetNullIndicator(long var0, short var2);

    private static final synchronized native short nativeGetDataType(long var0);

    private static final synchronized native int nativeGetMaximumLength(long var0);

    private static final synchronized native byte nativeGetPrecision(long var0);

    private static final synchronized native void nativeSetPrecision(long var0, byte var2);

    private static final synchronized native byte nativeGetScale(long var0);

    private static final synchronized native void nativeSetScale(long var0, byte var2);

    private static final synchronized native short nativeGetCodepage(long var0);

    private static final synchronized native String nativeGetName(long var0);

    private static final synchronized native short nativeGetRemoteType(long var0);

    private static final synchronized native int nativeGetRemoteLength(long var0);

    private static final synchronized native byte nativeGetRemotePrecision(long var0);

    private static final synchronized native byte nativeGetRemoteScale(long var0);
}

