/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.wrapper;

import com.ibm.db2.wrapper.ParsedQueryFragment;
import com.ibm.db2.wrapper.Quantifier;
import com.ibm.db2.wrapper.Request;
import com.ibm.db2.wrapper.RequestExp;
import com.ibm.db2.wrapper.UnfencedGenericServer;
import com.ibm.db2.wrapper.WrapperException;
import java.io.Serializable;

public class Reply
extends ParsedQueryFragment {
    public static final int ASC = 0;
    public static final int DESC = 1;
    private Request _request;
    private UnfencedGenericServer _server;
    private Reply _next = null;
    private Serializable _execDesc;
    private short _noBlock;
    private int[] _orderEntries;
    private int _orderEntriesCount;
    private static final int ORDER_ENTRIES_THRESHOLD = 5;
    private int[] _parameters = null;
    private static final int PARAM_ARRAY_THRESHOLD = 10;

    public Reply(Request request, UnfencedGenericServer unfencedGenericServer) {
        this._request = request;
        this._server = unfencedGenericServer;
        this._noBlock = 0;
        this._orderEntries = null;
        this._orderEntriesCount = 0;
    }

    public final void addOrderEntry(int n2, int n3) throws WrapperException {
        if (n3 != 0 && n3 != 1) {
            throw new WrapperException("addOrderEntry: invalid direction");
        }
        if (this._orderEntriesCount == 0) {
            this._orderEntries = new int[5];
        } else {
            int n4 = this._orderEntries.length;
            if (n4 <= this._orderEntriesCount) {
                int[] nArray = new int[n4 + 5];
                int n5 = 0;
                while (n5 < this._orderEntriesCount) {
                    nArray[n5] = this._orderEntries[n5];
                    ++n5;
                }
                this._orderEntries = nArray;
            }
        }
        this._orderEntries[this._orderEntriesCount++] = n2 * (n3 == 0 ? 1 : -1);
    }

    public final int getNumberOfOrderEntries() {
        return this._orderEntries == null ? 0 : this._orderEntries.length;
    }

    public final int[] getOrderEntry(int n2) throws WrapperException {
        if (n2 <= 0 || n2 > this._orderEntriesCount) {
            throw new WrapperException("getOrderEntry: index out of bonds");
        }
        int[] nArray = new int[]{Math.abs(this._orderEntries[n2 - 1]), this._orderEntries[n2] > 0 ? 0 : 1};
        return nArray;
    }

    public final Serializable getExecDesc() {
        return this._execDesc;
    }

    public final void setExecDesc(Serializable serializable) {
        this._execDesc = serializable;
    }

    public final void setNoBlock() {
        this._noBlock = 1;
    }

    public final short getNoBlock() {
        return this._noBlock;
    }

    public final Reply nextReply() {
        return this._next;
    }

    public final void setNextReply(Reply reply) {
        this._next = reply;
    }

    public final UnfencedGenericServer getServer() {
        return this._server;
    }

    public double cardinality() {
        return -1.0;
    }

    public double totalCost() {
        return -1.0;
    }

    public double reExecCost() {
        return -1.0;
    }

    public double firstTupleCost() {
        return -1.0;
    }

    public final void addHeadExp(RequestExp requestExp) {
        super.internalAddHeadExp(requestExp);
    }

    public final void addQuantifier(Quantifier quantifier) {
        super.internalAddQuantifier(quantifier);
    }

    public final void addPredicate(RequestExp requestExp) {
        super.internalAddPredicate(requestExp);
    }

    public final void setDistinct(boolean bl) {
        super.internalSetDistinct(bl);
    }

    public final int[] getParameterOrder() throws WrapperException {
        int n2 = this.getNumberOfHeadExp();
        int n3 = this.getNumberOfPredicates();
        this._parameters = null;
        int n4 = 0;
        RequestExp requestExp = null;
        int n5 = 1;
        while (n5 <= n2) {
            requestExp = this.getHeadExp(n5);
            n4 = this.getParametersForExp(requestExp, n4);
            ++n5;
        }
        int n6 = 1;
        while (n6 <= n3) {
            requestExp = this.getPredicate(n6);
            n4 = this.getParametersForExp(requestExp, n4);
            ++n6;
        }
        int[] nArray = null;
        if (n4 > 0) {
            nArray = new int[n4];
            int n7 = 0;
            while (n7 < n4) {
                nArray[n7] = this._parameters[n7];
                ++n7;
            }
        }
        this._parameters = null;
        return nArray;
    }

    private int getParametersForExp(RequestExp requestExp, int n2) throws WrapperException {
        int n3 = requestExp.getKind();
        switch (n3) {
            case 2: {
                if (this._parameters == null || n2 + 1 >= this._parameters.length) {
                    if (this._parameters == null) {
                        this._parameters = new int[10];
                    } else {
                        int[] nArray = new int[10 + this._parameters.length];
                        int n4 = 0;
                        while (n4 < this._parameters.length) {
                            nArray[n4] = this._parameters[n4];
                            ++n4;
                        }
                        this._parameters = nArray;
                    }
                }
                this._parameters[n2++] = requestExp.getHandle();
                break;
            }
            case 4: {
                RequestExp requestExp2 = requestExp.getFirstChild();
                while (requestExp2 != null) {
                    n2 = this.getParametersForExp(requestExp2, n2);
                    requestExp2 = requestExp2.getNextChild();
                }
                break;
            }
        }
        return n2;
    }
}

