/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.wrapper;

import com.ibm.db2.wrapper.FencedServer;
import com.ibm.db2.wrapper.RemoteConnection;
import com.ibm.db2.wrapper.RuntimeDataList;
import com.ibm.db2.wrapper.SqlqgBaseClass;
import com.ibm.db2.wrapper.Wrapper;
import com.ibm.db2.wrapper.WrapperException;
import com.ibm.db2.wrapper.WrapperUtilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class RemoteOperation
extends SqlqgBaseClass {
    protected static final int NO_KIND = 0;
    protected static final int QUERY_KIND = 1;
    protected static final int IUD_KIND = 2;
    protected static final int LOCK_KIND = 3;
    protected static final int PASSTHRU_KIND = 4;
    protected static final int STORED_PROC_KIND = 5;
    protected static final int INVOCATION_KIND = 6;
    protected static final int REMOTE_LOCK_KIND = 7;
    protected static final int SVPT_KIND = 8;
    private int _kind;
    private RemoteConnection _connection;
    protected long _cRemoteOperation;

    protected RemoteOperation(RemoteConnection remoteConnection, long l2, int n2) {
        this._connection = remoteConnection;
        this._cRemoteOperation = l2;
        this._kind = n2;
    }

    protected final int getKind() {
        return this._kind;
    }

    public final RemoteConnection getConnection() {
        return this._connection;
    }

    public final FencedServer getServer() {
        return this._connection.getServer();
    }

    public final RuntimeDataList getInputData() {
        long l2 = RemoteOperation.nativeGetInputData(this._cRemoteOperation, this._kind);
        if (l2 == 0L) {
            return null;
        }
        return new RuntimeDataList(l2);
    }

    public final RuntimeDataList getOutputData() {
        long l2 = RemoteOperation.nativeGetOutputData(this._cRemoteOperation, this._kind);
        if (l2 == 0L) {
            return null;
        }
        return new RuntimeDataList(l2);
    }

    protected void reportEof() throws WrapperException {
        RemoteOperation.nativeReportEof(this._cRemoteOperation, this._kind);
    }

    public final Object getExecDesc() throws WrapperException, IOException, ClassNotFoundException {
        WrapperUtilities.traceFunctionEntry(0, "getExecDesc");
        byte[] byArray = RemoteOperation.nativeGetExecDesc(this._cRemoteOperation, this._kind);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        byteArrayInputStream.close();
        WrapperUtilities.traceFunctionData(0, "getExecDesc", 1, object.toString());
        WrapperUtilities.traceFunctionReturnCode(0, "getExecDesc", 0);
        return object;
    }

    public final Wrapper getWrapper() {
        return this._connection.getWrapper();
    }

    private static final synchronized native long nativeGetInputData(long var0, int var2);

    private static final synchronized native long nativeGetOutputData(long var0, int var2);

    private static final synchronized native void nativeReportEof(long var0, int var2) throws WrapperException;

    private static final synchronized native byte[] nativeGetExecDesc(long var0, int var2) throws WrapperException;
}

