/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.wrapper;

import com.ibm.db2.wrapper.CatalogInfo;
import com.ibm.db2.wrapper.CatalogOption;
import com.ibm.db2.wrapper.ColumnInfo;
import com.ibm.db2.wrapper.IndexInfo;
import com.ibm.db2.wrapper.WrapperException;

public final class NicknameInfo
extends CatalogInfo {
    private short _numColumns = 0;
    private short _numIndexes = 0;
    private String _schema = null;
    private String _serverName = null;
    private String _nickname = null;
    private long _card = 0L;
    private int _nPages = 0;
    private int _fPages = 0;
    private int _overflow = 0;
    private boolean _schemaValid = false;
    private boolean _serverNameValid = false;
    private boolean _nicknameValid = false;
    private boolean _cardValid = false;
    private boolean _nPagesValid = false;
    private boolean _fPagesValid = false;
    private boolean _overflowValid = false;
    private IndexInfo _firstIndex = null;
    private ColumnInfo _firstColumn = null;
    private ColumnInfo _lastColumn = null;

    public void addOption(String string, String string2, int n2) throws WrapperException {
        super.addOption(string, string2, n2, "NICKNAME", this._nicknameValid ? this._nickname : "");
    }

    public void setSchema(String string) {
        this._schema = string;
        this._schemaValid = true;
    }

    public String getSchema() {
        return this._schema;
    }

    public void setNickname(String string) {
        this._nickname = string;
        this._nicknameValid = true;
    }

    public String getNickname() {
        return this._nickname;
    }

    public void setServerName(String string) {
        this._serverName = string;
        this._serverNameValid = true;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setCard(long l2) {
        this._card = l2;
        this._cardValid = true;
    }

    public long getCard() {
        return this._card;
    }

    public void setNPages(int n2) {
        this._nPages = n2;
        this._nPagesValid = true;
    }

    public int getNPages() {
        return this._nPages;
    }

    public void setFPages(int n2) {
        this._fPages = n2;
        this._fPagesValid = true;
    }

    public int getFPages() {
        return this._fPages;
    }

    public void setOverflow(int n2) {
        this._overflow = n2;
        this._overflowValid = true;
    }

    public int getOverflow() {
        return this._overflow;
    }

    public boolean isSchemaValid() {
        return this._schemaValid;
    }

    public boolean isServerNameValid() {
        return this._serverNameValid;
    }

    public boolean isNicknameValid() {
        return this._nicknameValid;
    }

    public boolean isCardValid() {
        return this._cardValid;
    }

    public boolean isNPagesValid() {
        return this._nPagesValid;
    }

    public boolean isFPagesValid() {
        return this._fPagesValid;
    }

    public boolean isOverflowValid() {
        return this._overflowValid;
    }

    public void insertColumn(ColumnInfo columnInfo) throws WrapperException {
        short s2;
        if (columnInfo == null) {
            throw new WrapperException("The ColumnInfo object is null");
        }
        if (columnInfo.isColumnIDValid()) {
            s2 = columnInfo.getColumnID();
        } else {
            s2 = 0;
            columnInfo.setColumnID((short)0);
        }
        if (this._firstColumn == null) {
            this._firstColumn = this._lastColumn = columnInfo;
        } else if (this._lastColumn.getColumnID() < s2) {
            this._lastColumn.setNextColumn(columnInfo);
            this._lastColumn = columnInfo;
        } else if (this._firstColumn.getColumnID() > s2) {
            columnInfo.setNextColumn(this._firstColumn);
            this._firstColumn = columnInfo;
        } else {
            ColumnInfo columnInfo2 = this._firstColumn;
            ColumnInfo columnInfo3 = this._firstColumn.getNextColumn();
            while (s2 > columnInfo3.getColumnID()) {
                columnInfo2 = columnInfo3;
                columnInfo3 = columnInfo3.getNextColumn();
            }
            columnInfo2.setNextColumn(columnInfo);
            columnInfo.setNextColumn(columnInfo3);
        }
        this._numColumns = (short)(this._numColumns + 1);
    }

    public int getNumColumns() {
        return this._numColumns;
    }

    public ColumnInfo getFirstColumn() {
        return this._firstColumn;
    }

    public ColumnInfo getNextColumn(ColumnInfo columnInfo) {
        return columnInfo.getNextColumn();
    }

    public ColumnInfo getColumn(String string) {
        ColumnInfo columnInfo = this._firstColumn;
        while (columnInfo != null) {
            if (string.equals(columnInfo.getColumnName())) {
                return columnInfo;
            }
            columnInfo = columnInfo.getNextColumn();
        }
        return null;
    }

    public ColumnInfo getColumnWithRemoteColumnName(String string) throws WrapperException {
        if (string == null) {
            return null;
        }
        ColumnInfo columnInfo = this.getFirstColumn();
        while (columnInfo != null) {
            CatalogOption catalogOption = columnInfo.getOption("REMOTE_COLUMN_NAME");
            if (catalogOption != null && string.equals(catalogOption.getValue())) {
                return columnInfo;
            }
            columnInfo = this.getNextColumn(columnInfo);
        }
        return null;
    }

    public void insertIndex(IndexInfo indexInfo) throws WrapperException {
        if (indexInfo == null) {
            throw new WrapperException("The IndexInfo object is null");
        }
        indexInfo.setNextIndex(this._firstIndex);
        if (this._firstIndex != null) {
            this._firstIndex.setPrevIndex(indexInfo);
        }
        this._firstIndex = indexInfo;
        this._numIndexes = (short)(this._numIndexes + 1);
    }

    public int getNumIndexes() {
        return this._numIndexes;
    }

    public IndexInfo getFirstIndex() {
        return this._firstIndex;
    }

    public IndexInfo getNextIndex(IndexInfo indexInfo) {
        return indexInfo.getNextIndex();
    }

    public IndexInfo getIndex(String string) {
        IndexInfo indexInfo = this._firstIndex;
        while (indexInfo != null) {
            if (string.equals(indexInfo.getIndexName())) {
                return indexInfo;
            }
            indexInfo = indexInfo.getNextIndex();
        }
        return null;
    }
}

