/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.wrapper;

import com.ibm.db2.wrapper.Data;
import com.ibm.db2.wrapper.WrapperException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.sql.Timestamp;
import java.util.Calendar;

public class DataBuffer {
    protected ByteArrayOutputStream _outBuffer = new ByteArrayOutputStream();
    protected ByteArrayInputStream _inBuffer = null;

    protected DataBuffer() {
    }

    protected final void resetBuffer() {
        this._inBuffer = null;
        this._outBuffer = new ByteArrayOutputStream();
    }

    protected final void setBuffer(byte[] byArray) {
        this._inBuffer = byArray == null ? null : new ByteArrayInputStream(byArray);
    }

    protected final int available() {
        if (this._inBuffer == null) {
            return -1;
        }
        return this._inBuffer.available();
    }

    protected final byte[] readBuffer() {
        if (this._inBuffer == null) {
            return null;
        }
        int n2 = this._inBuffer.available();
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        this._inBuffer.read(byArray, 0, n2);
        return byArray;
    }

    protected final byte[] readBuffer(int n2) {
        if (this._inBuffer == null) {
            return null;
        }
        int n3 = this._inBuffer.available();
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        this._inBuffer.read(byArray, 0, n2);
        return byArray;
    }

    protected final byte[] getBuffer() {
        return this._outBuffer.toByteArray();
    }

    protected final long getLong() {
        return this.getLong(false);
    }

    protected final long getLong(boolean bl) {
        long l2 = 0L;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < 8) {
            if (this._inBuffer.available() <= 0) break;
            int n3 = this._inBuffer.read();
            int n4 = n3 < 0 ? 256 + n3 : n3;
            l2 = l2 * 256L + (long)n4;
            if (bl && n2 == 0) {
                bl2 = l2 > 127L;
            }
            ++n2;
        }
        if (bl && bl2) {
            l2 = -(l2 ^ 0xFFFFFFFFFFFFFFFFL) - 1L;
        }
        return l2;
    }

    protected final int getInt() {
        return this.getInt(false);
    }

    protected final int getInt(boolean bl) {
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < 4) {
            if (this._inBuffer.available() <= 0) break;
            int n4 = this._inBuffer.read();
            int n5 = n4 < 0 ? 256 + n4 : n4;
            n2 = n2 * 256 + n5;
            if (bl && n3 == 0) {
                bl2 = n2 > 127;
            }
            ++n3;
        }
        if (bl && bl2) {
            n2 = -(~n2) - 1;
        }
        return n2;
    }

    protected final short getShort() {
        return this.getShort(false);
    }

    protected final short getShort(boolean bl) {
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < 2) {
            if (this._inBuffer.available() <= 0) break;
            int n4 = this._inBuffer.read();
            int n5 = n4 < 0 ? 256 + n4 : n4;
            n2 = n2 * 256 + n5;
            if (bl && n3 == 0) {
                bl2 = n2 > 127;
            }
            ++n3;
        }
        if (bl && bl2) {
            n2 = -(n2 ^ 0xFFFF) - 1;
        }
        return (short)n2;
    }

    protected final byte getByte() {
        return this.getByte(false);
    }

    protected final byte getByte(boolean bl) {
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < 1) {
            if (this._inBuffer.available() <= 0) break;
            int n4 = this._inBuffer.read();
            int n5 = n4 < 0 ? 256 + n4 : n4;
            n2 = n2 * 256 + n5;
            if (bl && n3 == 0) {
                bl2 = n2 > 127;
            }
            ++n3;
        }
        if (bl && bl2) {
            n2 = -(n2 ^ 0xFF) - 1;
        }
        return (byte)n2;
    }

    protected final boolean getBoolean() {
        if (this._inBuffer.available() <= 0) {
            return false;
        }
        return this._inBuffer.read() != 0;
    }

    protected final char getChar() {
        if (this._inBuffer.available() <= 0) {
            return ' ';
        }
        return (char)this._inBuffer.read();
    }

    protected final String getString() {
        int n2 = this.getInt(false);
        if (n2 <= 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        this._inBuffer.read(byArray, 0, n2);
        String string = new String(byArray);
        return string;
    }

    protected final String getUTF8String() {
        StringBuffer stringBuffer = null;
        int n2 = this.getInt(false);
        if (n2 <= 0) {
            return null;
        }
        stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = this._inBuffer.read();
            if (n5 < 0) {
                n5 += 256;
            }
            if ((n4 = this._inBuffer.read()) < 0) {
                n4 += 256;
            }
            char c2 = (char)(n5 * 256 + n4);
            stringBuffer.append(c2);
            ++n3;
        }
        return stringBuffer.toString();
    }

    protected final String getBinary() {
        return this.getString();
    }

    protected final String getUTF8Binary() {
        return this.getUTF8String();
    }

    private final byte hexToDec(int n2) {
        if (n2 < 0) {
            n2 = 256 + n2;
        }
        int n3 = n2 / 16;
        return (byte)(n3 * 10 + (n2 & 0xF));
    }

    private final byte decToHex(int n2) {
        int n3 = n2 / 10;
        if ((n3 = n3 * 16 + n2 % 10) > 127) {
            n3 -= 256;
        }
        return (byte)n3;
    }

    private final Timestamp decodeTimestamp(byte[] byArray) throws WrapperException {
        if (byArray.length != 10) {
            throw new WrapperException("Invalid timestamp data");
        }
        int n2 = this.hexToDec(byArray[0]) * 100 + this.hexToDec(byArray[1]);
        if (n2 == 0) {
            return null;
        }
        byte by = this.hexToDec(byArray[2]);
        byte by2 = this.hexToDec(byArray[3]);
        byte by3 = this.hexToDec(byArray[4]);
        byte by4 = this.hexToDec(byArray[5]);
        byte by5 = this.hexToDec(byArray[6]);
        int n3 = (this.hexToDec(byArray[7]) * 100 + this.hexToDec(byArray[8])) * 100 + this.hexToDec(byArray[9]);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n2);
        calendar.set(2, by - 1);
        calendar.set(5, by2);
        calendar.set(11, by3);
        calendar.set(12, by4);
        calendar.set(13, by5);
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        timestamp.setNanos(n3 * 1000);
        return timestamp;
    }

    private final byte[] encodeTimestamp(Timestamp timestamp) throws WrapperException {
        byte[] byArray = new byte[10];
        if (timestamp == null) {
            int n2 = 0;
            while (n2 < 10) {
                byArray[n2] = 0;
                ++n2;
            }
            return byArray;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int n3 = calendar.get(1);
        byArray[0] = this.decToHex(n3 / 100);
        byArray[1] = this.decToHex(n3 % 100);
        byArray[2] = this.decToHex(calendar.get(2) + 1);
        byArray[3] = this.decToHex(calendar.get(5));
        byArray[4] = this.decToHex(calendar.get(11));
        byArray[5] = this.decToHex(calendar.get(12));
        byArray[6] = this.decToHex(calendar.get(13));
        int n4 = timestamp.getNanos() / 1000;
        byArray[7] = this.decToHex(n4 / 10000);
        byArray[8] = this.decToHex(n4 / 100 % 100);
        byArray[9] = this.decToHex(n4 % 100);
        return byArray;
    }

    protected final Timestamp getTimestamp() throws WrapperException {
        byte[] byArray = new byte[10];
        this._inBuffer.read(byArray, 0, 10);
        return this.decodeTimestamp(byArray);
    }

    protected final void addDouble(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        this.addLong(l2);
    }

    protected final void addLong(long l2) {
        byte[] byArray = Data.encodeLong(l2, 8);
        this._outBuffer.write(byArray, 0, 8);
    }

    protected final void addInt(int n2) {
        byte[] byArray = Data.encodeLong(n2, 4);
        this._outBuffer.write(byArray, 0, 4);
    }

    protected final void addShort(short s2) {
        byte[] byArray = Data.encodeLong(s2, 2);
        this._outBuffer.write(byArray, 0, 2);
    }

    protected final void addByte(byte by) {
        this._outBuffer.write(by);
    }

    protected final void addBoolean(boolean bl) {
        this._outBuffer.write(bl ? 1 : 0);
    }

    protected final void addChar(char c2) {
        this._outBuffer.write(c2);
    }

    protected final void addString(String string) {
        if (string == null) {
            this.addInt(0);
        } else {
            int n2 = string.length();
            this.addInt(n2);
            this._outBuffer.write(string.getBytes(), 0, n2);
        }
    }

    protected final void addUTF8String(String string) {
        if (string == null) {
            this.addInt(0);
        } else {
            int n2 = string.length();
            this.addInt(n2);
            int n3 = 0;
            while (n3 < n2) {
                char c2 = string.charAt(n3);
                int n4 = c2 / 256;
                int n5 = c2 % 256;
                this._outBuffer.write(n4);
                this._outBuffer.write(n5);
                ++n3;
            }
        }
    }

    protected final void addBinary(String string) {
        this.addString(string);
    }

    protected final void addUTF8Binary(String string) {
        this.addUTF8String(string);
    }

    protected final void addBinary(byte[] byArray) {
        if (byArray == null) {
            this.addInt(0);
        } else {
            this.addInt(byArray.length);
            this._outBuffer.write(byArray, 0, byArray.length);
        }
    }

    protected final void addTimestamp(Timestamp timestamp) throws WrapperException {
        this._outBuffer.write(this.encodeTimestamp(timestamp), 0, 10);
    }
}

