/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.wrapper;

import com.ibm.db2.wrapper.WrapperException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public abstract class Data {
    public static final short NONE = -1;
    public static final short SHORT = 500;
    public static final short INT = 496;
    public static final short DECIMAL = 484;
    public static final short DOUBLE = 480;
    public static final short FLOAT = 483;
    public static final short LONG = 492;
    public static final short CHAR = 452;
    public static final short VARCHAR = 448;
    public static final short DATE = 384;
    public static final short TIME = 388;
    public static final short TIMESTAMP = 392;
    public static final short BLOB = 404;
    public static final short CLOB = 408;
    protected Object _data = null;
    private boolean _gotData = false;

    protected Data() {
    }

    protected abstract byte[] getData();

    public abstract boolean getForBitData();

    public abstract short getDataType();

    public BigDecimal getBigDecimal() throws WrapperException {
        this.setInternalData();
        if (this._data != null && this._data instanceof BigDecimal) {
            return (BigDecimal)this._data;
        }
        throw new WrapperException("Invalid data type");
    }

    public byte getByte() throws WrapperException {
        this.setInternalData();
        if (this._data != null && this._data instanceof Number) {
            return ((Number)this._data).byteValue();
        }
        throw new WrapperException("Invalid data type");
    }

    public java.sql.Date getDate() throws WrapperException {
        this.setInternalData();
        if (this._data != null && this._data instanceof java.sql.Date) {
            return (java.sql.Date)this._data;
        }
        throw new WrapperException("Invalid data type");
    }

    public double getDouble() throws WrapperException {
        this.setInternalData();
        if (this._data != null && this._data instanceof Number) {
            return ((Number)this._data).doubleValue();
        }
        throw new WrapperException("Invalid data type");
    }

    public float getFloat() throws WrapperException {
        this.setInternalData();
        if (this._data != null && this._data instanceof Number) {
            return ((Number)this._data).floatValue();
        }
        throw new WrapperException("Invalid data type");
    }

    public int getInt() throws WrapperException {
        this.setInternalData();
        if (this._data != null && this._data instanceof Number) {
            return ((Number)this._data).intValue();
        }
        throw new WrapperException("Invalid data type");
    }

    public long getLong() throws WrapperException {
        this.setInternalData();
        if (this._data != null && this._data instanceof Number) {
            return ((Number)this._data).longValue();
        }
        throw new WrapperException("Invalid data type");
    }

    public Object getObject() throws WrapperException {
        this.setInternalData();
        return this._data;
    }

    public short getShort() throws WrapperException {
        this.setInternalData();
        if (this._data != null && this._data instanceof Number) {
            return ((Number)this._data).shortValue();
        }
        throw new WrapperException("Invalid data type");
    }

    public String getString() throws WrapperException {
        this.setInternalData();
        if (this._data != null && this._data instanceof String) {
            return (String)this._data;
        }
        throw new WrapperException("Invalid data type");
    }

    public Time getTime() throws WrapperException {
        this.setInternalData();
        if (this._data != null && this._data instanceof Time) {
            return (Time)this._data;
        }
        throw new WrapperException("Invalid data type");
    }

    public Timestamp getTimestamp() throws WrapperException {
        this.setInternalData();
        if (this._data != null && this._data instanceof Timestamp) {
            return (Timestamp)this._data;
        }
        throw new WrapperException("Invalid data type");
    }

    protected static long decodeLong(byte[] byArray, int n2) {
        long l2 = 0L;
        boolean bl = false;
        if (byArray == null) {
            return 0L;
        }
        int n3 = byArray.length;
        if (n2 > n3) {
            n2 = n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5 = byArray[n4];
            int n6 = n5 < 0 ? 256 + n5 : n5;
            l2 = l2 * 256L + (long)n6;
            if (n4 == 0) {
                bl = l2 > 127L;
            }
            ++n4;
        }
        if (bl) {
            l2 = -(l2 ^ 0xFFFFFFFFFFFFFFFFL) - 1L;
        }
        return l2;
    }

    protected static String decodeUTF8String(byte[] byArray) {
        StringBuffer stringBuffer = null;
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length / 2;
        stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            int n6;
            if ((n6 = byArray[n3++]) < 0) {
                n6 += 256;
            }
            if ((n5 = byArray[n3++]) < 0) {
                n5 += 256;
            }
            char c2 = (char)(n6 * 256 + n5);
            stringBuffer.append(c2);
            ++n4;
        }
        return stringBuffer.toString();
    }

    protected static byte[] encodeLong(long l2, int n2) {
        boolean bl;
        byte[] byArray = new byte[n2];
        long l3 = l2;
        if (l3 < 0L) {
            l3 = -l3 - 1L;
            bl = true;
        } else {
            bl = false;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (int)(l3 % 256L);
            if (bl) {
                n4 = 255 - n4;
            }
            l3 /= 256L;
            byArray[n2 - n3 - 1] = (byte)n4;
            ++n3;
        }
        return byArray;
    }

    protected static byte[] encodeUTF8String(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        byte[] byArray = new byte[2 * n2];
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            int n4 = c2 / 256;
            int n5 = c2 % 256;
            byArray[2 * n3] = (byte)n4;
            byArray[2 * n3 + 1] = (byte)n5;
            ++n3;
        }
        return byArray;
    }

    private String trimAt0(String string) {
        int n2 = string.indexOf("\u0000");
        if (n2 >= 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    protected static byte[] packDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n2 = calendar.get(1);
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        byte[] byArray = new byte[4];
        int n5 = n2 / 100;
        int n6 = n5 / 10 * 16 + n5 % 10;
        byArray[0] = (byte)n6;
        n5 = n2 % 100;
        n6 = n5 / 10 * 16 + n5 % 10;
        byArray[1] = (byte)n6;
        n6 = n3 / 10 * 16 + n3 % 10;
        byArray[2] = (byte)n6;
        n6 = n4 / 10 * 16 + n4 % 10;
        byArray[3] = (byte)n6;
        return byArray;
    }

    protected static byte[] packTime(Time time) {
        if (time == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int n2 = calendar.get(11);
        int n3 = calendar.get(12);
        int n4 = calendar.get(13);
        byte[] byArray = new byte[3];
        int n5 = n2 / 10 * 16 + n2 % 10;
        byArray[0] = (byte)n5;
        n5 = n3 / 10 * 16 + n3 % 10;
        byArray[1] = (byte)n5;
        n5 = n4 / 10 * 16 + n4 % 10;
        byArray[2] = (byte)n5;
        return byArray;
    }

    protected static byte[] packTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        byte[] byArray = new byte[10];
        int n2 = timestamp.getNanos();
        byte[] byArray2 = Data.packDate(timestamp);
        byArray[0] = byArray2[0];
        byArray[1] = byArray2[1];
        byArray[2] = byArray2[2];
        byArray[3] = byArray2[3];
        byte[] byArray3 = Data.packTime(new Time(((Date)timestamp).getTime()));
        byArray[4] = byArray3[0];
        byArray[5] = byArray3[1];
        byArray[6] = byArray3[2];
        int n3 = n2 / 10000;
        int n4 = n3 / 10 * 16 + n3 % 10;
        byArray[7] = (byte)n4;
        n3 = (n2 %= 10000) / 100;
        n4 = n3 / 10 * 16 + n3 % 10;
        byArray[8] = (byte)n4;
        n3 = n2 % 100;
        n4 = n3 / 10 * 16 + n3 % 10;
        byArray[9] = (byte)n4;
        return byArray;
    }

    protected static java.sql.Date unpackDate(byte[] byArray) {
        int n2 = 0;
        short s2 = 0;
        short s3 = 0;
        if (byArray == null || byArray.length < 4) {
            return null;
        }
        int n3 = byArray[0];
        int n4 = n3 < 0 ? 256 + n3 : n3;
        n2 = n4 / 16 * 10 + n4 % 16;
        n3 = byArray[1];
        n4 = n3 < 0 ? 256 + n3 : n3;
        n2 = n2 * 100 + n4 / 16 * 10 + n4 % 16;
        n3 = byArray[2];
        n4 = n3 < 0 ? 256 + n3 : n3;
        s2 = (short)(n4 / 16 * 10 + n4 % 16);
        n3 = byArray[3];
        n4 = n3 < 0 ? 256 + n3 : n3;
        s3 = (short)(n4 / 16 * 10 + n4 % 16);
        if (n2 == 0 || s2 == 0 || s3 == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n2, s2 - 1, s3);
        return new java.sql.Date(calendar.getTime().getTime());
    }

    protected static Time unpackTime(byte[] byArray) {
        if (byArray == null || byArray.length < 3) {
            return null;
        }
        int n2 = byArray[0];
        int n3 = n2 < 0 ? 256 + n2 : n2;
        int n4 = n3 / 16 * 10 + n3 % 16;
        n2 = byArray[1];
        n3 = n2 < 0 ? 256 + n2 : n2;
        int n5 = n3 / 16 * 10 + n3 % 16;
        n2 = byArray[2];
        n3 = n2 < 0 ? 256 + n2 : n2;
        int n6 = n3 / 16 * 10 + n3 % 16;
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        return new Time(calendar.getTime().getTime());
    }

    protected static Timestamp unpackTimestamp(byte[] byArray) {
        byte[] byArray2 = new byte[3];
        if (byArray == null || byArray.length < 10) {
            return null;
        }
        java.sql.Date date = Data.unpackDate(byArray);
        if (date == null) {
            return null;
        }
        byArray2[0] = byArray[4];
        byArray2[1] = byArray[5];
        byArray2[2] = byArray[6];
        Time time = Data.unpackTime(byArray2);
        if (time == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(time);
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        int n2 = byArray[7];
        int n3 = n2 < 0 ? 256 + n2 : n2;
        int n4 = n3 / 16 * 10 + n3 % 16;
        n2 = byArray[8];
        n3 = n2 < 0 ? 256 + n2 : n2;
        n4 = n4 * 100 + n3 / 16 * 10 + n3 % 16;
        n2 = byArray[9];
        n3 = n2 < 0 ? 256 + n2 : n2;
        n4 = n4 * 100 + n3 / 16 * 10 + n3 % 16;
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        timestamp.setNanos(n4);
        return timestamp;
    }

    private void setInternalData() throws WrapperException {
        if (this._gotData) {
            return;
        }
        this._gotData = true;
        this.setInternalData(this.getData());
    }

    private void setInternalData(byte[] byArray) throws WrapperException {
        if (byArray == null || byArray.length == 0) {
            this._data = null;
            return;
        }
        short s2 = this.getDataType();
        switch (s2) {
            case 496: {
                this._data = new Integer((int)Data.decodeLong(byArray, 4));
                break;
            }
            case 500: {
                this._data = new Short((short)Data.decodeLong(byArray, 2));
                break;
            }
            case 480: {
                this._data = new Double(Double.longBitsToDouble(Data.decodeLong(byArray, 8)));
                break;
            }
            case 483: {
                this._data = new Float(Float.intBitsToFloat((int)Data.decodeLong(byArray, 4)));
                break;
            }
            case 492: {
                this._data = new Long(Data.decodeLong(byArray, 8));
                break;
            }
            case 448: 
            case 452: {
                if (this.getForBitData()) {
                    this._data = byArray;
                    break;
                }
                this._data = this.trimAt0(Data.decodeUTF8String(byArray));
                break;
            }
            case 484: {
                this._data = new BigDecimal(this.trimAt0(new String(byArray)));
                break;
            }
            case 384: {
                this._data = Data.unpackDate(byArray);
                break;
            }
            case 388: {
                this._data = Data.unpackTime(byArray);
                break;
            }
            case 392: {
                this._data = Data.unpackTimestamp(byArray);
                break;
            }
            default: {
                throw new WrapperException("Data type not specified or not supported (" + s2 + ")");
            }
        }
    }
}

