/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.wrapper;

import com.ibm.db2.wrapper.CatalogInfo;
import com.ibm.db2.wrapper.CatalogOption;
import com.ibm.db2.wrapper.DataBuffer;
import com.ibm.db2.wrapper.MultiValueOption;
import com.ibm.db2.wrapper.OptionValue;
import com.ibm.db2.wrapper.SingleValueOption;
import com.ibm.db2.wrapper.WrapperException;
import java.sql.Timestamp;

public final class CatalogInfoPacker
extends DataBuffer {
    protected CatalogInfoPacker() {
    }

    protected CatalogInfo unpackSVO(byte[] byArray) throws WrapperException {
        return this.unpackSVO(byArray, new CatalogInfo());
    }

    protected CatalogInfo unpackSVO(byte[] byArray, CatalogInfo catalogInfo) throws WrapperException {
        super.setBuffer(byArray);
        while (this.available() > 0) {
            String string = super.getUTF8String();
            int n2 = super.getInt();
            boolean bl = super.getBoolean();
            SingleValueOption singleValueOption = new SingleValueOption(string, super.getUTF8Binary(), n2);
            singleValueOption.setReserved(bl);
            catalogInfo.addOption(singleValueOption);
        }
        return catalogInfo;
    }

    protected CatalogInfo unpackMVO(byte[] byArray) throws WrapperException {
        return this.unpackMVO(byArray, new CatalogInfo());
    }

    protected CatalogInfo unpackMVO(byte[] byArray, CatalogInfo catalogInfo) throws WrapperException {
        super.setBuffer(byArray);
        while (this.available() > 0) {
            String string = super.getUTF8String();
            int n2 = super.getInt();
            boolean bl = super.getBoolean();
            int n3 = super.getInt();
            MultiValueOption multiValueOption = new MultiValueOption(string, n2);
            multiValueOption.setReserved(bl);
            int n4 = 0;
            while (n4 < n3) {
                String string2 = super.getUTF8Binary();
                Timestamp timestamp = super.getTimestamp();
                String string3 = super.getUTF8String();
                multiValueOption.addValue(string2, timestamp, string3, "SERVER", "");
                ++n4;
            }
            catalogInfo.addOption(multiValueOption);
        }
        return catalogInfo;
    }

    protected byte[] pack(CatalogInfo catalogInfo) throws WrapperException {
        block6: {
            if (catalogInfo == null) {
                return null;
            }
            super.resetBuffer();
            CatalogOption catalogOption = catalogInfo.getFirstOption();
            if (catalogOption == null) break block6;
            if (catalogOption instanceof SingleValueOption) {
                while (catalogOption != null) {
                    super.addUTF8String(catalogOption.getName());
                    super.addInt(catalogOption.getAction());
                    super.addBoolean(catalogOption.isReserved());
                    super.addUTF8Binary(catalogOption.getValue());
                    catalogOption = catalogInfo.getNextOption(catalogOption);
                }
            } else {
                MultiValueOption multiValueOption = (MultiValueOption)catalogOption;
                while (multiValueOption != null) {
                    super.addUTF8String(multiValueOption.getName());
                    super.addInt(multiValueOption.getAction());
                    super.addBoolean(multiValueOption.isReserved());
                    super.addInt(multiValueOption.getNumValues());
                    OptionValue optionValue = multiValueOption.getFirstValue();
                    while (optionValue != null) {
                        super.addUTF8Binary(optionValue.getValue());
                        super.addTimestamp(optionValue.getTimestamp());
                        super.addUTF8String(optionValue.getValueID());
                        optionValue = multiValueOption.getNextValue(optionValue);
                    }
                    multiValueOption = (MultiValueOption)catalogInfo.getNextOption(multiValueOption);
                }
            }
        }
        return super.getBuffer();
    }
}

