/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.wrapper;

import com.ibm.db2.wrapper.CatalogOption;
import com.ibm.db2.wrapper.Data;
import com.ibm.db2.wrapper.SingleValueOption;
import com.ibm.db2.wrapper.WrapperException;

public class CatalogInfo {
    private CatalogOption _optChain = null;

    protected CatalogInfo() {
    }

    protected final void insertOption(CatalogOption catalogOption) throws WrapperException {
        if (catalogOption == null) {
            throw new WrapperException("Null option");
        }
        catalogOption.setNextOption(this._optChain);
        if (this._optChain != null) {
            this._optChain.setPrevOption(catalogOption);
        }
        this._optChain = catalogOption;
    }

    protected final void addOption(CatalogOption catalogOption) throws WrapperException {
        if (catalogOption == null) {
            throw new WrapperException("Null option");
        }
        if (this.getOption(catalogOption.getName()) != null) {
            throw new WrapperException(-1884, "addOption", new String[]{catalogOption.getName(), "", ""});
        }
        this.insertOption(catalogOption);
    }

    public void addOption(String string, String string2, int n2, String string3, String string4) throws WrapperException {
        if (this.getOption(string) != null) {
            throw new WrapperException(-1884, "addOption", new String[]{string, string3, string4});
        }
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
            throw new WrapperException("Invalid action (" + n2 + ") for the option " + string + " of type " + string3);
        }
        SingleValueOption singleValueOption = new SingleValueOption(string, string2, n2);
        this.insertOption(singleValueOption);
    }

    public void dropOption(CatalogOption catalogOption) throws WrapperException {
        if (catalogOption == null) {
            throw new WrapperException("Null option");
        }
        CatalogOption catalogOption2 = catalogOption.getPrevOption();
        CatalogOption catalogOption3 = catalogOption.getNextOption();
        if (catalogOption2 != null) {
            catalogOption2.setNextOption(catalogOption3);
        }
        if (catalogOption3 != null) {
            catalogOption3.setPrevOption(catalogOption2);
        }
        if (this._optChain == catalogOption) {
            this._optChain = catalogOption3;
        }
    }

    public final CatalogOption getOption(String string) throws WrapperException {
        if (string == null) {
            throw new WrapperException("Null option name");
        }
        CatalogOption catalogOption = this._optChain;
        while (catalogOption != null) {
            if (string.equalsIgnoreCase(catalogOption.getName())) {
                return catalogOption;
            }
            catalogOption = catalogOption.getNextOption();
        }
        return null;
    }

    public final CatalogOption getFirstOption() {
        return this._optChain;
    }

    public final CatalogOption getNextOption(CatalogOption catalogOption) {
        return catalogOption == null ? null : catalogOption.getNextOption();
    }

    protected final CatalogOption getTimestampOption() throws WrapperException {
        return this.getOption("TIMESTAMP");
    }

    protected final short getDropPendingOption() throws WrapperException {
        CatalogOption catalogOption = this.getOption("DROP_PENDING");
        if (catalogOption == null) {
            return 0;
        }
        return (short)Data.decodeLong(catalogOption.getValue().getBytes(), 2);
    }
}

