/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.conn;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.conn.Context;
import java.sql.SQLException;

public class SQLExecute
implements Runnable {
    public static final int[] CLOSECONNECTIONCODES = new int[]{-30020, -30021, -30030, -30081};
    private Context context;
    private boolean allowScrollableResultSets = false;

    public SQLExecute(Context context, boolean bl) {
        this.context = context;
        this.allowScrollableResultSets = bl;
    }

    public SQLExecute(Context context) {
        this(context, false);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = null;
        if (CommonTrace.isTrace()) {
            var1_1 = CommonTrace.create("common", "SQLExecute", this, "run()");
        }
        var2_2 = false;
        var6_3 = 1003;
        var7_4 = 1007;
        if (this.context.getConnectionInfo() == null) {
            CommonTrace.exit(var1_1);
            return;
        }
        do {
            block25: {
                this.context.setException(null);
                var3_5 = null;
                var4_6 = null;
                var5_7 = null;
                try {
                    var3_5 = this.context.getConnectionInfo().getConnection();
                    var3_5.clearWarnings();
                    if (this.allowScrollableResultSets) {
                        var6_3 = 1005;
                    }
                    var4_6 = var3_5.createStatement(var6_3, var7_4);
                    this.context.setStatement(var4_6);
                    CommonTrace.write(var1_1, "SQL=" + this.context.getSQL());
                    var4_6.execute(this.context.getSQL());
                    var5_7 = var4_6.getResultSet();
                    if (var5_7 == null) continue;
                    this.context.setResultSet(var5_7);
                    continue;
                }
                catch (Exception var8_8) {
                    CommonTrace.catchBlock(var1_1);
                    this.context.setException(var8_8);
                    this.context.setStatement(null);
                    this.context.setResultSet(null);
                    if (!(var8_8 instanceof SQLException)) break block25;
                    var9_14 = ((SQLException)var8_8).getErrorCode();
                    var10_16 = 0;
                    ** while (var10_16 < SQLExecute.CLOSECONNECTIONCODES.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (var9_14 == SQLExecute.CLOSECONNECTIONCODES[var10_16]) {
                        var11_17 = this.context.getConnectionInfo().getPool().closeConnection(var3_5);
                        CommonTrace.write(var1_1, "closed connection because DB2 terminated connection, rc from closeConnection=" + var11_17);
                    }
                    ++var10_16;
                    continue;
                }
            }
            try {
                CommonTrace.write(var1_1, "Exception=" + var8_8.getMessage());
                if (var4_6 != null) {
                    if (var5_7 != null) {
                        var5_7.close();
                    }
                    var4_6.close();
                }
            }
            catch (SQLException var9_15) {
                CommonTrace.catchBlock(var1_1);
                CommonTrace.write(var1_1, "SQLException=" + var9_15.getErrorCode());
            }
            var9_13 = this.context.getRetryable();
            if (var9_13 == null) continue;
            var2_2 = var9_13.retry(this.context);
        } while (var2_2);
        if (this.context.getException() == null) {
            if (var3_5 != null) {
                try {
                    var8_9 = var3_5.getWarnings();
                    while (var8_9 != null) {
                        this.context.addWarning(var8_9.getMessage(), var8_9.getSQLState(), var8_9.getErrorCode());
                        CommonTrace.write(var1_1, "SQLWarning from connection=" + var8_9.getErrorCode());
                        var8_9 = var8_9.getNextWarning();
                    }
                    var3_5.clearWarnings();
                }
                catch (SQLException var8_10) {
                    CommonTrace.catchBlock(var1_1);
                    CommonTrace.write(var1_1, "SQLException from con.getWarnings()=" + var8_10.getErrorCode());
                }
            }
            if (var4_6 != null) {
                try {
                    var8_9 = var4_6.getWarnings();
                    while (var8_9 != null) {
                        this.context.addWarning(var8_9.getMessage(), var8_9.getSQLState(), var8_9.getErrorCode());
                        CommonTrace.write(var1_1, "SQLWarning from statement=" + var8_9.getErrorCode());
                        var8_9 = var8_9.getNextWarning();
                    }
                    var4_6.clearWarnings();
                }
                catch (SQLException var8_11) {
                    CommonTrace.catchBlock(var1_1);
                    CommonTrace.write(var1_1, "SQLException from stmt.getWarnings()=" + var8_11.getErrorCode());
                }
            }
            if (var5_7 != null) {
                try {
                    var8_9 = var5_7.getWarnings();
                    while (var8_9 != null) {
                        this.context.addWarning(var8_9.getMessage(), var8_9.getSQLState(), var8_9.getErrorCode());
                        CommonTrace.write(var1_1, "SQLWarning from resultSet=" + var8_9.getErrorCode());
                        var8_9 = var8_9.getNextWarning();
                    }
                    var5_7.clearWarnings();
                }
                catch (SQLException var8_12) {
                    CommonTrace.catchBlock(var1_1);
                    CommonTrace.write(var1_1, "SQLException from resultSet.getWarnings=" + var8_12.getErrorCode());
                }
            }
        }
        CommonTrace.exit(var1_1);
    }
}

