/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.conn;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.conn.ConnectionOwnerInterface;
import com.ibm.db2.tools.conn.ConnectionPoolManager;
import com.ibm.db2.tools.conn.Context;
import com.ibm.db2.tools.conn.UserInfo;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Properties;

public class DefaultConnectionOwner
implements ConnectionOwnerInterface {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2001, 2002.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";
    protected ConnectionPoolManager connectionPoolManager;
    protected String alias;
    protected UserInfo userInfo;
    protected Authenticator authenticator;
    protected boolean connectIfValidUserid = false;

    public DefaultConnectionOwner() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "DefaultConnectionOwner", this, "DefaultConnectionOwner()");
        }
        CommonTrace.exit(commonTrace);
    }

    public DefaultConnectionOwner(String string, UserInfo userInfo, Authenticator authenticator) {
        this(null, string, userInfo, authenticator);
    }

    public DefaultConnectionOwner(ConnectionPoolManager connectionPoolManager, String string, UserInfo userInfo, Authenticator authenticator) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "DefaultConnectionOwner", this, "DefaultConnectionOwner(ConnectionPoolManager aConnectionPoolManager, String aAlias, UserInfo aUserInfo, Authenticator aAuthenticator)", new Object[]{connectionPoolManager, string, userInfo, authenticator});
        }
        this.setConnectionPoolManager(connectionPoolManager);
        this.setAlias(string);
        this.setUserInfo(userInfo);
        this.setAuthenticator(authenticator);
        CommonTrace.exit(commonTrace);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public boolean getConnectIfValidUserid() {
        return this.connectIfValidUserid;
    }

    public void setConnectIfValidUserid(boolean bl) {
        this.connectIfValidUserid = bl;
    }

    public void connectAuthorizationChanged(Context context, UserInfo userInfo, UserInfo userInfo2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "DefaultConnectionOwner", this, "connectAuthorizationChanged(Context context, UserInfo requestedUserInfo, UserInfo pooledUserInfo)", new Object[]{context, userInfo, userInfo2});
        }
        this.getConnectionPoolManager().freeAllConnections();
        CommonTrace.exit(commonTrace);
    }

    public Connection buildConnection(Context context, UserInfo userInfo, int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "DefaultConnectionOwner", this, "buildConnection(Context context, UserInfo requestedUserInfo, int nodeNumber)", new Object[]{context, userInfo, new Integer(n2)});
        }
        Connection connection = null;
        UserInfo userInfo2 = new UserInfo(new String(userInfo.userid), new String(userInfo.password));
        boolean bl = true;
        boolean bl2 = true;
        while (connection == null && bl2) {
            try {
                boolean bl3;
                String string = "jdbc:db2:" + this.getAlias();
                boolean bl4 = null == userInfo2 || null == userInfo2.getUserid() || userInfo2.getUserid().trim().equals("");
                boolean bl5 = bl3 = this.connectIfValidUserid && bl4 || !bl && (connection == null || context.getSQLException() != null);
                if (bl3 && (userInfo2 = this.getUserInfoFromAuthenticator(context, userInfo2, n2)) == null) {
                    bl2 = false;
                }
                if (!bl2) continue;
                connection = this.poolSupportedConnect(context, userInfo2, string, n2);
                bl = false;
                if (connection == null || context.getSQLException() != null) {
                    bl2 = true;
                    continue;
                }
                userInfo.setUser(userInfo2);
                bl2 = false;
            }
            catch (Throwable throwable) {
                CommonTrace.catchBlock(commonTrace);
                CommonTrace.write(commonTrace, throwable);
            }
        }
        return (Connection)CommonTrace.exit(commonTrace, connection);
    }

    public ConnectionPoolManager getConnectionPoolManager() {
        return this.connectionPoolManager;
    }

    public void setConnectionPoolManager(ConnectionPoolManager connectionPoolManager) {
        this.connectionPoolManager = connectionPoolManager;
    }

    public String getUniqueName() {
        return "PoolManaged-" + this.getAlias();
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        if (this.userInfo == null) {
            this.userInfo = new UserInfo();
        }
        if (!this.userInfo.equals(userInfo)) {
            this.userInfo.setUser(userInfo);
        }
    }

    public String getConnectedName() {
        return this.getAlias();
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "DefaultConnectionOwner", this, "setAuthenticator(Authenticator aAuthenticator)", new Object[]{authenticator});
        }
        if (null == authenticator) {
            CommonTrace.write(commonTrace, "The aAuthenticator parameter cannot be null");
        }
        this.authenticator = authenticator;
        CommonTrace.exit(commonTrace);
    }

    protected synchronized UserInfo getUserInfoFromAuthenticator(Context context, UserInfo userInfo, int n2) {
        Authenticator.setDefault(this.getAuthenticator());
        PasswordAuthentication passwordAuthentication = Authenticator.requestPasswordAuthentication(null, 0, "JNI", null == context.getSQLException() ? "" : context.getSQLException().getMessage(), "");
        UserInfo userInfo2 = UserInfo.getFromPasswordAuthentication(passwordAuthentication);
        return userInfo2;
    }

    private Connection poolSupportedConnect(Context context, UserInfo userInfo, String string, int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "DefaultConnectionOwner", this, "poolSupportedConnect(Context context, UserInfo requestedUserInfo, String url, int nodeNumber)", new Object[]{context, userInfo, string, new Integer(n2)});
        }
        Connection connection = null;
        context.clearWarnings();
        context.setException(null);
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("user", userInfo.getUserid());
            ((Hashtable)properties).put("password", userInfo.getPassword());
            if (n2 != -1) {
                ((Hashtable)properties).put("CONNECTNODE", String.valueOf(n2));
            } else {
                ((Hashtable)properties).put("CONNECTNODE", "SQL_CONN_CATALOG_NODE");
            }
            Class.forName("COM.ibm.db2.jdbc.app.DB2Driver");
            connection = DriverManager.getConnection(string, properties);
            connection.setAutoCommit(true);
            this.setUserInfo(userInfo);
            try {
                SQLWarning sQLWarning = connection.getWarnings();
                while (sQLWarning != null) {
                    context.addWarning(sQLWarning.getMessage(), sQLWarning.getSQLState(), sQLWarning.getErrorCode());
                    sQLWarning = sQLWarning.getNextWarning();
                }
                connection.clearWarnings();
            }
            catch (SQLException sQLException) {
                CommonTrace.catchBlock(commonTrace);
            }
        }
        catch (SQLException sQLException) {
            CommonTrace.catchBlock(commonTrace);
            context.setException(sQLException);
        }
        catch (Exception exception) {
            CommonTrace.catchBlock(commonTrace);
            context.setException(exception);
        }
        return (Connection)CommonTrace.exit(commonTrace, connection);
    }
}

