/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.conn;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.conn.CommonConnectionPoolManager;
import com.ibm.db2.tools.conn.CommonContext;
import com.ibm.db2.tools.conn.ConnectionInfo;
import com.ibm.db2.tools.conn.ConnectionPoolManager;
import com.ibm.db2.tools.conn.Retryable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JFrame;

public class Context
implements CommonContext {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2001, 2002.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";
    private ConnectionInfo conInfo;
    private String[] sql = new String[]{""};
    private Vector exceptions = new Vector();
    private SQLWarning firstWarning;
    private SQLWarning lastWarning;
    private Statement statement;
    private ResultSet resultSet;
    private Retryable retryable = null;
    private Vector messagetext = new Vector();
    private int rc = 0;
    private JFrame dialogParent = null;

    public Context() {
    }

    public Context(Retryable retryable) {
        this.retryable = retryable;
    }

    public boolean shallowCopy(Context context) {
        if (context != null) {
            this.conInfo = context.conInfo;
            this.exceptions = context.exceptions;
            this.firstWarning = context.firstWarning;
            this.lastWarning = context.lastWarning;
            this.dialogParent = context.dialogParent;
            this.messagetext = context.messagetext;
            return true;
        }
        return false;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.conInfo = connectionInfo;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.conInfo;
    }

    public void setSQL(String[] stringArray) {
        this.sql = stringArray;
    }

    public void setSQL(Vector vector) {
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        this.sql = stringArray;
    }

    public void setSQL(String string) {
        this.sql[0] = string;
    }

    public String getSQL(int n2) {
        return this.sql[n2];
    }

    public int getSQLlen() {
        return this.sql.length;
    }

    public String getSQL() {
        return this.sql[0];
    }

    public void setException(Exception exception) {
        this.exceptions.removeAllElements();
        if (exception != null) {
            this.exceptions.addElement(exception);
        }
    }

    public Exception getException() {
        Exception exception = null;
        if (this.exceptions.size() > 0) {
            exception = (Exception)this.exceptions.elementAt(0);
        }
        return exception;
    }

    public Vector getExceptions() {
        return this.exceptions;
    }

    public SQLException getSQLException() {
        if (this.getException() != null && this.getException() instanceof SQLException) {
            return (SQLException)this.getException();
        }
        return null;
    }

    public void addWarning(String string, String string2, int n2) {
        SQLWarning sQLWarning = string == null ? new SQLWarning() : (string2 == null ? new SQLWarning(string) : new SQLWarning(string, string2, n2));
        if (this.firstWarning == null) {
            this.firstWarning = sQLWarning;
            this.lastWarning = sQLWarning;
        } else {
            this.lastWarning.setNextWarning(sQLWarning);
            this.lastWarning = sQLWarning;
        }
    }

    public SQLWarning getWarnings() {
        return this.firstWarning;
    }

    public void clearWarnings() {
        this.firstWarning = null;
        this.lastWarning = null;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setRetryable(Retryable retryable) {
        this.retryable = retryable;
    }

    public Retryable getRetryable() {
        return this.retryable;
    }

    public void setMessageText(Vector vector) {
        this.messagetext = vector;
    }

    public Vector getMessageText() {
        return this.messagetext;
    }

    public void setRC(int n2) {
        this.rc = n2;
    }

    public int getRC() {
        return this.rc;
    }

    public void setDialogParent(JFrame jFrame) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "Context", this, "setDialogParent(JFrame frame)", new Object[]{jFrame});
        }
        if (jFrame != null) {
            CommonTrace.write(commonTrace, jFrame.getTitle());
        }
        this.dialogParent = jFrame;
        CommonTrace.exit(commonTrace);
    }

    public JFrame getDialogParent() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "Context", this, "getDialogParent()");
        }
        if (this.dialogParent != null) {
            CommonTrace.write(commonTrace, this.dialogParent.getTitle());
        }
        return (JFrame)CommonTrace.exit(commonTrace, this.dialogParent);
    }

    public Vector getErrorMsg() {
        String string = null;
        Vector<String> vector = new Vector<String>();
        int n2 = this.exceptions.size();
        int n3 = 0;
        while (n3 < n2) {
            Exception exception = (Exception)this.exceptions.elementAt(n3);
            if (exception != null) {
                string = exception.getLocalizedMessage();
                if (string == null) {
                    string = exception.toString();
                }
                vector.addElement(string);
            }
            ++n3;
        }
        return vector;
    }

    public Vector getWarningMsg() {
        String string = null;
        Vector<String> vector = new Vector<String>();
        SQLWarning sQLWarning = this.firstWarning;
        while (sQLWarning != null) {
            string = sQLWarning.getLocalizedMessage();
            if (string == null) {
                string = sQLWarning.toString();
            }
            vector.addElement(string);
            sQLWarning = sQLWarning.getNextWarning();
        }
        return vector;
    }

    public boolean hasMessages() {
        return this.messagetext != null && this.messagetext.size() > 0;
    }

    public boolean apiError() {
        return this.hasMessages() || this.getSQLException() != null;
    }

    public boolean apiOk() {
        return !this.apiError();
    }

    public boolean hasError() {
        return this.exceptions.size() > 0;
    }

    public boolean hasWarning() {
        return this.firstWarning != null;
    }

    public boolean hasAnyMessage() {
        return this.exceptions.size() > 0 || this.firstWarning != null || this.hasMessages();
    }

    public CommonConnectionPoolManager MGetConnectionPoolManager(String string) {
        ConnectionPoolManager connectionPoolManager = ConnectionPoolManager.MGetConnectionPoolManager(string);
        return connectionPoolManager;
    }

    public String toString() {
        String string = "Context - SQL: ";
        int n2 = this.sql.length;
        int n3 = 0;
        while (n3 < n2) {
            string = string + "   " + this.sql[n3];
            ++n3;
        }
        int n4 = this.exceptions.size();
        if (n4 > 0) {
            string = string + "\nNumber of exceptions = " + n4 + "\n";
        }
        int n5 = 0;
        while (n5 < n4) {
            Exception exception = (Exception)this.exceptions.elementAt(n5);
            string = string + exception.toString() + "\n";
            ++n5;
        }
        return string;
    }

    public void addContext(CommonContext commonContext) {
        int n2;
        Context context = (Context)commonContext;
        if (context.sql.length > 0) {
            String[] stringArray = this.sql;
            String[] stringArray2 = context.sql;
            this.sql = new String[stringArray.length + context.sql.length];
            int n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                this.sql[n2] = stringArray[n2];
                ++n2;
            }
            int n4 = context.sql.length;
            n2 = 0;
            while (n2 < n4) {
                this.sql[n2 + n3] = stringArray2[n2];
                ++n2;
            }
        }
        int n5 = context.exceptions.size();
        n2 = 0;
        while (n2 < n5) {
            this.exceptions.addElement(context.exceptions.elementAt(n2));
            ++n2;
        }
        if (context.messagetext != null) {
            n5 = context.messagetext.size();
            n2 = 0;
            while (n2 < n5) {
                this.messagetext.addElement(context.messagetext.elementAt(n2));
                ++n2;
            }
        }
        if (context.firstWarning != null) {
            if (this.firstWarning == null) {
                this.firstWarning = context.firstWarning;
            } else {
                this.lastWarning.setNextWarning(context.firstWarning);
            }
            this.lastWarning = context.lastWarning;
        }
    }

    public void setNextContext(CommonContext commonContext) {
    }

    public CommonContext getNextContext() {
        return null;
    }
}

