/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.conn;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.conn.ConnectionPoolManager;
import java.util.Observable;

public class ConnectionWatchdog
extends Observable
implements Runnable {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2001, 2002.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";
    private static ConnectionWatchdog singleInstance = null;
    private static Thread singleInstanceThread = null;
    private long maxConnectionIdleTime = 0L;
    private boolean stop = false;

    private ConnectionWatchdog(long l2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionWatchdog", this, "ConnectionWatchdog(long maxConnectionIdleTime)", new Object[]{new Long(l2)});
        }
        if (singleInstance == null) {
            singleInstance = this;
            this.maxConnectionIdleTime = l2;
            singleInstanceThread = new Thread((Runnable)this, "ConnectionWatchdog_Service");
            singleInstanceThread.start();
        }
        CommonTrace.exit(commonTrace);
    }

    public static void sitUp(long l2) {
        if (singleInstance == null) {
            new ConnectionWatchdog(l2);
        }
    }

    public synchronized void run() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionWatchdog", this, "run()");
        }
        long l2 = 1L;
        if (0L != this.maxConnectionIdleTime) {
            l2 = Math.min(1L, this.maxConnectionIdleTime / 2L);
        }
        try {
            while (!this.stop) {
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    CommonTrace.catchBlock(commonTrace);
                    CommonTrace.exit(commonTrace);
                    return;
                }
                if (this.stop) {
                    CommonTrace.exit(commonTrace);
                    return;
                }
                ConnectionPoolManager.retrieveConnections(this.maxConnectionIdleTime);
            }
        }
        catch (Exception exception) {
            CommonTrace.catchBlock(commonTrace);
            exception.printStackTrace();
        }
        CommonTrace.exit(commonTrace);
    }

    public static void stop() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionWatchdog", "stop()");
        }
        if (singleInstance != null) {
            ConnectionWatchdog.singleInstance.stop = true;
        }
        if (singleInstanceThread != null) {
            try {
                singleInstanceThread.interrupt();
            }
            catch (Exception exception) {
                CommonTrace.catchBlock(commonTrace);
            }
        }
        singleInstanceThread = null;
        singleInstance = null;
        CommonTrace.exit(commonTrace);
    }
}

