/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.conn;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.conn.CommonConnectionPoolManager;
import com.ibm.db2.tools.conn.CommonContext;
import com.ibm.db2.tools.conn.ConnectionBuilderThread;
import com.ibm.db2.tools.conn.ConnectionInfo;
import com.ibm.db2.tools.conn.ConnectionOwnerInterface;
import com.ibm.db2.tools.conn.ConnectionPoolManagerEvent;
import com.ibm.db2.tools.conn.ConnectionPoolManagerListener;
import com.ibm.db2.tools.conn.Context;
import com.ibm.db2.tools.conn.DefaultConnectionOwner;
import com.ibm.db2.tools.conn.UserInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.event.EventListenerList;

public class ConnectionPoolManager
implements CommonConnectionPoolManager {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2001, 2002.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";
    private static final String DB2_APP_CONNECTION = "COM.ibm.db2.jdbc.app.DB2Connection";
    private static final String DB2_NET_CONNECTION = "COM.ibm.db2.jdbc.net.DB2Connection";
    private static final String ADMIN_CONNECTION = "com.ibm.db2.tools.shared.jdbc_ext.AdminConnection";
    public static int DQP_DISABLE_FLAG = 1;
    public static int DQP_ENABLE_FLAG = 2;
    public static int DQP_BYPASS_FLAG = 3;
    private static Hashtable managerPool = new Hashtable();
    private static Object getManagerMonitor = new Object();
    private static final int DEFAULT_POOL_SIZE = 1;
    private static int defaultPoolSize = 1;
    private static String eventThread = "AWT-EventQueue";
    protected static EventListenerList globalListenerList = new EventListenerList();
    private Hashtable conPool = new Hashtable();
    private Object getConnectMonitor = new Object();
    private int maxIdleConnections = ConnectionPoolManager.getDefaultPoolSize();
    private ConnectionOwnerInterface connectionOwner = null;
    private static ConnectionBuilderThread connBuilder = new ConnectionBuilderThread();
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener;

    public static void setDefaultPoolSize(int n2) {
        defaultPoolSize = n2;
    }

    public static int getDefaultPoolSize() {
        return defaultPoolSize;
    }

    public static ConnectionPoolManager MGetConnectionPoolManager(ConnectionOwnerInterface connectionOwnerInterface) {
        return ConnectionPoolManager.MGetConnectionPoolManager(connectionOwnerInterface, ConnectionPoolManager.getDefaultPoolSize());
    }

    public static ConnectionPoolManager MGetConnectionPoolManager(ConnectionOwnerInterface connectionOwnerInterface, int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "MGetConnectionPoolManager( ConnectionOwnerInterface owner, int poolSize)", new Object[]{connectionOwnerInterface, new Integer(n2)});
        }
        ConnectionPoolManager connectionPoolManager = null;
        Object object = getManagerMonitor;
        synchronized (object) {
            connectionPoolManager = (ConnectionPoolManager)managerPool.get(connectionOwnerInterface.getUniqueName());
            if (connectionPoolManager == null) {
                connectionPoolManager = new ConnectionPoolManager(connectionOwnerInterface, n2);
                Object[] objectArray = globalListenerList.getListenerList();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if ((class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener == null ? ConnectionPoolManager.class$("com.ibm.db2.tools.conn.ConnectionPoolManagerListener") : class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener) == objectArray[n3]) {
                        connectionPoolManager.addConnectionPoolManagerListener((ConnectionPoolManagerListener)objectArray[n3 + 1]);
                    }
                    n3 += 2;
                }
                managerPool.put(connectionOwnerInterface.getUniqueName(), connectionPoolManager);
            } else if (connectionOwnerInterface != connectionPoolManager.getConnectionOwner()) {
                connectionPoolManager.setConnectionOwner(connectionOwnerInterface);
            }
        }
        return (ConnectionPoolManager)CommonTrace.exit(commonTrace, connectionPoolManager);
    }

    public static ConnectionPoolManager MGetConnectionPoolManager(String string) {
        return ConnectionPoolManager.MGetConnectionPoolManager(string, new UserInfo(), ConnectionPoolManager.getDefaultPoolSize());
    }

    public static ConnectionPoolManager MGetConnectionPoolManager(String string, UserInfo userInfo) {
        return ConnectionPoolManager.MGetConnectionPoolManager(string, userInfo, ConnectionPoolManager.getDefaultPoolSize());
    }

    public static ConnectionPoolManager MGetConnectionPoolManager(String string, int n2) {
        return ConnectionPoolManager.MGetConnectionPoolManager(string, new UserInfo(), n2);
    }

    public static ConnectionPoolManager MGetConnectionPoolManager(String string, UserInfo userInfo, int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "MGetConnectionPoolManager( String alias, UserInfo userInfo, int poolSize)", new Object[]{string, userInfo, new Integer(n2)});
        }
        ConnectionPoolManager connectionPoolManager = null;
        Object object = getManagerMonitor;
        synchronized (object) {
            if (string != null) {
                connectionPoolManager = (ConnectionPoolManager)managerPool.get(string);
                if (connectionPoolManager == null) {
                    try {
                        DefaultConnectionOwner defaultConnectionOwner = (DefaultConnectionOwner)Class.forName("common.CommonConnectionOwner").newInstance();
                        defaultConnectionOwner.setAlias(string);
                        defaultConnectionOwner.setUserInfo(userInfo);
                        connectionPoolManager = new ConnectionPoolManager(defaultConnectionOwner, n2);
                        Object[] objectArray = globalListenerList.getListenerList();
                        int n3 = 0;
                        while (n3 < objectArray.length) {
                            if ((class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener == null ? ConnectionPoolManager.class$("com.ibm.db2.tools.conn.ConnectionPoolManagerListener") : class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener) == objectArray[n3]) {
                                connectionPoolManager.addConnectionPoolManagerListener((ConnectionPoolManagerListener)objectArray[n3 + 1]);
                            }
                            n3 += 2;
                        }
                    }
                    catch (Throwable throwable) {
                        CommonTrace.catchBlock(commonTrace);
                        CommonTrace.write(commonTrace, throwable);
                        CommonTrace.write(commonTrace, "Cannot load common.CommonConnectionOwner.Make sure the class is in the CLASSPATH");
                    }
                }
                managerPool.put(string, connectionPoolManager);
            }
        }
        return (ConnectionPoolManager)CommonTrace.exit(commonTrace, connectionPoolManager);
    }

    public static void addGlobalConnectionPoolManagerListener(ConnectionPoolManagerListener connectionPoolManagerListener) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "addGlobalConnectionPoolManagerListener(ConnectionPoolManagerListener l)", new Object[]{connectionPoolManagerListener});
        }
        globalListenerList.add(class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener == null ? (class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener = ConnectionPoolManager.class$("com.ibm.db2.tools.conn.ConnectionPoolManagerListener")) : class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener, connectionPoolManagerListener);
        Enumeration enumeration = managerPool.elements();
        while (enumeration.hasMoreElements()) {
            ((ConnectionPoolManager)enumeration.nextElement()).addConnectionPoolManagerListener(connectionPoolManagerListener);
        }
        CommonTrace.exit(commonTrace);
    }

    public static void removeGlobalConnectionPoolManagerListener(ConnectionPoolManagerListener connectionPoolManagerListener) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "removeGlobalConnectionPoolManagerListener(ConnectionPoolManagerListener l)", new Object[]{connectionPoolManagerListener});
        }
        globalListenerList.remove(class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener == null ? (class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener = ConnectionPoolManager.class$("com.ibm.db2.tools.conn.ConnectionPoolManagerListener")) : class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener, connectionPoolManagerListener);
        Enumeration enumeration = managerPool.elements();
        while (enumeration.hasMoreElements()) {
            ((ConnectionPoolManager)enumeration.nextElement()).removeConnectionPoolManagerListener(connectionPoolManagerListener);
        }
        CommonTrace.exit(commonTrace);
    }

    private ConnectionPoolManager(ConnectionOwnerInterface connectionOwnerInterface, int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "ConnectionPoolManager( ConnectionOwnerInterface connectionOwner, int poolSize)", new Object[]{connectionOwnerInterface, new Integer(n2)});
        }
        connectionOwnerInterface.setConnectionPoolManager(this);
        this.connectionOwner = connectionOwnerInterface;
        this.maxIdleConnections = n2;
        this.commsCheck();
        CommonTrace.exit(commonTrace);
    }

    public CommonContext testConnection(UserInfo userInfo) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", this, "testConnection(UserInfo requestedUserInfo)", new Object[]{userInfo});
        }
        Context context = new Context();
        this.getConnection(context, userInfo);
        return (CommonContext)CommonTrace.exit(commonTrace, context);
    }

    public Hashtable getConPool() {
        return this.conPool;
    }

    public ConnectionOwnerInterface getConnectionOwner() {
        return this.connectionOwner;
    }

    public void setConnectionOwner(ConnectionOwnerInterface connectionOwnerInterface) {
        this.connectionOwner = connectionOwnerInterface;
    }

    public UserInfo getUserInfo() {
        return this.getConnectionOwner().getUserInfo();
    }

    public void setUserInfo(UserInfo userInfo) {
        if (userInfo == null) {
            userInfo = new UserInfo();
        }
        if (null != this.getConnectionOwner() && !this.getConnectionOwner().getUserInfo().equals(userInfo)) {
            this.getConnectionOwner().getUserInfo().setUser(userInfo);
        }
    }

    public int getConnectionCount() {
        return this.conPool.size();
    }

    public Connection getConnection(Context context) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", this, "getConnection(Context context)", new Object[]{context});
        }
        Connection connection = null;
        UserInfo userInfo = new UserInfo();
        userInfo = this.connectionOwner.getUserInfo();
        connection = this.getConnection(context, userInfo, -1);
        this.connectionOwner.setUserInfo(userInfo);
        return (Connection)CommonTrace.exit(commonTrace, connection);
    }

    public Connection getConnection(Context context, UserInfo userInfo) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", this, "getConnection(Context context, UserInfo requestedUserInfo)", new Object[]{context, userInfo});
        }
        Connection connection = this.getConnection(context, userInfo, -1);
        return (Connection)CommonTrace.exit(commonTrace, connection);
    }

    public Connection getConnection(Context context, UserInfo userInfo, int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", this, "getConnection(Context context, UserInfo requestedUserInfo, int nodeNumber)", new Object[]{context, userInfo, new Integer(n2)});
        }
        return (Connection)CommonTrace.exit(commonTrace, this.getConnection(context, userInfo, n2, true));
    }

    public Connection getConnection(Context context, UserInfo userInfo, int n2, boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", this, "getConnection(Context context, UserInfo requestedUserInfo, int nodeNumber)", new Object[]{context, userInfo, new Integer(n2), new Boolean(bl)});
        }
        Connection connection = null;
        Enumeration enumeration = null;
        context.setException(null);
        context.clearWarnings();
        ConnectionInfo connectionInfo = null;
        Object object = this.getConnectMonitor;
        synchronized (object) {
            Object object2;
            enumeration = this.conPool.elements();
            while (enumeration.hasMoreElements() && connectionInfo == null) {
                object2 = (ConnectionInfo)enumeration.nextElement();
                if (!((ConnectionInfo)object2).isIdle() || ((ConnectionInfo)object2).getNodeNumber() != n2 || !((ConnectionInfo)object2).getUserInfo().equals(userInfo)) continue;
                connectionInfo = object2;
            }
            if (connectionInfo != null) {
                connectionInfo.setBusy();
                connection = connectionInfo.getConnection();
                context.setConnectionInfo(connectionInfo);
                if (connection.getClass().getName().equals(ADMIN_CONNECTION)) {
                    try {
                        object2 = connection.getClass().getMethod("openConnection", null);
                        ((Method)object2).invoke((Object)connection, null);
                    }
                    catch (Exception exception) {
                        connectionInfo.setIdle();
                        context.setException(exception);
                        CommonTrace.catchBlock(commonTrace);
                    }
                    catch (Throwable throwable) {
                        CommonTrace.catchBlock(commonTrace);
                    }
                }
            }
            if (connectionInfo == null && bl && (connection = System.getProperty("os.name").equals("Linux") && -1 == Thread.currentThread().getName().indexOf(eventThread) ? connBuilder.buildConnection(this.connectionOwner, context, userInfo, n2) : this.connectionOwner.buildConnection(context, userInfo, n2)) != null) {
                Object object3;
                Object object4;
                if (connection.getClass().getName().equals(DB2_APP_CONNECTION) || connection.getClass().getName().equals(DB2_NET_CONNECTION)) {
                    try {
                        object2 = new Class[]{Integer.TYPE};
                        object4 = connection.getClass().getMethod("setDQPFlag", (Class<?>)object2);
                        object3 = new Object[]{new Integer(DQP_BYPASS_FLAG)};
                        object4.invoke((Object)connection, (Object[])object3);
                    }
                    catch (Throwable throwable) {
                        CommonTrace.catchBlock(commonTrace);
                        CommonTrace.write(commonTrace, throwable);
                    }
                }
                object2 = new ConnectionInfo(connection, userInfo, n2, this);
                ((ConnectionInfo)object2).setBusy();
                context.setConnectionInfo((ConnectionInfo)object2);
                if (connection.getClass().getName().equals(ADMIN_CONNECTION)) {
                    try {
                        object4 = new Class[]{object2.getClass()};
                        object3 = connection.getClass().getMethod("setConnectionInfo", (Class<?>)object4);
                        Object[] objectArray = new Object[]{object2};
                        ((Method)object3).invoke((Object)connection, objectArray);
                    }
                    catch (Throwable throwable) {
                        CommonTrace.catchBlock(commonTrace);
                        CommonTrace.write(commonTrace, throwable);
                    }
                }
                object4 = null;
                enumeration = this.conPool.elements();
                while (enumeration.hasMoreElements() && object4 == null) {
                    object3 = (ConnectionInfo)enumeration.nextElement();
                    if (((ConnectionInfo)object3).isInvalid() || ((ConnectionInfo)object3).getUserInfo().equals(userInfo)) continue;
                    object4 = object3;
                }
                if (object4 != null) {
                    this.connectionOwner.connectAuthorizationChanged(context, userInfo, object4.getUserInfo());
                }
                this.conPool.put(connection, object2);
                this.fireConnectionCreated((ConnectionInfo)object2);
            }
        }
        return (Connection)CommonTrace.exit(commonTrace, connection);
    }

    public Connection rebuildConnection(Context context, ConnectionInfo connectionInfo) {
        return this.getConnection(context, connectionInfo.getUserInfo(), connectionInfo.getNodeNumber());
    }

    /*
     * Unable to fully structure code
     */
    public boolean freeConnection(Connection var1_1) {
        block28: {
            var2_2 = null;
            if (CommonTrace.isTrace()) {
                var2_2 = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", this, "freeConnection(Connection connection)", new Object[]{var1_1});
            }
            var3_3 = true;
            if (var1_1 == null) break block28;
            var4_4 = this.getConnectMonitor;
            synchronized (var4_4) {
                block27: {
                    var5_5 = (ConnectionInfo)this.conPool.get(var1_1);
                    try {
                        if (var5_5 != null) {
                            if (var5_5.getReplacementConnectionInfo() != null) {
                                this.freeConnection(var5_5.getReplacementConnectionInfo().getConnection());
                                var5_5.setReplacementConnectionInfo(null);
                            }
                            if (var5_5.isInvalid()) {
                                this.conPool.remove(var1_1);
                                if (!var1_1.getAutoCommit()) {
                                    try {
                                        var1_1.rollback();
                                    }
                                    catch (SQLException var6_6) {
                                        CommonTrace.catchBlock(var2_2);
                                        CommonTrace.write(var2_2, var6_6);
                                    }
                                }
                                var1_1.close();
                                break block27;
                            }
                            if (!var5_5.isBusy()) break block27;
                            if (this.getIdleConnectionCount() >= this.maxIdleConnections) {
                                this.conPool.remove(var1_1);
                                if (!var1_1.getAutoCommit()) {
                                    try {
                                        var1_1.rollback();
                                    }
                                    catch (SQLException var6_7) {
                                        CommonTrace.catchBlock(var2_2);
                                        CommonTrace.write(var2_2, var6_7);
                                    }
                                }
                                var1_1.close();
                                break block27;
                            }
                            var1_1.clearWarnings();
                            var1_1.setAutoCommit(true);
                            var5_5.setIdle();
                            break block27;
                        }
                        var3_3 = false;
                    }
                    catch (SQLException var6_8) {
                        var7_9 = var5_5.getNodeNumber();
                        var8_11 = var5_5.getUserInfo();
                        var9_12 = this.conPool.elements();
                        ** while (var9_12.hasMoreElements())
                    }
lbl-1000:
                    // 1 sources

                    {
                        var10_13 = (ConnectionInfo)var9_12.nextElement();
                        if (!var10_13.isIdle() || var10_13.getNodeNumber() != var7_9 || !var10_13.getUserInfo().equals(var8_11)) continue;
                        var11_14 = var10_13.getConnection();
                        var12_15 = true;
                        if (var1_1.getClass().getName().equals("COM.ibm.db2.jdbc.app.DB2Connection") || var1_1.getClass().getName().equals("COM.ibm.db2.jdbc.net.DB2Connection")) {
                            try {
                                var13_16 = new Class[]{};
                                var14_20 = var1_1.getClass().getMethod("pingDB2", var13_16);
                                var15_22 = new Object[]{};
                                var12_15 = (Boolean)var14_20.invoke((Object)var1_1, var15_22);
                            }
                            catch (Throwable var13_17) {
                                CommonTrace.catchBlock(var2_2);
                                CommonTrace.write(var2_2, var6_8);
                            }
                        }
                        if (var12_15) continue;
                        this.conPool.remove(var11_14);
                        try {
                            if (!var11_14.getAutoCommit()) {
                                try {
                                    var11_14.rollback();
                                }
                                catch (SQLException var13_18) {
                                    CommonTrace.catchBlock(var2_2);
                                    CommonTrace.write(var2_2, var13_18);
                                }
                            }
                            var11_14.close();
                        }
                        catch (SQLException var13_19) {
                            CommonTrace.catchBlock(var2_2);
                            CommonTrace.write(var2_2, var13_19);
                        }
                        catch (Exception var14_21) {
                            CommonTrace.catchBlock(var2_2);
                            CommonTrace.write(var2_2, var14_21);
                        }
                        continue;
                    }
lbl87:
                    // 1 sources

                    CommonTrace.catchBlock(var2_2);
                    CommonTrace.write(var2_2, var6_8);
                    this.conPool.remove(var1_1);
                    break block27;
                    catch (Exception var7_10) {
                        CommonTrace.catchBlock(var2_2);
                        CommonTrace.write(var2_2, var7_10);
                        var3_3 = false;
                    }
                }
            }
        }
        var3_3 = false;
        return CommonTrace.exit(var2_2, var3_3);
    }

    public boolean closeConnection(Connection connection) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "public boolean closeConnection (Connection con)", new Object[]{connection});
        }
        if (connection == null) {
            return false;
        }
        Object object = this.getConnectMonitor;
        synchronized (object) {
            try {
                ConnectionInfo connectionInfo = (ConnectionInfo)this.conPool.get(connection);
                if (connectionInfo == null) {
                    boolean bl = false;
                    return bl;
                }
                this.conPool.remove(connection);
                if (!connection.getAutoCommit()) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        CommonTrace.catchBlock(commonTrace);
                        CommonTrace.write(commonTrace, sQLException);
                    }
                }
                connection.close();
            }
            catch (SQLException sQLException) {
                CommonTrace.catchBlock(commonTrace);
                CommonTrace.write(commonTrace, sQLException);
                boolean bl = false;
                return bl;
            }
        }
        return CommonTrace.exit(commonTrace, true);
    }

    public boolean connectionsBusy() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "public boolean connectionsBusy()");
        }
        boolean bl = false;
        Object object = this.getConnectMonitor;
        synchronized (object) {
            Enumeration enumeration = this.conPool.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionInfo connectionInfo = (ConnectionInfo)enumeration.nextElement();
                if (!connectionInfo.isBusy()) continue;
                bl = true;
                break;
            }
        }
        return CommonTrace.exit(commonTrace, bl);
    }

    public boolean hasConnection(UserInfo userInfo, int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "public boolean hasConnection(UserInfo requestedUserInfo, int nodeNumber)", new Object[]{userInfo, new Integer(n2)});
        }
        Hashtable hashtable = this.conPool;
        synchronized (hashtable) {
            Iterator iterator = this.conPool.values().iterator();
            while (iterator.hasNext()) {
                ConnectionInfo connectionInfo = (ConnectionInfo)iterator.next();
                if (connectionInfo.getNodeNumber() != n2 || !connectionInfo.getUserInfo().equals(userInfo)) continue;
                boolean bl = CommonTrace.exit(commonTrace, true);
                return bl;
            }
            boolean bl = CommonTrace.exit(commonTrace, false);
            return bl;
        }
    }

    public boolean freeAllConnections() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "public boolean freeAllConnections()");
        }
        boolean bl = true;
        Object object = this.getConnectMonitor;
        synchronized (object) {
            Object object2;
            Object object3;
            Enumeration enumeration = this.conPool.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (ConnectionInfo)enumeration.nextElement();
                if (((ConnectionInfo)object3).isIdle()) {
                    object2 = ((ConnectionInfo)object3).getConnection();
                    this.conPool.remove(object2);
                    try {
                        if (!object2.getAutoCommit()) {
                            try {
                                object2.rollback();
                            }
                            catch (SQLException sQLException) {
                                CommonTrace.catchBlock(commonTrace);
                                CommonTrace.write(commonTrace, sQLException);
                            }
                        }
                        object2.close();
                    }
                    catch (SQLException sQLException) {
                        CommonTrace.catchBlock(commonTrace);
                        CommonTrace.write(commonTrace, sQLException);
                        bl = false;
                    }
                    continue;
                }
                if (!((ConnectionInfo)object3).isBusy()) continue;
                ((ConnectionInfo)object3).setInvalid();
            }
            object3 = managerPool.elements();
            while (object3.hasMoreElements()) {
                object2 = (ConnectionPoolManager)object3.nextElement();
                if (((ConnectionPoolManager)object2).connectionOwner == this.connectionOwner || !((ConnectionPoolManager)object2).connectionOwner.getUniqueName().equals(this.connectionOwner.getUniqueName())) continue;
                enumeration = ((ConnectionPoolManager)object2).conPool.elements();
                while (enumeration.hasMoreElements()) {
                    ConnectionInfo connectionInfo = (ConnectionInfo)enumeration.nextElement();
                    if (connectionInfo.isIdle()) {
                        Connection connection = connectionInfo.getConnection();
                        ((ConnectionPoolManager)object2).conPool.remove(connection);
                        try {
                            if (!connection.getAutoCommit()) {
                                try {
                                    connection.rollback();
                                }
                                catch (SQLException sQLException) {
                                    CommonTrace.catchBlock(commonTrace);
                                    CommonTrace.write(commonTrace, sQLException);
                                }
                            }
                            connection.close();
                        }
                        catch (SQLException sQLException) {
                            CommonTrace.catchBlock(commonTrace);
                            CommonTrace.write(commonTrace, sQLException);
                            bl = false;
                        }
                        continue;
                    }
                    if (!connectionInfo.isBusy()) continue;
                    connectionInfo.setInvalid();
                }
            }
        }
        return CommonTrace.exit(commonTrace, bl);
    }

    public boolean closeAllConnections() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "public boolean closeAllConnections()");
        }
        boolean bl = true;
        Object object = this.getConnectMonitor;
        synchronized (object) {
            Enumeration enumeration = this.conPool.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionInfo connectionInfo = (ConnectionInfo)enumeration.nextElement();
                Connection connection = connectionInfo.getConnection();
                this.conPool.remove(connection);
                try {
                    if (!connection.getAutoCommit()) {
                        try {
                            connection.rollback();
                        }
                        catch (SQLException sQLException) {
                            CommonTrace.catchBlock(commonTrace);
                            CommonTrace.write(commonTrace, sQLException);
                        }
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {
                    CommonTrace.catchBlock(commonTrace);
                    CommonTrace.write(commonTrace, sQLException);
                    bl = false;
                }
            }
        }
        return CommonTrace.exit(commonTrace, bl);
    }

    public static boolean MCloseAllConnections() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "MCloseAllConnections()");
        }
        boolean bl = true;
        Object object = getManagerMonitor;
        synchronized (object) {
            Enumeration enumeration = managerPool.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionPoolManager connectionPoolManager = (ConnectionPoolManager)enumeration.nextElement();
                if (connectionPoolManager.closeAllConnections()) continue;
                bl = false;
            }
        }
        return CommonTrace.exit(commonTrace, bl);
    }

    public static Enumeration pools() {
        return managerPool.elements();
    }

    protected static void retrieveConnections(long l2) {
        Object object = getManagerMonitor;
        synchronized (object) {
            Enumeration enumeration = ConnectionPoolManager.pools();
            while (enumeration.hasMoreElements()) {
                ConnectionPoolManager connectionPoolManager = (ConnectionPoolManager)enumeration.nextElement();
                Object object2 = connectionPoolManager.getConnectMonitor;
                synchronized (object2) {
                    Enumeration enumeration2 = connectionPoolManager.conPool.elements();
                    while (enumeration2.hasMoreElements()) {
                        ConnectionInfo connectionInfo = (ConnectionInfo)enumeration2.nextElement();
                        if (!connectionInfo.expired(l2)) continue;
                        connectionInfo.setInvalid();
                        connectionPoolManager.freeConnection(connectionInfo.getConnection());
                    }
                }
            }
        }
    }

    public static void setConnectOption(Connection connection, int n2, int n3) throws SQLException {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "setConnectOption(Connection connection, int option, int value)", new Object[]{connection, new Integer(n2), new Integer(n3)});
        }
        if (connection.getClass().getName().equals(DB2_APP_CONNECTION) || connection.getClass().getName().equals(DB2_NET_CONNECTION)) {
            try {
                Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
                Method method = connection.getClass().getMethod("setConnectOption", classArray);
                Object[] objectArray = new Object[]{new Integer(n2), new Integer(n3)};
                method.invoke((Object)connection, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                CommonTrace.catchBlock(commonTrace);
                CommonTrace.write(commonTrace, noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                CommonTrace.catchBlock(commonTrace);
                CommonTrace.write(commonTrace, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                CommonTrace.catchBlock(commonTrace);
                CommonTrace.write(commonTrace, invocationTargetException);
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public static void setConnectOption(Connection connection, int n2, String string) throws SQLException {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "setConnectOption(Connection connection, int option, String value)", new Object[]{connection, new Integer(n2), string});
        }
        Class<?> clazz = connection.getClass();
        if (connection.getClass().getName().equals(DB2_APP_CONNECTION) || connection.getClass().getName().equals(DB2_NET_CONNECTION)) {
            try {
                Class[] classArray = new Class[]{Integer.TYPE, new String().getClass()};
                Method method = clazz.getMethod("setConnectOption", classArray);
                Object[] objectArray = new Object[]{new Integer(n2), string};
                method.invoke((Object)connection, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                CommonTrace.catchBlock(commonTrace);
                CommonTrace.write(commonTrace, noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                CommonTrace.catchBlock(commonTrace);
                CommonTrace.write(commonTrace, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                CommonTrace.catchBlock(commonTrace);
                CommonTrace.write(commonTrace, invocationTargetException);
            }
        }
        CommonTrace.exit(commonTrace);
    }

    private void commsCheck() {
    }

    private int getIdleConnectionCount() {
        int n2 = 0;
        Object object = this.getConnectMonitor;
        synchronized (object) {
            Enumeration enumeration = this.conPool.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionInfo connectionInfo = (ConnectionInfo)enumeration.nextElement();
                if (!connectionInfo.isIdle()) continue;
                ++n2;
            }
        }
        return n2;
    }

    public void setPoolSize(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", "setPoolSize(int poolSize)", new Object[]{new Integer(n2)});
        }
        Object object = this.getConnectMonitor;
        synchronized (object) {
            this.maxIdleConnections = n2;
        }
        CommonTrace.exit(commonTrace);
    }

    public void addConnectionPoolManagerListener(ConnectionPoolManagerListener connectionPoolManagerListener) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", this, "addConnectionPoolManagerListener(ConnectionPoolManagerListener l)", new Object[]{connectionPoolManagerListener});
        }
        this.listenerList.add(class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener == null ? (class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener = ConnectionPoolManager.class$("com.ibm.db2.tools.conn.ConnectionPoolManagerListener")) : class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener, connectionPoolManagerListener);
        CommonTrace.exit(commonTrace);
    }

    public void removeConnectionPoolManagerListener(ConnectionPoolManagerListener connectionPoolManagerListener) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", this, "removeConnectionPoolManagerListener(ConnectionPoolManagerListener l)", new Object[]{connectionPoolManagerListener});
        }
        this.listenerList.remove(class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener == null ? (class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener = ConnectionPoolManager.class$("com.ibm.db2.tools.conn.ConnectionPoolManagerListener")) : class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener, connectionPoolManagerListener);
        CommonTrace.exit(commonTrace);
    }

    public void fireConnectionCreated(ConnectionInfo connectionInfo) {
        this.fireConnectionPoolManagerChanged(new ConnectionPoolManagerEvent(this, connectionInfo, ConnectionPoolManagerEvent.CONNECTION_CREATED));
    }

    public void fireConnectionPoolManagerChanged(ConnectionPoolManagerEvent connectionPoolManagerEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.conn", "ConnectionPoolManager", this, "fireConnectionPoolManagerChanged(ConnectionPoolManagerEvent e)");
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener == null ? ConnectionPoolManager.class$("com.ibm.db2.tools.conn.ConnectionPoolManagerListener") : class$com$ibm$db2$tools$conn$ConnectionPoolManagerListener)) {
                ((ConnectionPoolManagerListener)objectArray[n2 + 1]).connectionPoolManagerChanged(connectionPoolManagerEvent);
            }
            n2 -= 2;
        }
        CommonTrace.exit(commonTrace);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

