/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.conn;

import com.ibm.db2.tools.conn.ConnectionPoolManager;
import com.ibm.db2.tools.conn.UserInfo;
import java.sql.Connection;
import java.util.Date;

public class ConnectionInfo {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2001, 2002.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";
    private Connection con;
    private UserInfo userInfo;
    private int nodeNumber;
    private ConnectionPoolManager pool;
    private boolean stateBusy = false;
    private boolean stateInvalid = false;
    private long idleTimestamp = 0L;
    private ConnectionInfo replacementConnectionInfo;

    public ConnectionInfo(Connection connection, UserInfo userInfo, int n2, ConnectionPoolManager connectionPoolManager) {
        this.con = connection;
        this.userInfo = userInfo;
        this.nodeNumber = n2;
        this.pool = connectionPoolManager;
        this.stateBusy = false;
        this.stateInvalid = false;
    }

    public Connection getConnection() {
        return this.con;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public ConnectionPoolManager getPool() {
        return this.pool;
    }

    public boolean isBusy() {
        return this.stateBusy;
    }

    public void setBusy() {
        this.stateBusy = true;
    }

    public boolean isIdle() {
        return !this.stateBusy;
    }

    public void setIdle() {
        this.stateBusy = false;
        this.setTimestamp();
    }

    public boolean isInvalid() {
        return this.stateInvalid;
    }

    public void setInvalid() {
        this.stateInvalid = true;
    }

    public ConnectionInfo getReplacementConnectionInfo() {
        return this.replacementConnectionInfo;
    }

    public void setReplacementConnectionInfo(ConnectionInfo connectionInfo) {
        this.replacementConnectionInfo = connectionInfo;
    }

    protected void setTimestamp() {
        this.idleTimestamp = new Date().getTime();
    }

    protected boolean expired(long l2) {
        boolean bl = false;
        if (this.isIdle() && new Date().getTime() - this.idleTimestamp > l2) {
            bl = true;
        }
        return bl;
    }
}

