/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.ui.progress.AbstractProgressIndicator;
import com.ibm.db2.tools.common.ui.progress.StepProgressStatusPanel;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public final class StepProgressStatusPanelWithOverallProgress
extends StepProgressStatusPanel {
    private JLabel taskTimeRemainingLabel;
    private JPanel overallProgressPanel;
    private long curTaskTimeRemaining;

    public StepProgressStatusPanelWithOverallProgress(String string) {
        super(string);
    }

    protected void makeEmptyPanel() {
    }

    protected void makeLayout(String string) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.makeStepProgressPanel(string);
        this.makeOverallProgressPanel();
    }

    private void makeStepProgressPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(""));
        this.stepProgressLabel = new JLabel(CmStringPool.get(286));
        jPanel.add(this.stepProgressLabel);
        String string2 = AbstractProgressIndicator.parseTime(-1, 1L, 288, 289, 290, 292, 293);
        if (string.length() > 0) {
            jPanel.setLayout(new GridLayout(6, 1, 2, 2));
            this.label1 = new JLabel(string);
            jPanel.add(this.label1);
            this.label2 = new JLabel(string2);
            jPanel.add(this.label2);
        } else {
            jPanel.setLayout(new GridLayout(5, 1, 2, 2));
            this.label1 = new JLabel(string2);
            jPanel.add(this.label1);
            this.label2 = new JLabel();
            jPanel.add(this.label2);
        }
        this.add(jPanel);
    }

    private void makeOverallProgressPanel() {
        this.overallProgressPanel = new JPanel(new GridLayout(4, 1, 2, 2));
        this.taskTimeRemainingLabel = new JLabel(AbstractProgressIndicator.parseTime(0, 0L, 295, 296, 297, 299, 300));
        this.overallProgressPanel.add(this.taskTimeRemainingLabel);
        Dimension dimension = this.taskTimeRemainingLabel.getPreferredSize();
        Double d2 = new Double((double)dimension.width * 1.5);
        this.taskTimeRemainingLabel.setPreferredSize(new Dimension(d2.intValue(), dimension.height));
        this.progressBar = new JProgressBar(0, 100);
        this.overallProgressPanel.add(this.progressBar);
        this.add(this.overallProgressPanel);
    }

    public void update(String string, long l2, long l3, int n2) {
        this.curTaskTimeRemaining = l3;
        String string2 = AbstractProgressIndicator.parseTime(-1, l2, 288, 289, 290, 292, 293);
        if (string.length() > 0) {
            this.label1.setText(string);
            this.label2.setText(string2);
        } else {
            this.label1.setText(string2);
            this.label2.setText("");
        }
        this.progressBar.setValue(n2);
        this.taskTimeRemainingLabel.setText(AbstractProgressIndicator.parseTime(n2, l3, 295, 296, 297, 299, 300));
    }

    public void finishSuccessfully() {
        this.stepProgressLabel.setText("");
        this.label1.setText("");
        this.label2.setText("");
        this.taskTimeRemainingLabel.setText(CmStringPool.get(301));
        this.progressBar.setValue(100);
    }

    public void finishWithNonCriticalError(int n2) {
        super.finishWithNonCriticalError(n2);
        this.taskTimeRemainingLabel.setText("");
    }

    public void finishWithCriticalError() {
        this.progressBar.setVisible(false);
        this.overallProgressPanel.removeAll();
        this.overallProgressPanel.add(new JLabel(CmStringPool.get(294)));
        this.overallProgressPanel.add(new JLabel(AbstractProgressIndicator.parseTime(-1, this.curTaskTimeRemaining, 307, 308, 309, 311, 312)));
        this.overallProgressPanel.add(new JLabel(CmStringPool.get(313)));
        this.overallProgressPanel.validate();
        this.overallProgressPanel.repaint();
    }
}

