/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonImageRepository;
import com.ibm.db2.tools.common.MultiLineLabel;
import com.ibm.db2.tools.common.ui.progress.ProgressStepCollection;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class StepProgressPanel
extends JPanel {
    protected final ImageIcon check = CommonImageRepository.getCommonIcon(CommonImageRepository.STEP_COMPLETE_VR);
    protected final ImageIcon iconFailed = CommonImageRepository.getCommonIcon(CommonImageRepository.STEP_FAILED_IMAGE);
    protected final ImageIcon arrow = CommonImageRepository.getCommonIcon(CommonImageRepository.STEP_IN_PROGRESS_VR);
    protected int numSteps;
    private JLabel[] iconLabels;
    protected int currentStep = 0;

    public StepProgressPanel(ProgressStepCollection progressStepCollection) {
        this.loadStepIcons(progressStepCollection);
        this.makeLayout(progressStepCollection);
    }

    private void loadStepIcons(ProgressStepCollection progressStepCollection) {
        this.numSteps = progressStepCollection.getTotalSteps();
        this.iconLabels = new JLabel[this.numSteps];
        int n2 = 0;
        while (n2 < this.numSteps) {
            this.iconLabels[n2] = new JLabel();
            this.iconLabels[n2].setPreferredSize(new Dimension(this.arrow.getIconWidth(), this.arrow.getIconHeight()));
            ++n2;
        }
    }

    protected void makeLayout(ProgressStepCollection progressStepCollection) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.makeStepPanel(progressStepCollection);
    }

    protected void makeStepPanel(ProgressStepCollection progressStepCollection) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 10, 1));
        jPanel.add(new JLabel(CmStringPool.get(272)));
        this.add(jPanel);
        int n2 = 0;
        while (n2 < this.numSteps) {
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 2));
            jPanel2.add(this.iconLabels[n2]);
            jPanel2.add(new MultiLineLabel(progressStepCollection.getStep(n2).getName(), 18));
            this.add(jPanel2);
            ++n2;
        }
    }

    public void update(ProgressStepCollection progressStepCollection, int n2) {
        if (this.currentStep < n2) {
            int n3 = this.currentStep;
            while (n3 < n2) {
                this.iconLabels[n3].setIcon(this.useIcon(progressStepCollection.getStep(n3).getCompletionStatus()));
                ++n3;
            }
            this.currentStep = n2;
            this.iconLabels[this.currentStep].setIcon(this.arrow);
        }
    }

    public void updateStepStarting(int n2) {
        this.iconLabels[n2].setIcon(this.arrow);
    }

    public void updateStepCompleted(ProgressStepCollection progressStepCollection, int n2) {
        this.iconLabels[n2].setIcon(this.useIcon(progressStepCollection.getStep(n2).getCompletionStatus()));
    }

    public void finish(ProgressStepCollection progressStepCollection) {
        int n2 = 0;
        while (n2 < this.numSteps) {
            this.iconLabels[n2].setIcon(this.useIcon(progressStepCollection.getStep(n2).getCompletionStatus()));
            ++n2;
        }
    }

    private ImageIcon useIcon(int n2) {
        if (n2 == 1) {
            return this.check;
        }
        if (n2 == 2) {
            return this.iconFailed;
        }
        return null;
    }
}

