/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.ui.progress.AbstractProgressIndicator;
import com.ibm.db2.tools.common.ui.progress.ProgressPointer;
import com.ibm.db2.tools.common.ui.progress.ProgressRunResult;
import com.ibm.db2.tools.common.ui.progress.ProgressStep;
import com.ibm.db2.tools.common.ui.progress.ProgressStepCollection;
import com.ibm.db2.tools.common.ui.progress.ProgressTaskInterface;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadEndedEvent;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadEvent;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadIncrementedEvent;
import com.ibm.db2.tools.common.ui.progress.StepProgressPanel;
import com.ibm.db2.tools.common.ui.progress.StepProgressStatusBasePanel;
import com.ibm.db2.tools.common.ui.progress.StepProgressStatusPanel;
import com.ibm.db2.tools.common.ui.progress.StepProgressStatusPanelWithOverallProgress;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class StepProgressIndicator
extends AbstractProgressIndicator {
    public static final int SHOW_STEPS_ONLY = 0;
    public static final int SHOW_STEP_PROGRESS = 1;
    public static final int SHOW_STEP_TASK_PROGRESS = 2;
    private StepProgressStatusBasePanel statusProgressPanel = null;
    private StepProgressPanel stepProgressPanel = null;
    private ProgressStepCollection stepsCollection;
    private String stepDescription;
    private int stepProgressIndicatorType;
    private long taskTimeRemaining = 0L;
    private boolean bStepFirstStart = true;

    public StepProgressIndicator(JFrame jFrame, String string, String string2, ProgressTaskInterface progressTaskInterface, ProgressStepCollection progressStepCollection, int n2) {
        super(jFrame, string, progressTaskInterface);
        this.initialize(string2, progressStepCollection, n2);
    }

    public StepProgressIndicator(CommonDialog commonDialog, String string, String string2, ProgressTaskInterface progressTaskInterface, ProgressStepCollection progressStepCollection, int n2) {
        super(commonDialog, string, progressTaskInterface);
        this.initialize(string2, progressStepCollection, n2);
    }

    private void initialize(String string, ProgressStepCollection progressStepCollection, int n2) {
        this.stepDescription = string;
        this.stepProgressIndicatorType = n2;
        this.stepsCollection = progressStepCollection;
    }

    protected JPanel makeProgressPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.stepProgressPanel = new StepProgressPanel(this.stepsCollection);
        jPanel.add(this.stepProgressPanel);
        jPanel.add(this.makeStatusPanel());
        return jPanel;
    }

    private JPanel makeStatusPanel() {
        this.statusProgressPanel = this.stepProgressIndicatorType == 2 ? new StepProgressStatusPanelWithOverallProgress(this.stepDescription) : (this.stepProgressIndicatorType == 1 ? new StepProgressStatusPanel(this.stepDescription) : new StepProgressStatusBasePanel());
        return this.statusProgressPanel;
    }

    protected void updateStatus(ProgressPointer progressPointer) {
        this.updateDialog(progressPointer);
    }

    private void updateDialog(ProgressPointer progressPointer) {
        int n2 = progressPointer.getCurrentStepIndex();
        ProgressStep progressStep = this.stepsCollection.getStep(n2);
        super.update();
        if (progressStep.getCompletionStatus() == 1 || progressStep.getCompletionStatus() == 2) {
            this.stepProgressPanel.updateStepCompleted(this.stepsCollection, n2);
            this.bStepFirstStart = true;
        } else if (progressStep.getRunningState() == 1 && this.bStepFirstStart) {
            this.bStepFirstStart = false;
            this.stepProgressPanel.updateStepStarting(n2);
        }
        if (this.stepProgressIndicatorType == 2) {
            this.taskTimeRemaining = progressPointer.getTaskTimeRemaining();
            ((StepProgressStatusPanelWithOverallProgress)this.statusProgressPanel).update(progressStep.getStepProgressDescription(), progressPointer.getStepTimeRemaining(), progressPointer.getTaskTimeRemaining(), progressPointer.getTaskPercentCompleted());
        } else if (this.stepProgressIndicatorType == 1) {
            ((StepProgressStatusPanel)this.statusProgressPanel).update(progressStep.getStepProgressDescription(), progressPointer.getStepTimeRemaining(), progressPointer.getStepPercentCompleted());
        }
    }

    public void finish(int n2, int n3) {
        this.stepProgressPanel.finish(this.stepsCollection);
        if (n2 == 0) {
            super.finish(false);
            this.statusProgressPanel.finishSuccessfully();
        } else if (n2 == 1) {
            super.finish(false);
            this.statusProgressPanel.finishWithNonCriticalError(n3);
        } else if (n2 == 2) {
            super.finish(true);
            this.statusProgressPanel.finishWithCriticalError();
        }
        this.toFront();
    }

    public void progressThreadIncremented(ProgressThreadEvent progressThreadEvent) {
        ProgressThreadIncrementedEvent progressThreadIncrementedEvent = (ProgressThreadIncrementedEvent)progressThreadEvent;
        this.updateStatus(progressThreadIncrementedEvent.getProgressPointer());
    }

    public void progressThreadEnded(ProgressThreadEvent progressThreadEvent) {
        ProgressThreadEndedEvent progressThreadEndedEvent = (ProgressThreadEndedEvent)progressThreadEvent;
        ProgressRunResult progressRunResult = progressThreadEndedEvent.getProgressRunResult();
        if (progressRunResult.getStatus() == ProgressRunResult.Status.SUCCESS) {
            this.finish(0, 0);
        } else if (progressRunResult.getStatus() == ProgressRunResult.Status.WARNING) {
            this.finish(1, progressRunResult.getNumNonCriticalError());
        } else {
            this.finish(2, 0);
        }
    }
}

