/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.ui.progress.AbstractProgressIndicator;
import com.ibm.db2.tools.common.ui.progress.ProgressRunResult;
import com.ibm.db2.tools.common.ui.progress.ProgressStatusPanel;
import com.ibm.db2.tools.common.ui.progress.ProgressTaskInterface;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadEndedEvent;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadEvent;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadIncrementedEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class StaticTextPercentProgressIndicator
extends AbstractProgressIndicator {
    private ProgressStatusPanel statusProgressPanel = null;
    private String description;

    public StaticTextPercentProgressIndicator(JFrame jFrame, String string, ProgressTaskInterface progressTaskInterface, String string2) {
        super(jFrame, string, progressTaskInterface);
        this.description = string2;
    }

    public StaticTextPercentProgressIndicator(CommonDialog commonDialog, String string, ProgressTaskInterface progressTaskInterface, String string2) {
        super(commonDialog, string, progressTaskInterface);
        this.description = string2;
    }

    protected JPanel makeProgressPanel() {
        this.statusProgressPanel = new ProgressStatusPanel(this.description, this.getPercentText(1, 100));
        return this.statusProgressPanel;
    }

    public void updateStatus(long l2, long l3, String string) {
        if (l3 > l2) {
            throw new IllegalArgumentException("Current progress (" + l3 + ") must be <= total progress (" + l2 + ")");
        }
        int n2 = (int)(l3 * 100L / l2);
        super.update();
        this.statusProgressPanel.update(this.getPercentText(n2, 100), 100, n2);
        this.statusProgressPanel.updateProgressDescription(string);
    }

    private String getPercentText(int n2, int n3) {
        int n4 = n2 * 100 / n3;
        return CmStringPool.get(280, new Integer(n4));
    }

    public void progressThreadIncremented(ProgressThreadEvent progressThreadEvent) {
        ProgressThreadIncrementedEvent progressThreadIncrementedEvent = (ProgressThreadIncrementedEvent)progressThreadEvent;
        if (progressThreadIncrementedEvent.getStepEventType() == ProgressThreadIncrementedEvent.StepEventType.STEP_STARTING) {
            return;
        }
        this.updateStatus(progressThreadIncrementedEvent.getTotalSubStepsInCurrentStep(), progressThreadIncrementedEvent.getMostRecentlyCompletedSubStepIndex() + 1, progressThreadIncrementedEvent.getStepDescription());
    }

    public void progressThreadEnded(ProgressThreadEvent progressThreadEvent) {
        ProgressThreadEndedEvent progressThreadEndedEvent = (ProgressThreadEndedEvent)progressThreadEvent;
        ProgressRunResult progressRunResult = progressThreadEndedEvent.getProgressRunResult();
        this.finish(progressRunResult.getStatus() != ProgressRunResult.Status.SUCCESS);
    }
}

