/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.ui.progress.ProgressPointer;
import com.ibm.db2.tools.common.ui.progress.ProgressStepCollection;
import com.ibm.db2.tools.common.ui.progress.ProgressThread;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadEvent;

public class ProgressThreadIncrementedEvent
extends ProgressThreadEvent {
    private final StepEventType stepEventType;
    private final ProgressStepCollection steps;
    private final ProgressPointer progressPointer;
    private final int totalSteps;
    private final int currentStepIndex;
    private final int totalSubStepsInCurrentStep;
    private final int mostRecentlyCompletedSubStepIndex;
    private final long timeRemainingForCurrentStep;
    private final String stepDescription;

    public ProgressThreadIncrementedEvent(ProgressThread progressThread) {
        this(progressThread, null, 0, 0, 0L, null, null);
    }

    public ProgressThreadIncrementedEvent(ProgressThread progressThread, ProgressPointer progressPointer) {
        this(progressThread, progressPointer.getSteps(), progressPointer.getCurrentStepIndex(), progressPointer.getMostRecentlyCompletedSubStepIndex(), progressPointer.getTaskTimeRemaining(), progressPointer.getStepEventType(), progressPointer);
    }

    public ProgressThreadIncrementedEvent(ProgressThread progressThread, ProgressStepCollection progressStepCollection, int n2, int n3, long l2) {
        this(progressThread, progressStepCollection, n2, n3, l2, null, null);
    }

    private ProgressThreadIncrementedEvent(ProgressThread progressThread, ProgressStepCollection progressStepCollection, int n2, int n3, long l2, StepEventType stepEventType, ProgressPointer progressPointer) {
        super(progressThread);
        this.currentStepIndex = n2;
        this.mostRecentlyCompletedSubStepIndex = n3;
        this.timeRemainingForCurrentStep = l2;
        this.stepEventType = stepEventType;
        this.progressPointer = progressPointer;
        this.steps = progressStepCollection;
        if (progressStepCollection != null) {
            this.totalSteps = progressStepCollection.getTotalSteps();
            this.totalSubStepsInCurrentStep = progressStepCollection.getStep(n2).getTotalSubSteps();
            this.stepDescription = progressStepCollection.getStep(n2).getStepProgressDescription();
        } else {
            this.totalSteps = 0;
            this.totalSubStepsInCurrentStep = 0;
            this.stepDescription = null;
        }
    }

    public int getCurrentStepIndex() {
        return this.currentStepIndex;
    }

    public int getTotalSteps() {
        return this.totalSteps;
    }

    public int getMostRecentlyCompletedSubStepIndex() {
        return this.mostRecentlyCompletedSubStepIndex;
    }

    public int getTotalSubStepsInCurrentStep() {
        return this.totalSubStepsInCurrentStep;
    }

    public long getTimeRemainingForCurrentStep() {
        return this.timeRemainingForCurrentStep;
    }

    public String getStepDescription() {
        return this.stepDescription;
    }

    public ProgressPointer getProgressPointer() {
        return this.progressPointer;
    }

    public StepEventType getStepEventType() {
        return this.stepEventType;
    }

    public static class StepEventType {
        public static StepEventType STEP_STARTING = new StepEventType("STEP_STARTING");
        public static StepEventType SUB_STEP_COMPLETED = new StepEventType("SUB_STEP_COMPLETED");
        public static StepEventType STEP_COMPLETED = new StepEventType("STEP_COMPLETED");
        private String name;

        private StepEventType(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

