/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.ui.progress.AbstractProgressRunnable;
import com.ibm.db2.tools.common.ui.progress.ProgressRunResult;
import com.ibm.db2.tools.common.ui.progress.ProgressRunnable;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadEndedEvent;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadIncrementedEvent;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadListener;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadStartedEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class ProgressThread
extends Thread
implements ProgressRunnable {
    private ProgressRunnable progressRunnable = this;
    private EventListenerList listenerList = new EventListenerList();
    private ProgressRunResult progressRunResult;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener;

    public ProgressThread() {
        this.setProgressRunnable(this);
    }

    public ProgressThread(ProgressRunnable progressRunnable) {
        this.setProgressRunnable(progressRunnable);
    }

    public ProgressThread(ProgressThreadListener progressThreadListener) {
        this.listenerList.add(class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener == null ? (class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener = ProgressThread.class$("com.ibm.db2.tools.common.ui.progress.ProgressThreadListener")) : class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener, progressThreadListener);
    }

    public ProgressThread(ProgressRunnable progressRunnable, ProgressThreadListener progressThreadListener) {
        this.setProgressRunnable(progressRunnable);
        this.addProgressThreadListener(progressThreadListener);
    }

    public void addProgressThreadListener(ProgressThreadListener progressThreadListener) {
        if (progressThreadListener == null) {
            return;
        }
        this.listenerList.add(class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener == null ? (class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener = ProgressThread.class$("com.ibm.db2.tools.common.ui.progress.ProgressThreadListener")) : class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener, progressThreadListener);
    }

    public void removeProgressThreadListener(ProgressThreadListener progressThreadListener) {
        if (progressThreadListener == null) {
            return;
        }
        this.listenerList.remove(class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener == null ? (class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener = ProgressThread.class$("com.ibm.db2.tools.common.ui.progress.ProgressThreadListener")) : class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener, progressThreadListener);
    }

    public ProgressRunnable getProgressRunnable() {
        if (this.progressRunnable == null) {
            return this;
        }
        return this.progressRunnable;
    }

    public void setProgressRunnable(ProgressRunnable progressRunnable) {
        this.progressRunnable = progressRunnable;
        if (progressRunnable instanceof AbstractProgressRunnable) {
            ((AbstractProgressRunnable)progressRunnable).setProgressThread(this);
        }
    }

    public ProgressRunResult progressRun() {
        return new ProgressRunResult(ProgressRunResult.Status.SUCCESS);
    }

    public void run() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("common", "ProgressThread", this, "run()");
        }
        try {
            this.fireProgressThreadStartedEvent(this.createProgressThreadStartedEvent());
            this.progressRunResult = this.getProgressRunnable().progressRun();
            if (this.progressRunResult.getStatus() != ProgressRunResult.Status.DELAYED) {
                this.fireProgressThreadEndedEvent(this.createProgressThreadEndedEvent(this.progressRunResult));
            }
        }
        catch (Throwable throwable) {
            CommonTrace.catchBlock(commonTrace);
            CommonTrace.write(commonTrace, "Uncaught exception in Progress Thread:  ");
            CommonTrace.write(commonTrace, throwable);
            throwable.printStackTrace();
        }
        CommonTrace.exit(commonTrace);
    }

    protected ProgressThreadStartedEvent createProgressThreadStartedEvent() {
        return new ProgressThreadStartedEvent(this);
    }

    protected final void fireProgressThreadStartedEvent(final ProgressThreadStartedEvent progressThreadStartedEvent) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this._fireProgressThreadStartedEvent(progressThreadStartedEvent);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ProgressThread.this._fireProgressThreadStartedEvent(progressThreadStartedEvent);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void _fireProgressThreadStartedEvent(ProgressThreadStartedEvent progressThreadStartedEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = 0;
        while (n2 <= objectArray.length - 2) {
            if (objectArray[n2] == (class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener == null ? ProgressThread.class$("com.ibm.db2.tools.common.ui.progress.ProgressThreadListener") : class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener)) {
                ((ProgressThreadListener)objectArray[n2 + 1]).progressThreadStarted(progressThreadStartedEvent);
            }
            n2 += 2;
        }
    }

    public final void fireProgressThreadIncrementedEvent(final ProgressThreadIncrementedEvent progressThreadIncrementedEvent) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this._fireProgressThreadIncrementedEvent(progressThreadIncrementedEvent);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ProgressThread.this._fireProgressThreadIncrementedEvent(progressThreadIncrementedEvent);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void _fireProgressThreadIncrementedEvent(ProgressThreadIncrementedEvent progressThreadIncrementedEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = 0;
        while (n2 <= objectArray.length - 2) {
            if (objectArray[n2] == (class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener == null ? ProgressThread.class$("com.ibm.db2.tools.common.ui.progress.ProgressThreadListener") : class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener)) {
                ((ProgressThreadListener)objectArray[n2 + 1]).progressThreadIncremented(progressThreadIncrementedEvent);
            }
            n2 += 2;
        }
    }

    protected ProgressThreadEndedEvent createProgressThreadEndedEvent(ProgressRunResult progressRunResult) {
        this.progressRunResult = progressRunResult;
        return new ProgressThreadEndedEvent(this);
    }

    protected final void fireProgressThreadEndedEvent(final ProgressThreadEndedEvent progressThreadEndedEvent) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this._fireProgressThreadEndedEvent(progressThreadEndedEvent);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ProgressThread.this._fireProgressThreadEndedEvent(progressThreadEndedEvent);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void _fireProgressThreadEndedEvent(ProgressThreadEndedEvent progressThreadEndedEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener == null ? ProgressThread.class$("com.ibm.db2.tools.common.ui.progress.ProgressThreadListener") : class$com$ibm$db2$tools$common$ui$progress$ProgressThreadListener)) {
                ((ProgressThreadListener)objectArray[n2 + 1]).progressThreadEnded(progressThreadEndedEvent);
            }
            n2 -= 2;
        }
    }

    public ProgressRunResult getProgressRunResult() {
        return this.progressRunResult;
    }

    public void setProgressRunResult(ProgressRunResult.Status status) {
        this.progressRunResult = new ProgressRunResult(status);
    }

    public void setProgressRunResult(ProgressRunResult progressRunResult) {
        this.progressRunResult = progressRunResult;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

