/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.MultiLineLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class ProgressStatusPanel
extends JPanel {
    private MultiLineLabel descriptionLabel;
    private JProgressBar progressBar;
    private JLabel statusLabel;

    public ProgressStatusPanel(String string, String string2) {
        this.makeLayout(string, string2);
    }

    protected void makeLayout(String string, String string2) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.makeDescriptionPanel(string);
        this.makeProgressBarPanel();
        this.makeStatusPanel(string2);
    }

    protected void makeDescriptionPanel(String string) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.descriptionLabel = new MultiLineLabel(string, 20);
        this.descriptionLabel.setSizingMode(2);
        Dimension dimension = this.descriptionLabel.getPreferredSize();
        int n2 = dimension.width * 6 / 5;
        int n3 = ((Component)this.descriptionLabel).getFontMetrics(this.getFont()).getHeight();
        this.descriptionLabel.setPreferredSize(new Dimension(n2, n3));
        jPanel.add(this.descriptionLabel);
        this.add(jPanel);
    }

    protected void makeProgressBarPanel() {
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.add(this.progressBar);
    }

    protected void makeStatusPanel(String string) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.statusLabel = new JLabel(string);
        Dimension dimension = this.statusLabel.getPreferredSize();
        int n2 = dimension.width * 2;
        this.statusLabel.setPreferredSize(new Dimension(n2, dimension.height));
        jPanel.add(this.statusLabel);
        this.add(jPanel);
    }

    public void update(String string, int n2, int n3) {
        this.statusLabel.setText(string);
        this.progressBar.setMaximum(n2);
        this.progressBar.setValue(n3);
    }

    public void updateProgressDescription(String string) {
        this.descriptionLabel.setText(string);
    }
}

