/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.CommonDialog;
import java.awt.Window;
import javax.swing.JFrame;

public class ProgressRunResult {
    private Status status;
    private int resultCode;
    private String inputText;
    private String outputText;
    private String messageIDStr;
    private String[] messageTokens;
    private Window parentWindow;
    private int numNonCriticalError;

    public ProgressRunResult(Status status) {
        this(status, 0, "0");
    }

    public ProgressRunResult(Status status, int n2) {
        this(status, n2, Integer.toString(n2));
    }

    public ProgressRunResult(Status status, int n2, String string) {
        this(status, n2, string, 0);
    }

    public ProgressRunResult(Status status, int n2, String string, int n3) {
        this.status = status;
        this.resultCode = n2;
        this.messageIDStr = string;
        this.numNonCriticalError = n3;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isSuccess() {
        return this.status == Status.SUCCESS;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getInputText() {
        return this.inputText;
    }

    public String getOutputText() {
        return this.outputText;
    }

    public String[] getMessageTokens() {
        return this.messageTokens;
    }

    public JFrame getParentFrame() {
        JFrame jFrame = null;
        if (this.parentWindow instanceof JFrame) {
            jFrame = (JFrame)this.parentWindow;
        }
        return jFrame;
    }

    public CommonDialog getParentDialog() {
        CommonDialog commonDialog = null;
        if (this.parentWindow instanceof CommonDialog) {
            commonDialog = (CommonDialog)this.parentWindow;
        }
        return commonDialog;
    }

    public void setInputText(String string) {
        this.inputText = string;
    }

    public void setOutputText(String string) {
        this.outputText = string;
    }

    public void setMessageTokens(String[] stringArray) {
        this.messageTokens = stringArray;
    }

    public void setParentFrame(JFrame jFrame) {
        this.parentWindow = jFrame;
    }

    public void setParentDialog(CommonDialog commonDialog) {
        this.parentWindow = commonDialog;
    }

    public String getMessageIDStr() {
        return this.messageIDStr;
    }

    public void setMessageIDStr(String string) {
        this.messageIDStr = string;
    }

    public int getNumNonCriticalError() {
        return this.numNonCriticalError;
    }

    public void setNumNonCriticalError(int n2) {
        this.numNonCriticalError = n2;
    }

    public static class Status {
        public static final Status SUCCESS = new Status();
        public static final Status WARNING = new Status();
        public static final Status FAILURE = new Status();
        public static Status DELAYED = new Status();

        private Status() {
        }
    }
}

