/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.ui.progress.ProgressStep;
import com.ibm.db2.tools.common.ui.progress.ProgressStepCollection;
import com.ibm.db2.tools.common.ui.progress.ProgressThread;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadIncrementedEvent;
import com.ibm.db2.tools.common.ui.progress.StepProgressIndicator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.Timer;

public class ProgressPointer
implements ActionListener {
    private ProgressStepCollection steps;
    private StepProgressIndicator progressIndicator;
    private ProgressThread progressThread;
    private ProgressThreadIncrementedEvent.StepEventType stepEventType;
    private int currentStepIndex = -1;
    private static final int SUB_STEP_START_INDEX = 0;
    private int currentSubStepIndex;
    private int totalNumSubStepsCompletedSoFar;
    private final int AUTO_NUM_SUB_STEPS = 10;
    private final int AUTO_PERCENT_INCREMENT = 10;
    private final int ALMOST_COMPLETE_PERCENT = 98;
    private long stepTimeRemaining;
    private long taskTimeRemaining;
    private long startTime;
    private long taskStartTime;
    private boolean bManualStepTimeRemainingEstimate;
    private boolean bManualStepPercentCompleted;
    private int stepPercentCompleted;
    private int taskPercentCompleted;
    private boolean autoSubStepProgressUpdate = false;
    private Timer timer;

    public ProgressPointer(ProgressStepCollection progressStepCollection, StepProgressIndicator stepProgressIndicator) {
        this.steps = progressStepCollection;
        this.progressIndicator = stepProgressIndicator;
    }

    public ProgressPointer(ProgressStepCollection progressStepCollection, ProgressThread progressThread) {
        this.construct(progressStepCollection, progressThread);
    }

    public ProgressPointer(int n2, ProgressThread progressThread) {
        ProgressStepCollection progressStepCollection = new ProgressStepCollection();
        progressStepCollection.addStep("Anonymous Step 1", n2);
        this.construct(progressStepCollection, progressThread);
    }

    private void construct(ProgressStepCollection progressStepCollection, ProgressThread progressThread) {
        this.steps = progressStepCollection;
        this.progressThread = progressThread;
    }

    public void fireStepStarting() {
        ++this.currentStepIndex;
        if (this.taskStartTime == 0L) {
            this.taskStartTime = new Date().getTime();
        }
        this.startTime = new Date().getTime();
        this.currentSubStepIndex = 0;
        this.getCurrentStep().setRunningState(1);
        if (this.getInitialTimeEstimateInCurrentStep() == -1L) {
            if (this.currentStepIndex == 0) {
                this.setCurrentStepTimeRemaining(10000L);
            } else if (this.getCurrentStep().getTotalSubSteps() > 0 && this.totalNumSubStepsCompletedSoFar > 0) {
                long l2 = new Date().getTime();
                long l3 = l2 - this.taskStartTime;
                long l4 = l3 / (long)this.totalNumSubStepsCompletedSoFar;
                this.setCurrentStepTimeRemaining((long)this.getCurrentStep().getTotalSubSteps() * l4);
            } else {
                this.setCurrentStepTimeRemaining(10000L);
            }
        } else {
            this.setCurrentStepTimeRemaining(this.getInitialTimeEstimateInCurrentStep());
        }
        this.bManualStepTimeRemainingEstimate = false;
        this.bManualStepPercentCompleted = false;
        this.stepPercentCompleted = 0;
        this.checkForEnableAutoUpdate();
        this.updateTaskPercentCompleted();
        this.updateTaskTimeRemaining();
        this.stepEventType = ProgressThreadIncrementedEvent.StepEventType.STEP_STARTING;
        if (CommonTrace.isTrace()) {
            this.traceState("fireStepStarting");
        }
        if (this.progressThread != null) {
            this.progressThread.fireProgressThreadIncrementedEvent(new ProgressThreadIncrementedEvent(this.progressThread, this));
        } else if (this.progressIndicator != null) {
            this.progressIndicator.updateStatus(this);
        }
    }

    public void fireSubStepCompleted() {
        ++this.currentSubStepIndex;
        ++this.totalNumSubStepsCompletedSoFar;
        this.updateStepTimeRemaining(false);
        this.updateStepPercentCompleted(false);
        this.updateTaskPercentCompleted();
        this.updateTaskTimeRemaining();
        this.stepEventType = ProgressThreadIncrementedEvent.StepEventType.SUB_STEP_COMPLETED;
        if (CommonTrace.isTrace()) {
            this.traceState("fireSubStepCompleted");
        }
        if (this.progressThread != null) {
            this.progressThread.fireProgressThreadIncrementedEvent(new ProgressThreadIncrementedEvent(this.progressThread, this));
        } else if (this.progressIndicator != null) {
            this.progressIndicator.updateStatus(this);
        }
    }

    public void fireSubStepCompleted(int n2) {
        if (n2 >= this.steps.getStep(this.currentStepIndex).getTotalSubSteps()) {
            throw new IllegalArgumentException("Completed sub step index (" + n2 + ") must be less than total number of sub-steps (" + this.steps.getStep(this.currentStepIndex).getTotalSubSteps() + ").  Call fireStepCompleted() to indicate last sub-step has completed");
        }
        this.currentSubStepIndex = n2 - 1;
        this.updateTaskPercentCompleted();
        this.updateTaskTimeRemaining();
        this.fireSubStepCompleted();
    }

    public void fireStepCompleted(int n2) {
        ProgressStep progressStep = this.steps.getStep(this.currentStepIndex);
        if (this.timer != null) {
            this.timer.stop();
        }
        progressStep.setRunningState(2);
        progressStep.setCompletionStatus(n2);
        if (n2 == 1) {
            this.currentSubStepIndex = this.autoSubStepProgressUpdate ? 10 : this.getTotalSubStepsInCurrentStep();
            this.updateStepTimeRemaining(true);
            this.updateStepPercentCompleted(true);
        } else {
            this.updateStepTimeRemaining(false);
            this.updateStepPercentCompleted(false);
        }
        this.updateTaskPercentCompleted();
        this.updateTaskTimeRemaining();
        this.stepEventType = ProgressThreadIncrementedEvent.StepEventType.STEP_COMPLETED;
        if (CommonTrace.isTrace()) {
            this.traceState("fireStepCompleted, status = " + n2);
        }
        if (this.progressThread != null) {
            this.progressThread.fireProgressThreadIncrementedEvent(new ProgressThreadIncrementedEvent(this.progressThread, this));
        } else if (this.progressIndicator != null) {
            this.progressIndicator.updateStatus(this);
        }
    }

    public int getCurrentStepIndex() {
        return this.currentStepIndex;
    }

    public int getCurrentSubStepIndex() {
        return this.currentSubStepIndex;
    }

    public int getMostRecentlyCompletedSubStepIndex() {
        return this.getCurrentSubStepIndex() - 1;
    }

    public int getTotalSteps() {
        return this.steps.getTotalSteps();
    }

    public int getTotalSubStepsInCurrentStep() {
        return this.steps.getStep(this.currentStepIndex).getTotalSubSteps();
    }

    public ProgressStepCollection getSteps() {
        return this.steps;
    }

    public ProgressStep getCurrentStep() {
        return this.steps.getStep(this.currentStepIndex);
    }

    public int getTaskPercentCompleted() {
        return this.taskPercentCompleted;
    }

    public int getStepPercentCompleted() {
        return this.stepPercentCompleted;
    }

    public void setStepPercentCompleted(int n2) {
        this.bManualStepPercentCompleted = true;
        this.setCurrentStepPercentCompleted(n2);
    }

    private void setCurrentStepPercentCompleted(int n2) {
        if (n2 > 100) {
            throw new IllegalStateException("The step percent completed cannot exceed 100.");
        }
        if (n2 > this.stepPercentCompleted) {
            this.stepPercentCompleted = n2;
        }
    }

    private void updateStepPercentCompleted(boolean bl) {
        if (bl) {
            this.setCurrentStepPercentCompleted(100);
            return;
        }
        if (!this.bManualStepPercentCompleted) {
            int n2;
            if (this.getTotalSubStepsInCurrentStep() < 1) {
                throw new IllegalStateException("The number of substeps in the current step is less than 1. \nPlease make sure the ProgressStep has at least one substep.");
            }
            n2 = this.autoSubStepProgressUpdate ? ((n2 = this.stepPercentCompleted + 10) >= 100 ? 98 : n2) : ((n2 = this.getCurrentSubStepIndex() * 100 / this.getTotalSubStepsInCurrentStep()) > 100 ? 100 : n2);
            this.setCurrentStepPercentCompleted(n2);
        }
    }

    public void setStepTimeRemaining(long l2) {
        this.bManualStepTimeRemainingEstimate = true;
        this.setCurrentStepTimeRemaining(l2);
    }

    private void setCurrentStepTimeRemaining(long l2) {
        this.stepTimeRemaining = l2;
    }

    public long getStepTimeRemaining() {
        return this.stepTimeRemaining;
    }

    public long getInitialTimeEstimateInCurrentStep() {
        return this.steps.getStep(this.currentStepIndex).getStepInitialTimeEstimate();
    }

    private void updateStepTimeRemaining(boolean bl) {
        if (bl) {
            this.setCurrentStepTimeRemaining(0L);
            return;
        }
        if (!this.bManualStepTimeRemainingEstimate) {
            if (this.autoSubStepProgressUpdate) {
                this.setCurrentStepTimeRemaining(this.computeStepTimeRemainBasedonTimeElapse(10));
            } else {
                this.setCurrentStepTimeRemaining(this.computeStepTimeRemainBasedonTimeElapse(this.getTotalSubStepsInCurrentStep()));
            }
        }
    }

    private long computeStepTimeRemainBasedonTimeElapse(int n2) {
        long l2;
        long l3;
        int n3 = n2 - this.getCurrentSubStepIndex();
        long l4 = new Date().getTime();
        long l5 = l3 = l4 - this.startTime;
        if (this.currentSubStepIndex != 0) {
            l5 = l3 / (long)this.currentSubStepIndex;
        }
        return (l2 = l5 * (long)n3) < 0L ? 0L : l2;
    }

    public long getTaskTimeRemaining() {
        return this.taskTimeRemaining;
    }

    private void updateTaskTimeRemaining() {
        long l2 = new Date().getTime();
        long l3 = l2 - this.taskStartTime;
        this.taskTimeRemaining = this.stepTimeRemaining;
        int n2 = this.currentStepIndex + 1;
        while (n2 < this.steps.getTotalSteps()) {
            long l4 = this.steps.getStep(n2).getStepInitialTimeEstimate();
            if (l4 == -1L) {
                if (this.taskPercentCompleted == 0) {
                    this.taskPercentCompleted = 1;
                }
                this.taskTimeRemaining = (long)((100.0 - (double)this.taskPercentCompleted) / (double)this.taskPercentCompleted * (double)l3);
                this.taskTimeRemaining = this.taskTimeRemaining < 0L ? 0L : this.taskTimeRemaining;
                break;
            }
            this.taskTimeRemaining += l4;
            ++n2;
        }
    }

    private void updateTaskPercentCompleted() {
        this.taskPercentCompleted = (int)((float)this.totalNumSubStepsCompletedSoFar / (float)this.steps.getTotalSubSteps() * 100.0f);
    }

    private void checkForEnableAutoUpdate() {
        if (this.getTotalSubStepsInCurrentStep() <= 1 && this.getInitialTimeEstimateInCurrentStep() > 0L) {
            this.autoSubStepProgressUpdate = true;
            this.computeUpdateTimeInterval();
        } else {
            this.autoSubStepProgressUpdate = false;
        }
    }

    private void computeUpdateTimeInterval() {
        long l2 = this.getInitialTimeEstimateInCurrentStep() / 10L;
        if (l2 < 1L) {
            throw new IllegalStateException("Initial step time estimate is 0. \nPlease make sure the initial step time estimate is greater than 0.");
        }
        if (this.timer == null) {
            this.timer = new Timer((int)l2, this);
            this.timer.start();
        } else {
            this.timer.restart();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fireSubStepCompleted();
    }

    public ProgressThreadIncrementedEvent.StepEventType getStepEventType() {
        return this.stepEventType;
    }

    public void setCurrentStepProgressDescription(String string) {
        this.steps.getStep(this.currentStepIndex).setStepProgressDescription(string);
    }

    private void printState(String string) {
        System.out.println("");
        System.out.println("ProgressPointer.printState: " + string);
        System.out.println("ProgressPointer.printState: getStepEventType() = " + this.getStepEventType());
        System.out.println("ProgressPointer.printState: getCurrentStepIndex() = " + this.getCurrentStepIndex());
        System.out.println("ProgressPointer.printState: getCurrentSubStepIndex() = " + this.getCurrentSubStepIndex());
        System.out.println("ProgressPointer.printState: getMostRecentlyCompletedSubStepIndex() = " + this.getMostRecentlyCompletedSubStepIndex());
        System.out.println("ProgressPointer.printState: getStepPercentCompleted() = " + this.getStepPercentCompleted());
        System.out.println("ProgressPointer.printState: getStepTimeRemaining() = " + this.getStepTimeRemaining());
        System.out.println("ProgressPointer.printState: getTaskPercentCompleted() = " + this.getTaskPercentCompleted());
        System.out.println("ProgressPointer.printState: getTaskTimeRemaining() = " + this.getTaskTimeRemaining());
    }

    private void traceState(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.ui.progress", "ProgressPointer", this, "traceState(String comment)", new Object[]{string});
        }
        CommonTrace.write(commonTrace, string);
        CommonTrace.write(commonTrace, "getStepEventType() = " + this.getStepEventType());
        CommonTrace.write(commonTrace, "getCurrentStepIndex() = " + this.getCurrentStepIndex());
        CommonTrace.write(commonTrace, "getCurrentSubStepIndex() = " + this.getCurrentSubStepIndex());
        CommonTrace.write(commonTrace, "getMostRecentlyCompletedSubStepIndex() = " + this.getMostRecentlyCompletedSubStepIndex());
        CommonTrace.write(commonTrace, "getStepPercentCompleted() = " + this.getStepPercentCompleted());
        CommonTrace.write(commonTrace, "getStepTimeRemaining() = " + this.getStepTimeRemaining());
        CommonTrace.write(commonTrace, "getTaskPercentCompleted() = " + this.getTaskPercentCompleted());
        CommonTrace.write(commonTrace, "getTaskTimeRemaining() = " + this.getTaskTimeRemaining());
        CommonTrace.exit(commonTrace);
    }
}

