/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.ui.progress.AbstractProgressIndicator;
import com.ibm.db2.tools.common.ui.progress.CustomizeObjectCountPIInterface;
import com.ibm.db2.tools.common.ui.progress.ProgressRunResult;
import com.ibm.db2.tools.common.ui.progress.ProgressStatusPanel;
import com.ibm.db2.tools.common.ui.progress.ProgressTaskInterface;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadEndedEvent;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadEvent;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadIncrementedEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class ObjectCountTimeProgressIndicator
extends AbstractProgressIndicator {
    private ProgressStatusPanel statusProgressPanel = null;
    private int descriptionIndex;
    private CustomizeObjectCountPIInterface customizeDisplayInterface = null;

    public ObjectCountTimeProgressIndicator(JFrame jFrame, String string, ProgressTaskInterface progressTaskInterface, int n2) {
        super(jFrame, string, progressTaskInterface);
        this.descriptionIndex = n2;
    }

    public ObjectCountTimeProgressIndicator(CommonDialog commonDialog, String string, ProgressTaskInterface progressTaskInterface, int n2) {
        super(commonDialog, string, progressTaskInterface);
        this.descriptionIndex = n2;
    }

    public void setCustomizeDisplayInterface(CustomizeObjectCountPIInterface customizeObjectCountPIInterface) {
        this.customizeDisplayInterface = customizeObjectCountPIInterface;
    }

    protected JPanel makeProgressPanel() {
        this.statusProgressPanel = new ProgressStatusPanel(this.getDescriptionText(0L, 0L), AbstractProgressIndicator.parseTime(-1, -1L, 276, 279, 277, 281, 282));
        return this.statusProgressPanel;
    }

    public void updateStatus(long l2, long l3, long l4) {
        if (l3 > l2) {
            throw new IllegalArgumentException("Current progress (" + l3 + ") must be <= total progress (" + l2 + ")");
        }
        int n2 = (int)(l3 * 100L / l2);
        super.update();
        this.statusProgressPanel.updateProgressDescription(this.getDescriptionText(l3, l2));
        this.statusProgressPanel.update(AbstractProgressIndicator.parseTime(-1, l4, 276, 279, 277, 281, 282), 100, n2);
    }

    public void progressThreadIncremented(ProgressThreadEvent progressThreadEvent) {
        ProgressThreadIncrementedEvent progressThreadIncrementedEvent = (ProgressThreadIncrementedEvent)progressThreadEvent;
        if (progressThreadIncrementedEvent.getStepEventType() == ProgressThreadIncrementedEvent.StepEventType.STEP_STARTING) {
            return;
        }
        this.updateStatus(progressThreadIncrementedEvent.getTotalSubStepsInCurrentStep(), progressThreadIncrementedEvent.getMostRecentlyCompletedSubStepIndex() + 1, progressThreadIncrementedEvent.getTimeRemainingForCurrentStep());
    }

    public void progressThreadEnded(ProgressThreadEvent progressThreadEvent) {
        ProgressThreadEndedEvent progressThreadEndedEvent = (ProgressThreadEndedEvent)progressThreadEvent;
        ProgressRunResult progressRunResult = progressThreadEndedEvent.getProgressRunResult();
        this.finish(progressRunResult.getStatus() != ProgressRunResult.Status.SUCCESS);
    }

    private String getDescriptionText(long l2, long l3) {
        String string = this.customizeDisplayInterface == null ? CmStringPool.get(this.descriptionIndex, new Object[]{new Long(l2), new Long(l3)}) : this.customizeDisplayInterface.getObjectCountDescriptionText(l2, l3);
        return string;
    }
}

