/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonFrame;
import com.ibm.db2.tools.common.CommonMessage;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.ResultProcessor;
import com.ibm.db2.tools.common.TurningGears;
import com.ibm.db2.tools.common.VariableGridLayout;
import com.ibm.db2.tools.common.smartguide.SmartGuide;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadEvent;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadListener;
import com.ibm.db2.tools.common.ui.progress.TerminateInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class BasicProgressIndicator
extends CommonDialog
implements ActionListener,
Serializable,
ResultProcessor,
ProgressThreadListener {
    protected final int MAX_MSG_LENGTH = 300;
    protected static final int MIN_TIME_BEFORE_DISPLAY = 2000;
    protected static final int FRAMES_PER_SECOND = 10;
    protected TerminateInterface terminateInterface = null;
    protected long elapsedTime;
    protected long startTime;
    protected boolean executeFlag;
    protected boolean actionPerformedOnce = false;
    protected String label;
    protected Window makeActiveOnClose = null;
    protected int timeBetweenFrames = 100;
    protected int delay = 2000;
    protected JLabel lblElapsedTime;
    protected TurningGears gears;
    protected JButton closeButton;
    protected JButton terminateButton;
    protected JLabel titlePanel = new JLabel();
    protected Vector titleMessages;
    protected CommonMessage terminationWarning;
    protected Timer timer;

    public BasicProgressIndicator(CommonDialog commonDialog, String string, boolean bl) {
        super(commonDialog, CmStringPool.get(96), bl, 0L);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "BasicProgressIndicator", this, "BasicProgressIndicator(CommonDialog dialog, String label, boolean modal)", new Object[]{commonDialog, string, new Boolean(bl)});
        }
        this.setUAWindowAdapter(null);
        super.setParentDialog(commonDialog);
        this.setBusyCursor(false);
        this.label = string;
        CommonTrace.exit(commonTrace);
    }

    public BasicProgressIndicator(JFrame jFrame, String string, boolean bl) {
        super(jFrame, CmStringPool.get(96), bl, 0L);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "BasicProgressIndicator", this, "BasicProgressIndicator(JFrame parent, String label, boolean modal)", new Object[]{jFrame, string, new Boolean(bl)});
        }
        this.setUAWindowAdapter(null);
        this.setBusyCursor(false);
        this.label = string;
        CommonTrace.exit(commonTrace);
    }

    public BasicProgressIndicator(SmartGuide smartGuide, String string, boolean bl) {
        this((JFrame)smartGuide.getParentFrame(), string, bl);
        super.setParentSmartGuide(smartGuide);
    }

    private void initialize() {
        this.startTime = new Date().getTime();
        this.setResizable(false);
        this.makeLayout();
        this.executeFlag = true;
        this.timer = new Timer(this.timeBetweenFrames, this);
        this.timer.setInitialDelay(this.delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    public void start() {
        this.initialize();
    }

    public void setDelay(int n2) {
        this.delay = n2;
    }

    public void setTerminateInterface(TerminateInterface terminateInterface) {
        this.terminateInterface = terminateInterface;
    }

    public void setProgressMessages(Vector vector) {
        this.titleMessages = vector;
        this.setDialogSize(vector);
    }

    private void setDialogSize(Vector vector) {
        FontMetrics fontMetrics = ((Component)this.titlePanel).getFontMetrics(this.getFont());
        int n2 = 0;
        int n3 = fontMetrics.stringWidth(this.getTitle());
        int n4 = 0;
        while (n4 < vector.size()) {
            int n5 = fontMetrics.stringWidth((String)vector.elementAt(n4));
            if (n5 > n2) {
                n2 = n5;
            }
            ++n4;
        }
        if (n2 > 300) {
            n2 = 300;
        }
        n2 = (n2 > n3 ? n2 : n3) * 5 / 4;
        Dimension dimension = this.titlePanel.getPreferredSize();
        this.titlePanel.setPreferredSize(new Dimension(n2, dimension.height));
    }

    public void setProgressMessage(int n2) {
        if (this.titleMessages != null) {
            this.titlePanel.setText((String)this.titleMessages.elementAt(n2));
        }
    }

    protected void makeLayout() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.closeButton = new JButton(CmStringPool.get(25));
        this.closeButton.addActionListener(this);
        jPanel2.add(this.closeButton);
        if (this.terminateInterface != null) {
            this.terminateButton = new JButton(CmStringPool.get(47));
            this.terminateButton.setMnemonic(CmStringPool.getMnemonic(47));
            this.terminateButton.addActionListener(this);
            jPanel2.add(this.terminateButton);
        }
        this.setDefaultFocusComponent(this.closeButton);
        this.gears = new TurningGears();
        if (this.label == null || this.label.length() == 0) {
            this.label = " ";
        }
        this.titlePanel.setText(this.label);
        jPanel.add("North", this.titlePanel);
        jPanel.add("Center", this.makeCenterGridPanel(this.getPanel()));
        jPanel.add("South", jPanel2);
        this.setClient(jPanel);
        this.addWindowListener(this);
    }

    protected Container makeCenterGridPanel(Container container) {
        if (container instanceof JPanel) {
            ((JPanel)container).setBorder(new EmptyBorder(0, 0, 0, 10));
        }
        container.setLayout(new VariableGridLayout(1, 2, 10, 0));
        container.add(this.makeElapsedTimeLabelPanel(this.getPanel()));
        container.add(this.gears);
        return container;
    }

    private Container makeElapsedTimeLabelPanel(Container container) {
        container.setLayout(new GridLayout(2, 1, 0, 0));
        JLabel jLabel = new JLabel(CmStringPool.get(95), 2);
        container.add(jLabel);
        this.lblElapsedTime = new JLabel(this.getStringValue(this.elapsedTime), 2);
        container.add(this.lblElapsedTime);
        return container;
    }

    private Container makeElapsedTimePanel(Container container) {
        container.setLayout(new BorderLayout());
        this.lblElapsedTime = new JLabel(this.getStringValue(this.elapsedTime), 2);
        container.add("North", this.lblElapsedTime);
        return container;
    }

    public void processResult(Object object, Object object2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "BasicProgressIndicator", this, "processResult(Object handler, Object returnValue)", new Object[]{object, object2});
        }
        if (object2.equals("Yes")) {
            this.terminationWarning.dispose();
            super.setVisible(false);
            if (this.terminateInterface != null) {
                this.terminateInterface.taskTerminated();
            }
        } else if (object2.equals("No")) {
            if (this.terminationWarning != null) {
                Graphics graphics;
                this.terminationWarning.dispose();
                super.setVisible(true);
                if (!super.isModal() && (graphics = super.getGraphics()) != null) {
                    super.paintComponents(graphics);
                }
            }
            this.setFocusTransferToParent(true);
        }
        CommonTrace.exit(commonTrace);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "BasicProgressIndicator", this, "actionPerformed(ActionEvent e)", new Object[]{actionEvent});
        }
        if (actionEvent.getSource() == this.terminateButton) {
            this.terminationWarning = new CommonMessage(this, CmStringPool.get(5), CmStringPool.get(200), 1, "", "", 16, (ResultProcessor)this, false);
        } else if (actionEvent.getSource() == this.closeButton) {
            super.setVisible(false);
            this.executeFlag = false;
            this.timer.stop();
        }
        if (this.executeFlag) {
            this.elapsedTime = new Date().getTime() - this.startTime;
            this.lblElapsedTime.setText(this.getStringValue(this.elapsedTime));
            if (this.actionPerformedOnce) {
                this.gears.advance();
                ((Container)this).paint(((Component)this).getGraphics());
            } else {
                Graphics graphics;
                this.actionPerformedOnce = true;
                super.setVisible(true);
                if (!super.isModal() && (graphics = super.getGraphics()) != null) {
                    super.paintComponents(graphics);
                }
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public String getStringValue(long l2) {
        String string = ":";
        int n2 = (int)(l2 / 1000L);
        int n3 = n2 % 3600 % 60;
        int n4 = n2 % 3600 / 60;
        int n5 = n2 / 3600;
        return new String(BasicProgressIndicator.fixWidth(n5) + string + BasicProgressIndicator.fixWidth(n4) + string + BasicProgressIndicator.fixWidth(n3));
    }

    private static String fixWidth(int n2) {
        if (n2 == 0) {
            return "00";
        }
        if (n2 < 10) {
            return "0" + n2;
        }
        return Integer.toString(n2);
    }

    public void windowOpened(WindowEvent windowEvent) {
        if (this.timer != null) {
            this.timer.setInitialDelay(0);
            this.timer.setRepeats(true);
            this.timer.restart();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "BasicProgressIndicator", this, "windowClosing(WindowEvent e)", new Object[]{windowEvent});
        }
        super.windowClosing(windowEvent);
        this.executeFlag = false;
        this.pressClose();
        CommonTrace.exit(commonTrace);
    }

    public void pressClose() {
        this.executeFlag = false;
        this.shutdown();
    }

    public void stop() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "BasicProgressIndicator", this, "stop()");
        }
        this.executeFlag = false;
        this.dispatchEvent(new WindowEvent(this, 201));
        CommonTrace.exit(commonTrace);
    }

    public void shutdown() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "BasicProgressIndicator", this, "shutdown()");
        }
        Component component = this.getFocusOwner();
        super.setVisible(false);
        this.executeFlag = false;
        if (this.timer != null) {
            this.timer.stop();
        }
        if (super.getParentDialog() != null) {
            super.getParentDialog().progressWindowStop();
        } else if (super.getParentFrame() instanceof CommonFrame) {
            ((CommonFrame)super.getParentFrame()).progressWindowStop();
        }
        if (this.makeActiveOnClose != null && component != null && this.makeActiveOnClose.isShowing()) {
            this.makeActiveOnClose.toFront();
            this.makeActiveOnClose = null;
        }
        this.dispose();
        if (null != this.terminationWarning) {
            this.terminationWarning.dispose();
            this.terminationWarning = null;
        }
        this.gears = null;
        this.timer = null;
        super.setParentDialog(null);
        CommonTrace.exit(commonTrace);
    }

    public void suspend() {
        super.setVisible(false);
        this.executeFlag = false;
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void resume() {
        this.startTime = new Date().getTime();
        this.elapsedTime = new Date().getTime() - this.startTime;
        this.actionPerformedOnce = false;
        this.executeFlag = true;
        if (this.timer != null) {
            this.timer.restart();
        }
    }

    public boolean suspended() {
        return !this.timer.isRunning();
    }

    public void setBringToFrontOnClose(Window window) {
        this.makeActiveOnClose = window;
    }

    public void progressThreadStarted(ProgressThreadEvent progressThreadEvent) {
        this.start();
    }

    public void progressThreadIncremented(ProgressThreadEvent progressThreadEvent) {
    }

    public void progressThreadEnded(ProgressThreadEvent progressThreadEvent) {
        this.stop();
        this.dispose();
    }
}

