/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.ui.progress;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonFrame;
import com.ibm.db2.tools.common.CommonMessage;
import com.ibm.db2.tools.common.ResultProcessor;
import com.ibm.db2.tools.common.TurningGears;
import com.ibm.db2.tools.common.UIButtonbarLayout;
import com.ibm.db2.tools.common.ui.progress.ProgressTaskInterface;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadEvent;
import com.ibm.db2.tools.common.ui.progress.ProgressThreadListener;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class AbstractProgressIndicator
extends CommonFrame
implements ProgressThreadListener,
ResultProcessor {
    public static final int TASK_COMPLETED_SUCCESS = 0;
    public static final int TASK_COMPLETED_NON_CRITICAL_ERROR = 1;
    public static final int TASK_COMPLETED_CRITICAL_ERROR = 2;
    protected ProgressTaskInterface task;
    protected boolean showStopButton = false;
    protected boolean showCancelButton = false;
    protected boolean showCloseOption = true;
    protected TurningGears gears = null;
    protected ImageIcon image = null;
    protected JButton stopButton;
    protected JButton cancelButton;
    protected JButton closeButton;
    protected String bannerText = "";
    protected JCheckBox checkBtnClose;
    protected boolean taskFinished = false;

    protected static String parseTime(int n2, long l2, int n3, int n4, int n5, int n6, int n7) {
        String string;
        if (l2 == -1L) {
            l2 = 59000L;
        } else if (0L < l2 && l2 < 400L) {
            l2 = 1000L;
        } else if (l2 % 1000L >= 400L) {
            l2 += 1000L;
        }
        int n8 = (int)(l2 / 1000L);
        int n9 = n8 / 3600;
        int n10 = n8 % 3600 / 60;
        int n11 = n8 % 3600 % 60;
        if (n9 == 0 && n10 == 0 && n11 <= 10) {
            Object[] objectArray;
            if (n2 == -1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = new Integer(n11);
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = new Integer(n2);
                objectArray = objectArray3;
                objectArray3[1] = new Integer(n11);
            }
            string = CmStringPool.get(n3, objectArray);
        } else if (n9 == 0 && n10 == 0) {
            string = n2 == -1 ? CmStringPool.get(n4) : CmStringPool.get(n4, new Integer(n2));
        } else if (n9 == 0 && n10 < 50) {
            Object[] objectArray;
            if (n2 == -1) {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = new Integer(n10);
            } else {
                Object[] objectArray5 = new Object[2];
                objectArray5[0] = new Integer(n2);
                objectArray = objectArray5;
                objectArray5[1] = new Integer(n10);
            }
            string = CmStringPool.get(n5, objectArray);
        } else if (n10 <= 10 || n10 >= 50) {
            Object[] objectArray;
            int n12 = n9 = n10 <= 10 ? n9 : n9 + 1;
            if (n2 == -1) {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = new Integer(n9);
            } else {
                Object[] objectArray7 = new Object[2];
                objectArray7[0] = new Integer(n2);
                objectArray = objectArray7;
                objectArray7[1] = new Integer(n9);
            }
            string = CmStringPool.get(n6, objectArray);
        } else {
            Object[] objectArray;
            Integer n13 = new Integer(n9);
            Integer n14 = new Integer(n10);
            if (n2 == -1) {
                Object[] objectArray8 = new Object[2];
                objectArray8[0] = n13;
                objectArray = objectArray8;
                objectArray8[1] = n14;
            } else {
                Object[] objectArray9 = new Object[2];
                objectArray9[0] = new Integer(n2);
                objectArray = objectArray9;
                objectArray9[1] = new Integer(n9);
            }
            string = CmStringPool.get(n7, objectArray);
        }
        return string;
    }

    public AbstractProgressIndicator(JFrame jFrame, String string, ProgressTaskInterface progressTaskInterface) {
        super(string, jFrame, false);
        this.initialize(progressTaskInterface);
    }

    public AbstractProgressIndicator(CommonDialog commonDialog, String string, ProgressTaskInterface progressTaskInterface) {
        super(string, commonDialog, false);
        this.initialize(progressTaskInterface);
    }

    private void setButtons(long l2) {
        if ((l2 & 4L) != 0L) {
            this.showCancelButton();
        }
    }

    protected void initialize(ProgressTaskInterface progressTaskInterface) {
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.task = progressTaskInterface;
        this.addWindowListener(new WindowEventHandler());
    }

    public void showStopButton() {
        this.showStopButton = true;
    }

    public void showCancelButton() {
        this.showCancelButton = true;
    }

    public void showAnimation() {
        this.gears = new TurningGears();
    }

    public void showImage(ImageIcon imageIcon) {
        this.image = imageIcon;
    }

    public void showBannerText(String string) {
        this.bannerText = string;
    }

    public void showCloseOption(boolean bl) {
        this.showCloseOption = bl;
    }

    protected void makeLayout() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        jPanel.add((Component)this.makeNorthPanel(), "North");
        jPanel.add((Component)this.makeProgressPanel(), "Center");
        jPanel.add((Component)this.makeButtonPanel(), "South");
        this.setClient(jPanel);
    }

    protected JPanel makeNorthPanel() {
        JPanel jPanel = new JPanel();
        if (this.gears != null) {
            jPanel.add(this.gears);
        } else if (this.image != null) {
            jPanel.add(new JLabel(this.image));
        } else if (this.bannerText.length() > 0) {
            jPanel.setLayout(new FlowLayout(0, 5, 1));
            jPanel.add(new JLabel(this.bannerText));
        }
        return jPanel;
    }

    protected abstract JPanel makeProgressPanel();

    protected JPanel makeButtonPanel() {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(new EmptyBorder(3, 3, 3, 3));
        if (this.showCloseOption) {
            jPanel = new JPanel(new FlowLayout(0, 0, 0));
            this.checkBtnClose = new JCheckBox(CmStringPool.get(302));
            jPanel.add(this.checkBtnClose);
            jPanel2.add(jPanel);
        }
        jPanel = new JPanel(new UIButtonbarLayout());
        if (this.showStopButton) {
            this.stopButton = new JButton(CmStringPool.get(267));
            this.stopButton.setMnemonic(CmStringPool.getMnemonic(267));
            this.stopButton.addActionListener(this);
            jPanel.add(this.stopButton);
        } else if (this.showCancelButton) {
            this.cancelButton = new JButton(CmStringPool.get(24));
            jPanel.add(this.cancelButton);
            this.cancelButton.putClientProperty("UAKey", "CM_UD_BVCANCEL");
            this.cancelButton.addActionListener(this);
        }
        this.closeButton = new JButton(CmStringPool.get(25));
        jPanel.add(this.closeButton);
        this.closeButton.putClientProperty("UAKey", "CM_UD_BVCLOSE");
        jPanel.add(this.closeButton);
        this.closeButton.setEnabled(false);
        this.closeButton.addActionListener(this);
        this.registerKeyboardAction(this, "Escape", 27);
        jPanel2.add(jPanel);
        return jPanel2;
    }

    public void start() {
        this.makeLayout();
        this.pack();
        this.setVisible(true);
    }

    public void update() {
        if (this.gears != null) {
            this.gears.advance();
            this.gears.repaint();
        }
    }

    public void finish(boolean bl) {
        this.taskFinished = true;
        if (this.checkBtnClose.isSelected()) {
            this.close(false);
        } else {
            if (bl) {
                this.checkBtnClose.setEnabled(false);
                this.closeButton.setEnabled(true);
            } else {
                this.checkBtnClose.setVisible(false);
                this.closeButton.setEnabled(true);
            }
            if (this.cancelButton != null) {
                this.cancelButton.setEnabled(false);
            } else if (this.stopButton != null) {
                this.stopButton.setEnabled(false);
            }
        }
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean bl) {
        if (bl && !this.taskFinished) {
            CommonMessage commonMessage = new CommonMessage(this, CmStringPool.get(5), CmStringPool.get(285), 1, "", "", 16, (ResultProcessor)this, false);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.task.taskCancelled();
        } else if (actionEvent.getSource() == this.closeButton) {
            this.close(false);
        } else if (actionEvent.getSource() == this.stopButton) {
            this.task.taskStopped();
        }
    }

    public void progressThreadStarted(ProgressThreadEvent progressThreadEvent) {
        this.start();
    }

    public abstract void progressThreadIncremented(ProgressThreadEvent var1);

    public void progressThreadEnded(ProgressThreadEvent progressThreadEvent) {
    }

    public void processResult(Object object, Object object2) {
        if (object2.equals("Yes")) {
            ((CommonMessage)object).dispose();
            this.setVisible(false);
            this.dispose();
        } else if (object2.equals("No")) {
            ((CommonMessage)object).dispose();
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            AbstractProgressIndicator.this.close(true);
        }
    }
}

