/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.uamanager;

import com.ibm.db2.tools.common.support.CUtil;
import com.ibm.db2.tools.common.uamanager.UAMException;
import com.ibm.db2.tools.common.uamanager.UAManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class UAMapFactory
implements Runnable {
    private static boolean DEBUG = false;
    static final String NAME = "UAMapFactory";
    static UAMapFactory singleLoader;
    public static Hashtable compiledMap;
    public static Hashtable[] compiledMapArray;
    static Vector threads;
    static Vector names;
    static String[] startupArr;
    static Vector errorVect;
    static int ia;
    static int ai;
    static Class thisAsStatic;
    public static String preprocessedSuffix;
    public static Properties props;

    private UAMapFactory() {
    }

    public UAMapFactory(GZIPInputStream gZIPInputStream) throws UAMException {
        try {
            compiledMap = (Hashtable)new ObjectInputStream(gZIPInputStream).readObject();
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new UAMException(NAME, "UA Error: UAMapFactory()threw a stream corrupted exception while reading the compiled map.");
        }
        catch (IOException iOException) {
            throw new UAMException(NAME, "UA Error: UAMapFactory()threw an I/O exception while reading the compiled map.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UAMException(NAME, "UA Error: UAMapFactory() threw an class not found exception while reading the compiled map.");
        }
    }

    public UAMapFactory(String string) throws UAMException {
        File file = UAMapFactory.fetchMapFile(string);
        new UAMapFactory(file);
        UAMapFactory.cleanupPreprocessedMapFile(file);
    }

    public UAMapFactory(String string, String[] stringArray) throws UAMException {
        File file = UAMapFactory.fetchMapFile(string);
        new UAMapFactory(file, stringArray);
        UAMapFactory.cleanupPreprocessedMapFile(file);
    }

    public UAMapFactory(File file, String[] stringArray) throws UAMException {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (DEBUG) {
                System.out.println("package name: " + stringArray[n2]);
                System.out.println("the file: " + file);
            }
            ++n2;
        }
        compiledMapArray = this.buildCompiledMap(this.readMap(file), stringArray);
    }

    public UAMapFactory(File file) throws UAMException {
        compiledMap = this.buildCompiledMap(this.readMap(file));
        if (DEBUG) {
            System.out.println("compiledMap: " + compiledMap);
        }
    }

    private boolean isCustomEntry(String string) {
        boolean bl = true;
        String string2 = "";
        String string3 = "";
        if (string.indexOf("=") != -1) {
            string3 = string.substring(0, string.indexOf("="));
        }
        string2 = UAManager.generatePropertyFromKey(string3);
        char[] cArray = System.getProperty("file.separator").toCharArray();
        if (cArray.length == 1) {
            string2 = UAManager.setDirs(string2, cArray[0]);
            string = UAManager.setDirs(string, cArray[0]);
        }
        bl = !string2.equals(string);
        return bl;
    }

    private String readMap(File file) throws UAMException {
        String string = "";
        String string2 = "";
        try {
            boolean bl;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 8192);
            string = bufferedReader.readLine();
            int n2 = 0;
            boolean bl2 = false;
            int n3 = 1;
            while (string != null) {
                if (++n2 > 500 * n3 - 1) {
                    if (DEBUG) {
                        System.out.println("Compiling: Read " + n2 + " lines");
                    }
                    ++n3;
                }
                boolean bl3 = false;
                if (string.startsWith("//")) {
                    bl3 = true;
                }
                boolean bl4 = bl = string.length() > 10 && !string.equals(" ") && !string.equals("\n") && !string.equals("\r\n") && !string.equals(" \n") && !string.equals(" \r\n") && string.indexOf("<") == -1;
                if (DEBUG) {
                    System.out.println("Ln. " + n2 + " " + !bl3 + " " + bl + " " + this.isCustomEntry(string));
                }
                if (!bl3 && bl && this.isCustomEntry(string)) {
                    bl2 += 1;
                    string2 = string2 + "\n" + string;
                }
                string = bufferedReader.readLine();
            }
            if (DEBUG) {
                System.out.println("Read " + n2 + " lines from map");
                System.out.println("Map factory received " + (int)(bl2 ? 1 : 0) + " potential entries.");
            }
            String string3 = string2;
            bl = false;
            while (string3.lastIndexOf("\n") != -1) {
                bl += 1;
                string3 = string3.substring(0, string3.lastIndexOf("\n"));
            }
            if (DEBUG) {
                System.out.println("Map factory evaluating " + (int)(bl ? 1 : 0) + " potential entries.");
            }
            if (bl2 == bl) {
                System.out.println((int)(bl ? 1 : 0) + " potential entries validated.");
            } else {
                UAMapFactory.logMapError("Potential entries failed validation.");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UAMException(NAME, "UA Error: UAMapFactory.readMap()threw an file not found exception while reading the file: " + file);
        }
        catch (IOException iOException) {
            throw new UAMException(NAME, "UA Error: UAMapFactory.readMap()threw an I/O exception while reading the file.");
        }
        catch (SecurityException securityException) {
            throw new UAMException(NAME, "UA Error: UAMapFactory.readMap()threw a security exception  while reading the file.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UAMException(NAME, "UA Error: UAMapFactory.readMap()received invalid arguments for reading the file.");
        }
        return string2;
    }

    public static synchronized Thread getLoader() {
        if (singleLoader == null) {
            singleLoader = new UAMapFactory();
        }
        return new Thread(singleLoader);
    }

    public Hashtable[] buildCompiledMap(String string, String[] stringArray) {
        int n2;
        boolean bl;
        int n3;
        if (DEBUG) {
            System.out.println("-compiling multiple maps-");
        }
        StringTokenizer stringTokenizer = this.tokenizeMap(string, stringArray);
        Hashtable[] hashtableArray = new Hashtable[stringArray.length];
        if (DEBUG) {
            System.out.println("Building " + stringArray.length + " Map objects");
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(stringArray.length);
        int n4 = 0;
        while (n4 < stringArray.length) {
            hashtableArray[n4] = new Hashtable();
            System.out.println(n4 + ": Built " + stringArray[n4] + " object");
            hashtable.put(stringArray[n4], new Integer(0));
            ++n4;
        }
        int n5 = 1;
        int n6 = stringTokenizer.countTokens() / 2;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl2 = true;
        String string2 = "";
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            try {
                string2 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                UAMapFactory.logMapError("The map was imbalanced and had orphaned entries.The gz files should not be used");
                System.out.println(this.reportMapErrors());
            }
            n3 = 0;
            while (n3 < stringArray.length) {
                if (string2.indexOf(".htm") != -1) {
                    UAMapFactory.logMapError("The following key and value contain an error:\n\tkey: " + string2 + "\n\tvalue: " + string3 + "The map is not valid, " + "unless the ID is supposed to contain the string," + "\".htm\"");
                }
                if (string2.indexOf(".") == -1) {
                    if (string2.equals(stringArray[n3])) {
                        hashtableArray[n3].put(string2, string3);
                        ++n9;
                        bl2 = false;
                    } else {
                        bl = false;
                        while (bl < startupArr.length) {
                            if (string2.trim().equals(startupArr[bl].trim())) {
                                if (DEBUG) {
                                    System.out.println("Add startup key:value[" + string2.trim() + ":" + string3.trim() + "]");
                                }
                                hashtableArray[n3].put(string2.trim(), string3.trim());
                                ++n9;
                                bl2 = false;
                            }
                            bl += 1;
                        }
                    }
                } else if (string2.startsWith(stringArray[n3])) {
                    if (DEBUG) {
                        System.out.println("Populating:" + stringArray[n3]);
                        System.out.println("\tkey:" + string2);
                        System.out.println("\tvalue:" + string3);
                    }
                    hashtableArray[n3].put(string2, string3);
                    bl = ((Integer)hashtable.get(stringArray[n3])).intValue();
                    hashtable.put(stringArray[n3], new Integer((bl += 1) ? 1 : 0));
                    ++n8;
                    bl2 = false;
                }
                ++n3;
            }
            if (DEBUG) {
                System.out.println("\nHandled " + (n5 - 1) + "\\" + n6);
            }
            if (bl2) {
                UAMapFactory.logMapError("The following key and value contains an error:\n\tkey: " + string2 + "\n\tvalue: " + string3);
            }
            if (++n5 - n8 <= n7 || (n7 = n5 - n8) <= stringArray.length + startupArr.length || stringArray.length <= 1 || !DEBUG) continue;
            UAMapFactory.logMapError("The following key and value pair was not added to a map object:\n\tkey: " + string2 + "\n\tvalue: " + string3);
        }
        n3 = stringArray.length + startupArr.length;
        if (n7 > stringArray.length + startupArr.length && stringArray.length > 1) {
            UAMapFactory.logMapError("The text-file map contains  entries that were not added to a map object. Use the debug option to trace the error.");
        }
        System.out.println("Entries evaluated: " + (n5 - 1) + " of " + n6);
        System.out.println("Number of packages specified: " + stringArray.length);
        System.out.println("Number of startup settings: " + startupArr.length);
        System.out.println("Number of entries that are not UA entries: " + n3);
        System.out.println("Startup settings handled: " + n9);
        bl = n9 == (startupArr.length + 1) * stringArray.length - 1;
        System.out.println("Validate startup settings: " + bl);
        System.out.println("Total evaluated minus startup settings and packages names: " + (n5 - 1 - n3));
        System.out.println("package name and startup entries added to compiled maps: " + n3);
        System.out.println("custom entries added to compiled maps: " + n8);
        Enumeration enumeration = hashtable.keys();
        Enumeration enumeration2 = hashtable.elements();
        int n10 = 0;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            n2 = (Integer)enumeration2.nextElement();
            System.out.println("Put " + n2 + " in the " + enumeration.nextElement() + " map object.");
            n10 += n2;
        }
        if (n9 < startupArr.length) {
            UAMapFactory.logMapError("Missing one or more startup entries.cannot validate entries.");
        } else {
            System.out.println(n8 + " added to " + stringArray.length + " map(s)");
        }
        n2 = n10 == n8 ? 1 : 0;
        System.out.println("Validate custom settings: " + (n2 != 0));
        if (n2 != 0 && bl) {
            System.out.println("Map passed validation.");
        } else {
            System.out.println("Map failed validation.");
        }
        System.out.println("Important: Use the read option to validate each map.\n");
        System.out.println("-finished compiling map-");
        return hashtableArray;
    }

    private static void logMapError(String string) {
        errorVect.addElement("Error: " + string);
    }

    private String reportMapErrors() {
        String string = "-Map Factory report-\n";
        errorVect.trimToSize();
        if (errorVect.size() == 0) {
            return "0 errors reported";
        }
        Enumeration enumeration = errorVect.elements();
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            string2 = string2 + enumeration.nextElement() + "\n";
        }
        errorVect.trimToSize();
        String string3 = string + errorVect.size() + " error(s)\n" + string2 + "END REPORT\n" + errorVect.size() + " error(s) reported";
        return string3;
    }

    private StringTokenizer tokenizeMap(String string, String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=\r\n");
        System.out.println("-Found " + stringTokenizer.countTokens() / 2 + " custom entries-");
        System.out.println("-Raw map contains " + stringTokenizer.countTokens() % 2 + " orphaned entries-");
        return stringTokenizer;
    }

    public Hashtable buildCompiledMap(String string) {
        System.out.println("-compiling map-");
        StringTokenizer stringTokenizer = this.tokenizeMap(string, null);
        Hashtable<String, String> hashtable = new Hashtable<String, String>(stringTokenizer.countTokens());
        int n2 = 1;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                hashtable.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {
                UAMapFactory.logMapError("The map file in umbalanced. Check for human-introduced errors, such as unsupported multiline comments.");
                this.reportMapErrors();
            }
            System.out.println("Put " + n2 + " entries in the map");
            ++n2;
        }
        System.out.println("-finished compiling map-");
        return hashtable;
    }

    public Hashtable[] getMultiMap() {
        return compiledMapArray;
    }

    public Hashtable getCompiledMap() {
        return compiledMap;
    }

    public void compressAndSave(Hashtable hashtable, String string) throws UAMException {
        String string2;
        if (DEBUG) {
            System.out.println("-Saving map object(s)");
        }
        String string3 = System.getProperty("file.separator");
        if (DEBUG) {
            System.out.println("\tUsing '" + string3 + "' as file separator.");
        }
        if ((string2 = "." + string3 + "uamanager" + string3 + string) != null) {
            try {
                if (DEBUG) {
                    System.out.println("-Open output stream-");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(new File(string2 + "map.gz"));
                if (DEBUG) {
                    System.out.println("-Open zip stream-");
                }
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
                if (DEBUG) {
                    System.out.println("-Open object output stream-");
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
                if (DEBUG) {
                    System.out.println("-write zipped map-");
                }
                objectOutputStream.writeObject(hashtable);
                objectOutputStream.flush();
                objectOutputStream.close();
                if (DEBUG) {
                    System.out.println("-close output streams-");
                }
                if (new File(string2 + "map.gz").exists()) {
                    System.out.println("-Map saved: " + string2 + "map.gz-");
                } else {
                    UAMapFactory.logMapError("The compiled map file was not saved in " + string2 + "map.gz");
                }
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new UAMException(NAME, "UA Error: UAMapFactory.compressAndSave()threw an I/O exception while saving the compiled map for " + string + ".");
            }
        }
        System.out.println("-Map not saved-");
    }

    public static Class getThisAsStatic() {
        try {
            thisAsStatic = Class.forName("uamanager.UAMapFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
        return thisAsStatic;
    }

    public static void intializeMaps(String string) {
        UAMapFactory.intializeMaps(new StringTokenizer(string));
    }

    public static synchronized void intializeMaps(StringTokenizer stringTokenizer) {
        Object object;
        int n2 = stringTokenizer.countTokens();
        threads = new Vector(n2);
        names = new Vector(n2);
        while (stringTokenizer.hasMoreTokens()) {
            threads.addElement(UAMapFactory.getLoader());
            object = stringTokenizer.nextToken();
            System.out.println("add PackageName:" + (String)object);
            names.addElement(object);
        }
        object = UAMapFactory.getThisAsStatic();
        synchronized (object) {
            while (ia < threads.size()) {
                String string = (String)names.elementAt(ia);
                System.out.println("get PackageName[" + ia + "]" + string);
                System.out.println("Starting thread for " + string);
                try {
                    ((Thread)threads.elementAt(ia)).start();
                    ((Thread)threads.elementAt(ia)).setPriority(3);
                }
                catch (Throwable throwable) {
                    UAMapFactory.logMapError("The \"" + string + "\" map doesn;t compile cleanly due to: " + throwable.toString());
                }
                ++ia;
            }
        }
    }

    public void run() {
        try {
            UAManager.preLoadMap((String)names.elementAt(ai++));
        }
        catch (UAMException uAMException) {
            uAMException.printStackTrace();
        }
    }

    static int psuedoHashCode(char[] cArray) {
        int n2 = 0;
        int n3 = 0;
        char[] cArray2 = cArray;
        int n4 = cArray.length;
        if (n4 < 16) {
            int n5 = n4;
            while (n5 > 0) {
                n2 = n2 * 37 + cArray2[n3++];
                --n5;
            }
        } else {
            int n6 = n4 / 8;
            int n7 = n4;
            while (n7 > 0) {
                n2 = n2 * 39 + cArray2[n3];
                n7 -= n6;
                n3 += n6;
            }
        }
        return n2;
    }

    public static File fetchMapFile(String string) {
        String string2 = UAMapFactory.fetchPreprocessPropertyFile();
        File file = null;
        if (string2 != null && string2 != "") {
            try {
                props.load(new FileInputStream(string2));
                file = UAMapFactory.createPreprocessedMapFile(string);
            }
            catch (Exception exception) {
                file = new File(string);
            }
        } else {
            file = new File(string);
        }
        return file;
    }

    public static void cleanupPreprocessedMapFile(File file) {
        try {
            if (file.getAbsolutePath().endsWith(preprocessedSuffix)) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String fetchPreprocessPropertyFile() {
        String string = CUtil.getEnvironmentVariableValue("PPMAP_FILES");
        return string == null ? "" : string.trim();
    }

    public static File createPreprocessedMapFile(String string) {
        File file = null;
        try {
            if (((Hashtable)props).size() != 0) {
                String string2 = string;
                String string3 = string + preprocessedSuffix;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string3, false));
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    String string5 = UAMapFactory.preprocessString(string4);
                    bufferedWriter.write(string5, 0, string5.length());
                    bufferedWriter.newLine();
                    string4 = bufferedReader.readLine();
                }
                bufferedReader.close();
                bufferedWriter.flush();
                bufferedWriter.close();
                file = new File(string3);
            } else {
                System.out.println("Property hashtable empty: did not process mapFile");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file;
    }

    public static String preprocessString(String string) {
        String string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.countTokens() == 2) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken().replace('\\', '/');
            String string5 = string3.toLowerCase();
            if (string3.indexOf(".windowUA.") > -1 || string5.indexOf("helpmenu") > -1 && string5.indexOf("ip.htm") == -1) {
                try {
                    stringTokenizer = new StringTokenizer(string4, "/");
                    String string6 = stringTokenizer.nextToken();
                    if (props.getProperty(string6.toLowerCase()) != null) {
                        String string7 = string3 + "=" + props.getProperty(string6.toLowerCase()) + string6 + "/";
                        String string8 = string4.substring(string4.indexOf("/") + 1, string4.length());
                        string2 = string7 + string8;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        UAMapFactory uAMapFactory = null;
        try {
            int n2 = UAMapFactory.psuedoHashCode(stringArray[0].toCharArray());
            if (n2 == -981818584) {
                DEBUG = true;
                n2 = -964127032;
            }
            switch (n2) {
                case 89747534: {
                    System.out.println("Valid commands:");
                    System.out.println("To show help:");
                    System.out.println("\tjava uamanager.UAMapFactory -help");
                    System.out.println("To compile a map from multiple packages:");
                    System.out.println("\tjava uamanager.UAMapFactory -multi whole.map pack1 ... packN");
                    System.out.println("\twhere whole.map represents the name of the map file,");
                    System.out.println("\twhere pack1 ... packN represents the package names,");
                    System.out.println("\tfor example \"common navigator db2_390 sg\"");
                    System.out.println("To test preloading of compiled maps:");
                    System.out.println("\tjava uamanager.UAMapFactory -preload pack1");
                    System.out.println("\twhere pack1 represents the package name,");
                    System.out.println("\tfor example \"db2_390\"");
                    System.out.println("To test reading of compiled maps:");
                    System.out.println("\tjava uamanager.UAMapFactory -read pack1map.gz");
                    System.out.println("\twhere pack1map.gz represents the compiled map file name,");
                    System.out.println("\tfor example \"db2_390\"");
                    System.out.println("To a build a single compiled map named uamanagermap.gz:");
                    System.out.println("\tjava uamanager.UAMapFactory UAManager.map");
                    System.out.println("\twhere UAManager.map represents the map file name");
                    System.out.println("To preprocess a map file named Original.map into a file Processed.map");
                    System.out.println("\tjava uamanager.UAMapFactory -preprocess Original.map Processed.map");
                    break;
                }
                case -964127032: {
                    String[] stringArray2 = new String[stringArray.length - 2];
                    int n3 = 0;
                    int n4 = 2;
                    while (n4 < stringArray.length) {
                        stringArray2[n3] = stringArray[n4];
                        System.out.println("packageArr[" + n3 + "]=" + stringArray[n4]);
                        ++n3;
                        ++n4;
                    }
                    uAMapFactory = new UAMapFactory(stringArray[1], stringArray2);
                    Hashtable[] hashtableArray = uAMapFactory.getMultiMap();
                    int n5 = 0;
                    while (n5 < hashtableArray.length) {
                        if (DEBUG) {
                            System.out.println("GZ contains: " + hashtableArray[n5].toString());
                        }
                        if (DEBUG) {
                            System.out.println("-Save " + stringArray2[n5]);
                        }
                        uAMapFactory.compressAndSave(hashtableArray[n5], stringArray2[n5]);
                        ++n5;
                    }
                    System.out.println(uAMapFactory.reportMapErrors());
                    System.exit(0);
                    break;
                }
                case -919304285: {
                    if (DEBUG) {
                        System.out.println("-Building map compiler for " + stringArray[1]);
                        System.out.println("-with output name" + stringArray[2]);
                    }
                    uAMapFactory = new UAMapFactory(stringArray[1]);
                    Hashtable hashtable = uAMapFactory.getCompiledMap();
                    uAMapFactory.compressAndSave(hashtable, stringArray[2]);
                    System.out.println(uAMapFactory.reportMapErrors());
                    System.exit(0);
                    break;
                }
                case 1845720676: {
                    Thread thread = UAMapFactory.getLoader();
                    names = new Vector();
                    names.addElement(stringArray[1]);
                    thread.setName("PRELOAD_UAMAP");
                    thread.start();
                    break;
                }
                case 90253645: {
                    FileInputStream fileInputStream = null;
                    try {
                        System.out.println("Read serialized map: " + stringArray[1]);
                        fileInputStream = new FileInputStream(stringArray[1]);
                        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
                        System.out.println(gZIPInputStream);
                        uAMapFactory = new UAMapFactory(gZIPInputStream);
                        System.out.println(uAMapFactory.toString());
                        Hashtable hashtable = uAMapFactory.getCompiledMap();
                        System.out.println(hashtable.toString());
                        break;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                        throw new UAMException(NAME, "UA Error: UAMapFactory.main()threw a file not foundexception while reading the map file.");
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        throw new UAMException(NAME, "UA Error: UAMapFactory.main()threw an I/Oexception while reading the map file.");
                    }
                }
                case 348635255: {
                    if (stringArray.length < 3) {
                        System.out.println("Arguments for '-preprocess' are Original.map Processed.map");
                        break;
                    }
                    try {
                        File file = UAMapFactory.fetchMapFile(stringArray[1]);
                        File file2 = new File(stringArray[2]);
                        file.renameTo(file2);
                        System.out.println("PreProcessed " + stringArray[1] + " into " + stringArray[2]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                default: {
                    System.out.println("-Building map compiler for " + stringArray[0]);
                    uAMapFactory = new UAMapFactory(stringArray[0]);
                    Hashtable hashtable = uAMapFactory.getCompiledMap();
                    uAMapFactory.compressAndSave(hashtable, "uamanager");
                    System.out.println(uAMapFactory.reportMapErrors());
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (uAMapFactory != null) {
                System.out.println(super.reportMapErrors());
            }
            System.exit(99);
        }
    }

    static {
        startupArr = new String[]{"buildMyMap", "diagnoseMyHelpErrors", "exactContextSensitivity", "useCompiledMap", "recoverFromUAError"};
        errorVect = new Vector();
        ia = 0;
        ai = 0;
        preprocessedSuffix = ".preprocess";
        props = new Properties();
    }
}

