/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.uamanager;

import com.ibm.db2.tools.common.uamanager.HelpManager;
import com.ibm.db2.tools.common.uamanager.UAImplementation;
import com.ibm.db2.tools.common.uamanager.UAInstance;
import com.ibm.db2.tools.common.uamanager.UAManager;
import com.ibm.db2.tools.common.uamanager.UAWindowAdapter;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JApplet;

public class UAMCustomizerWindowAdapter
extends UAWindowAdapter {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String installDir;
    protected String dirUnderInstall;
    protected String ipBaseDir;
    protected String mapDir;
    protected String baseHelpDir;
    protected String uamToken;
    static UAInstance theAppletGetter = UAImplementation.getImplementation();
    protected boolean ipPolicy = true;
    private boolean postconditions = false;
    private boolean winOpened = false;
    private boolean winActivated = false;
    private boolean winClosing = false;

    public UAMCustomizerWindowAdapter(String string) {
        String string2 = this.getLang();
        String string3 = "../infopop";
        String string4 = ".";
        String string5 = "/uamanager/";
        String string6 = "/" + string2 + "/";
        String string7 = System.getProperty("user.dir") + "/../doc/prodcd/" + string2 + "/db2help/";
        this.setToken(string);
        this.setDefaultDirectories(string3, string4, string6, string5, string7);
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.setUAMDirectories(windowEvent.getWindow());
        this.winActivated = true;
        if (this.winOpened && UAManager.getSingleton() != null) {
            UAManager.getSingleton();
            UAManager.setShowTheHelp(this.ipPolicy, windowEvent.getWindow());
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (!this.winClosing && this.winOpened && UAManager.getSingleton() != null) {
            UAManager.getSingleton();
            UAManager.setShowTheHelp(false, null);
            this.winClosing = true;
        }
        UAImplementation.getImplementation().cleanupHelpInstance();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        if ((this.winActivated || this.winOpened) && UAManager.getSingleton() != null) {
            UAManager.getSingleton();
            UAManager.setShowTheHelp(false, null);
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.winOpened = true;
        this.winClosing = false;
        JApplet jApplet = theAppletGetter.getApplet();
        try {
            UAManager.setApplet(jApplet);
        }
        catch (NullPointerException nullPointerException) {
            UAManager.setApplet(jApplet);
        }
        if (UAManager.getSingleton() != null) {
            this.setUAMDirectories(windowEvent.getWindow());
            UAManager.setShowTheHelp(this.ipPolicy, windowEvent.getWindow());
            UAManager.getSingleton();
            UAManager.registerWithUAManager(windowEvent.getWindow());
        } else if (UAManager.isRegThreadAlive()) {
            while (UAManager.getSingleton() == null) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    System.out.println("UAMCustomizerWindowAdapter: thread interrupted");
                }
            }
            this.setUAMDirectories(windowEvent.getWindow());
            UAManager.getSingleton();
            UAManager.registerWithUAManager(windowEvent.getWindow());
        } else {
            String string;
            UAManager.setInstallDir(this.installDir);
            UAManager.setDirUnderInstall(this.dirUnderInstall);
            UAManager.setMapDir(this.mapDir);
            UAManager.setIPBaseDir(this.ipBaseDir);
            File file = new File(this.baseHelpDir);
            try {
                string = file.toURL().toExternalForm();
            }
            catch (Exception exception) {
                string = this.baseHelpDir;
            }
            UAManager.getSingleton();
            UAManager.setBaseHelpDir(string);
            if (this.uamToken != null && this.uamToken != "") {
                UAManager.setPackageToken(this.uamToken);
                UAManager.setPackageToken(this.uamToken, windowEvent.getWindow());
            }
            UAManager.setShowTheHelp(this.ipPolicy, windowEvent.getWindow());
            UAManager.registerWithUAManager(windowEvent.getWindow());
        }
    }

    protected void setUAMDirectories(Window window) {
        if (UAManager.getSingleton() != null) {
            String string;
            UAManager.getSingleton();
            UAManager.setInstallDir(this.installDir);
            UAManager.getSingleton();
            UAManager.setDirUnderInstall(this.dirUnderInstall);
            UAManager.getSingleton();
            UAManager.setMapDir(this.mapDir);
            UAManager.getSingleton();
            UAManager.setIPBaseDir(this.ipBaseDir);
            File file = new File(this.baseHelpDir);
            try {
                string = file.toURL().toExternalForm();
            }
            catch (Exception exception) {
                string = this.baseHelpDir;
            }
            UAManager.getSingleton();
            UAManager.setBaseHelpDir(string);
            if (this.uamToken != null && this.uamToken != "") {
                UAManager.getSingleton();
                UAManager.setPackageToken(this.uamToken);
                UAManager.getSingleton();
                UAManager.setPackageToken(this.uamToken, window);
            }
        }
    }

    public void setIPPolicy(boolean bl) {
        this.ipPolicy = bl;
    }

    protected void verifyDefaultDirectories() {
        if (UAManager.getSingleton() != null) {
            UAManager.getSingleton();
            UAManager.setInstallDir(this.installDir);
            UAManager.getSingleton();
            UAManager.setDirUnderInstall(this.dirUnderInstall);
            UAManager.getSingleton();
            UAManager.setMapDir(this.mapDir);
            UAManager.getSingleton();
            UAManager.setIPBaseDir(this.ipBaseDir);
            UAManager.getSingleton();
            UAManager.setBaseHelpDir(this.baseHelpDir);
            File file = new File(UAManager.getInstallDir());
            if (!file.exists() || !file.isDirectory()) {
                throw new Error("UAMCustomizerWindowAdapter:Constructor: invalid value- installDir = " + file.getAbsolutePath());
            }
            file = new File(UAManager.getInstallDir() + System.getProperty("user.dir") + UAManager.getDirUnderInstall());
            if (!file.exists() || !file.isDirectory()) {
                throw new Error("UAMCustomizerWindowAdapter:Constructor: invalid value- dirUnderInstall = " + file.getAbsolutePath());
            }
            file = new File(UAManager.getInstallDir() + UAManager.getIPBaseDir());
            if (!file.exists() || !file.isDirectory()) {
                throw new Error("UAMCustomizerWindowAdapter:Constructor: invalid value- ipBaseDir = " + file.getAbsolutePath());
            }
            file = new File(UAManager.getMapDirectory());
            if (!file.exists() || !file.isDirectory()) {
                throw new Error("UAMCustomizerWindowAdapter:Constructor: invalid value- mapDir = " + file.getAbsolutePath());
            }
            file = new File(UAManager.getBaseHelpDir());
            if (!file.exists() || !file.isDirectory()) {
                throw new Error("UAMCustomizerWindowAdapter:Constructor: invalid value- baseHelpDir = " + file.getAbsolutePath());
            }
        }
    }

    protected void setDefaultDirectories(String string, String string2, String string3, String string4, String string5) {
        this.installDir = string;
        this.dirUnderInstall = string2;
        this.ipBaseDir = string3;
        this.mapDir = string4;
        File file = new File(string5);
        this.baseHelpDir = file.getAbsolutePath();
        if (!this.baseHelpDir.endsWith("\\") && !this.baseHelpDir.endsWith("/")) {
            this.baseHelpDir = this.baseHelpDir + System.getProperty("file.separator");
        }
        if (this.postconditions) {
            this.verifyDefaultDirectories();
        }
    }

    protected void verifyToken() {
        boolean bl = true;
        if (this.uamToken == null || this.uamToken == "") {
            bl = false;
        }
        if (!bl) {
            throw new Error("UAMCustomizerWindowAdapter:Constructor: invalid value - uamToken = " + this.uamToken);
        }
    }

    protected void setToken(String string) {
        this.uamToken = string;
        if (this.postconditions) {
            this.verifyToken();
        }
    }

    protected String getLang() {
        return HelpManager.defaultLocaleString();
    }

    public void setPostconditions(boolean bl) {
        this.postconditions = bl;
    }
}

