/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.uamanager;

import com.ibm.db2.tools.common.uamanager.InfoPopGnosis;
import com.ibm.db2.tools.common.uamanager.InfoPopManager;
import com.ibm.db2.tools.common.uamanager.UAImplementation;
import com.ibm.db2.tools.common.uamanager.UAInstance;
import com.ibm.db2.tools.common.uamanager.UAManager;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import javax.swing.Timer;
import javax.swing.table.JTableHeader;

public class UAJTableHeaderListener
extends MouseAdapter
implements KeyListener,
MouseMotionListener,
ActionListener,
WindowListener {
    private Window ancestorWindow;
    private JTableHeader tableHeader;
    private int curCol = -1;
    private Timer colEnteredTimer;
    private UAInstance helpInstance;
    private UAManager uaManager;
    private static Hashtable tHeaderHash = new Hashtable();
    ComponentEvent pEvent;

    public UAJTableHeaderListener(JTableHeader jTableHeader, UAManager uAManager) {
        if (tHeaderHash.containsKey(jTableHeader)) {
            return;
        }
        tHeaderHash.put(jTableHeader, this);
        this.uaManager = uAManager;
        this.tableHeader = jTableHeader;
        this.helpInstance = UAImplementation.getImplementation();
        this.colEnteredTimer = new Timer(UAManager.getInfoPopDelay(), this);
        this.tableHeader.addMouseMotionListener(this);
        this.tableHeader.addMouseListener(this);
        this.tableHeader.addKeyListener(this);
        Container container = this.tableHeader.getParent();
        while (container != null) {
            if (container instanceof Window) {
                this.ancestorWindow = (Window)container;
                this.ancestorWindow.addWindowListener(this);
                break;
            }
            container = container.getParent();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n2;
        int n3 = this.tableHeader.columnAtPoint(mouseEvent.getPoint());
        int n4 = n2 = n3 >= 0 ? this.tableHeader.getTable().convertColumnIndexToModel(n3) : n3;
        if (this.curCol != n2) {
            if (this.helpInstance.isPopupShowing()) {
                this.helpInstance.hidePopupInstanceNow();
            }
            this.curCol = n2;
            this.pEvent = mouseEvent;
            this.colEnteredTimer.setDelay(UAManager.getInfoPopDelay());
            this.colEnteredTimer.setRepeats(false);
            this.colEnteredTimer.restart();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.curCol = -1;
        this.colEnteredTimer.stop();
        if (this.helpInstance.isPopupShowing()) {
            this.helpInstance.hidePopupInstanceNow();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.helpInstance.isPopupShowing()) {
            this.helpInstance.hidePopupInstanceNow();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.helpInstance.isPopupShowing()) {
            this.helpInstance.hidePopupInstanceNow();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = UAManager.getPackageToken(this.ancestorWindow);
        String string2 = this.ancestorWindow.getClass().getName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        String string3 = string + "." + string2 + "." + (String)this.tableHeader.getClientProperty("UAKey");
        string3 = this.curCol >= 0 ? string3 + "_" + this.curCol : string3 + "_TABLE";
        String string4 = this.uaManager.getContentString(this.pEvent, string3, (Window)UAManager.lookupEventParent(this.pEvent));
        if (!(string4.startsWith("UA Error: ") && !UAManager.getDebug() || this.helpInstance.isPopupShowing())) {
            InfoPopManager infoPopManager = InfoPopManager.getSharedInstance();
            InfoPopGnosis infoPopGnosis = new InfoPopGnosis(string4);
            infoPopManager.showDiagnosis(this.tableHeader, 4, infoPopGnosis);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        if (n2 == 112) {
            String string = UAManager.getPackageToken(this.ancestorWindow);
            String string2 = this.ancestorWindow.getClass().getName();
            string2 = string2.substring(string2.lastIndexOf(46) + 1);
            String string3 = string + "." + string2 + "." + (String)this.tableHeader.getClientProperty("UAKey");
            string3 = this.curCol >= 0 ? string3 + "_" + this.curCol : string3 + "_TABLE";
            String string4 = this.uaManager.getContentString(this.pEvent, string3, (Window)UAManager.lookupEventParent(this.pEvent));
            if (!(string4.startsWith("UA Error: ") && !UAManager.getDebug() || this.helpInstance.isPopupShowing())) {
                InfoPopManager infoPopManager = InfoPopManager.getSharedInstance();
                InfoPopGnosis infoPopGnosis = new InfoPopGnosis(string4);
                infoPopManager.showDiagnosis(this.tableHeader, 4, infoPopGnosis);
            }
        } else if (this.helpInstance.isPopupShowing()) {
            this.helpInstance.hidePopupInstanceNow();
        }
        keyEvent.consume();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.tableHeader.removeKeyListener(this);
        this.tableHeader.removeMouseListener(this);
        this.tableHeader.removeMouseMotionListener(this);
        this.ancestorWindow.removeWindowListener(this);
        tHeaderHash.remove(this.tableHeader);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }
}

