/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.uamanager;

import com.ibm.db2.tools.common.uamanager.UAMException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UAInfopopChecker {
    private static boolean DEBUG = false;
    static final String NAME = "UAInfopopChecker";
    private static Hashtable reportTable;
    private static int totalPopCount;
    private static int errorPopCount;
    static Vector errorVect;
    private InputStreamReader isrUc;
    private int lengthOfUC;
    private char[] alreadyUnicode;
    private static final String begCMT = "<!--";
    private static final String begID = "infopopid=";
    private static final String begIDCAPS = "INFOPOPID=";
    private static final String endCMT = "-->";
    private static final String anchorCAPS = "<A NAME=";
    private static final String anchorEndCAPS = "</A>";
    private static final String underMoreCAPS = "_MORE";
    private static final String capsBegFooter = "BEGIN FOOTER RECORDS";
    private static final String capsEndBody = "</BODY>";
    private static final String capsEndHTML = "</HTML>";

    private UAInfopopChecker() {
    }

    public UAInfopopChecker(String string) throws UAMException {
        File file = new File(string);
        boolean bl = true;
        if (!file.exists()) {
            bl = false;
            UAInfopopChecker.logError("UAInfopopChecker: The input file " + string + " does not exist.");
        }
        if (!file.canRead()) {
            bl = false;
            UAInfopopChecker.logError("UAInfopopChecker: The input file " + string + " cannot be read.");
        }
        if (bl) {
            new UAInfopopChecker(file);
        }
    }

    public UAInfopopChecker(File file) throws UAMException {
        Hashtable hashtable = this.findPopInfo(file);
        try {
            String string = file.getCanonicalPath();
            reportTable.put(string, hashtable);
        }
        catch (IOException iOException) {
            String string = file.getName();
            UAInfopopChecker.logError("UAInfopopChecker threw an IOException getting the canonical path information for file" + string);
            reportTable.put(string, hashtable);
        }
    }

    public Hashtable findPopInfo(File file) {
        if (DEBUG) {
            System.out.println("UAInfopopChecker.findPopInfo()");
        }
        boolean bl = false;
        String string = "This infopop has no text.";
        String string2 = "This infopop text is too long (";
        String string3 = " characters).";
        String string4 = "This infopop text contains an XMP tag.";
        String string5 = "This infopop text contains a PRE tag.";
        String string6 = "This infopop text starts with a BR tag.";
        String string7 = "This infopop text contains a TABLE tag.";
        String string8 = "This infopop text contains a VAR tag.";
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = this.parseInputFile(file);
        if (hashtable2.isEmpty()) {
            if (DEBUG) {
                System.out.println("UAIPC.reportPopInfo(): The anchor string table is empty.");
            }
            UAInfopopChecker.logError("UAInfopopChecker: The anchor string table is empty.");
        } else {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                int n2;
                Vector<String> vector = new Vector<String>();
                String string9 = (String)enumeration.nextElement();
                String string10 = (String)hashtable2.get(string9);
                if (string10.length() == 0) {
                    bl = true;
                    vector.addElement(string);
                }
                if (string10.length() > 560) {
                    bl = true;
                    vector.addElement(string2 + string10.length() + string3);
                }
                if (string10.toUpperCase().indexOf("<XMP") != -1) {
                    bl = true;
                    vector.addElement(string4);
                }
                if (string10.toUpperCase().indexOf("<PRE") != -1) {
                    bl = true;
                    vector.addElement(string5);
                }
                if (string10.toUpperCase().indexOf("<BR>") != -1 && (n2 = string10.toUpperCase().indexOf("<BR>")) == 0) {
                    bl = true;
                    vector.addElement(string6);
                }
                if (string10.toUpperCase().indexOf("<TABLE") != -1) {
                    bl = true;
                    vector.addElement(string7);
                }
                if (string10.toUpperCase().indexOf("<VAR") != -1) {
                    bl = true;
                    vector.addElement(string8);
                }
                if (!bl) continue;
                hashtable.put(string9, vector);
                bl = false;
            }
        }
        return hashtable;
    }

    public Hashtable parseInputFile(File file) {
        int n2;
        if (DEBUG) {
            System.out.println("UAInfopopChecker.parseInputFile()");
        }
        Hashtable hashtable = new Hashtable();
        String string = null;
        String string2 = "Unicode";
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            n2 = (int)file.length();
            char[] cArray = new char[n2 + 1];
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            cArray = this.readCharsFromStream(n2, cArray, inputStreamReader);
            if (cArray != null) {
                string = new String(cArray);
            } else {
                UAInfopopChecker.logError("UAInfopopChecker: Unable to read input file " + file.getName());
            }
        }
        catch (IOException iOException) {
            UAInfopopChecker.logError("UAInfopopChecker: Caught an IOException for " + file.getName());
        }
        if (string != null) {
            int n3 = -1;
            n3 = this.checkStringForEnd(string);
            if (n3 > 0) {
                string = string.substring(0, n3);
            }
            boolean bl = (n2 = string.toUpperCase().indexOf(begIDCAPS)) <= 0;
            hashtable = bl ? this.parseAnchorPop(string) : this.parseInfoPop(string);
        }
        return hashtable;
    }

    private char[] readCharsFromStream(int n2, char[] cArray, InputStreamReader inputStreamReader) {
        if (DEBUG) {
            System.out.println("UAInfopopChecker.readCharsFromStream()");
        }
        int n3 = 0;
        int n4 = 0;
        try {
            while (n3 != -1) {
                n3 = inputStreamReader.read(cArray, n3, cArray.length - n4);
                n4 += n3;
            }
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            UAInfopopChecker.logError("UAInfopopChecker: Caught an IOException reading IP content file.");
        }
        if ((++n4 + 1) * 2 < n2) {
            UAInfopopChecker.logError("UAInfopopChecker: Failed to read entire IP content file.");
        }
        return cArray;
    }

    private synchronized int checkStringForEnd(String string) {
        if (DEBUG) {
            System.out.println("UAInfopopChecker.checkStringForEnd()");
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement(capsBegFooter);
        vector.addElement(capsEndBody);
        vector.addElement(capsEndHTML);
        int n2 = 0;
        while (n2 < vector.size()) {
            if (string.indexOf((String)vector.elementAt(n2)) > -1) {
                return string.indexOf((String)vector.elementAt(n2));
            }
            ++n2;
        }
        return -1;
    }

    public Hashtable parseAnchorPop(String string) {
        int n2;
        if (DEBUG) {
            System.out.println("UAInfopopChecker.parseAnchorPop()");
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        String string2 = "";
        String string3 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        n3 = this.getNextAnchorIndex(string);
        if (n3 > 0) {
            string = string.substring(n3);
        }
        int n7 = string.indexOf(begCMT);
        int n8 = -1;
        while (n8 < n7) {
            n2 = string.indexOf(endCMT, n7);
            string = string.substring(0, n7) + string.substring(n2 + endCMT.length());
            n7 = string.indexOf(begCMT);
        }
        n2 = 0;
        while (n2 == 0) {
            n4 = string.indexOf("\"");
            n5 = string.indexOf("\"", n4 + 1);
            string2 = string.substring(n4 + 1, n5);
            if (string.toUpperCase().indexOf(anchorEndCAPS) != -1) {
                string = string.substring(string.toUpperCase().indexOf(anchorEndCAPS) + anchorEndCAPS.length());
            }
            if ((n6 = string2.toUpperCase().indexOf(underMoreCAPS)) == -1) {
                String string4;
                int n9;
                string3 = this.getNextAnchorIndex(string) != -1 ? string.substring(0, this.getNextAnchorIndex(string)) : string;
                if (string3.toUpperCase().indexOf(capsBegFooter) != -1) {
                    string3 = string3.substring(0, string3.toUpperCase().indexOf(capsBegFooter));
                }
                String string5 = "<B><IMG";
                String string6 = "</B>";
                int n10 = string3.toUpperCase().indexOf(string5);
                if (n10 != -1) {
                    int n11 = string3.toUpperCase().indexOf(string6, n10);
                    string3 = string3.substring(0, n10) + string3.substring(n11 + string6.length());
                    String string7 = "<B>";
                    String string8 = "</B>";
                    int n12 = string3.toUpperCase().indexOf(string7);
                    if (n12 != -1) {
                        n9 = string3.toUpperCase().indexOf(string8, n12);
                        string3 = string3.substring(0, n12) + string3.substring(n9 + string8.length());
                    }
                }
                String string9 = "<P><DT>";
                int n13 = string3.toUpperCase().indexOf(string9);
                int n14 = -1;
                while (n14 < n13) {
                    string3 = string3.substring(0, n13) + string3.substring(n13 + 3);
                    n13 = string3.toUpperCase().indexOf(string9);
                }
                String string10 = "<A HREF";
                n9 = string3.toUpperCase().indexOf(string10);
                int n15 = -1;
                while (n15 < n9) {
                    int n16 = string3.toUpperCase().indexOf(anchorEndCAPS);
                    string4 = string3.substring(n9, n16);
                    string4 = string4.substring(string4.indexOf(">") + 1);
                    string3 = string3.substring(0, n9) + string4 + string3.substring(n16 + anchorEndCAPS.length());
                    n9 = string3.toUpperCase().indexOf(string10);
                }
                String string11 = "<IMG";
                string4 = ">";
                int n17 = string3.toUpperCase().indexOf(string11);
                int n18 = -1;
                while (n18 < n17) {
                    int n19 = string3.indexOf(string4, n17);
                    string3 = string3.substring(0, n17) + string3.substring(n19 + string4.length());
                    n17 = string3.toUpperCase().indexOf(string11);
                }
                String string12 = "<BR><BR>";
                int n20 = string3.toUpperCase().indexOf(string12);
                int n21 = -1;
                while (n21 < n20) {
                    string3 = string3.substring(0, n20) + string3.substring(n20 + string12.length());
                    n20 = string3.toUpperCase().indexOf(string12);
                }
                String string13 = "<B></B>";
                int n22 = string3.toUpperCase().indexOf(string13);
                int n23 = -1;
                while (n23 < n22) {
                    string3 = string3.substring(0, n22) + string3.substring(n22 + string13.length());
                    n22 = string3.toUpperCase().indexOf(string13);
                }
                if (string3.toUpperCase().indexOf(capsBegFooter) != -1) {
                    string3 = string3.substring(0, string3.toUpperCase().indexOf(capsBegFooter));
                }
                if (string3 != null) {
                    string3 = this.getCleanString(string3);
                }
                if (string2 != null) {
                    hashtable.put(string2, string3);
                    ++totalPopCount;
                }
            }
            if ((n3 = this.getNextAnchorIndex(string)) > 0) {
                string = string.substring(n3);
                continue;
            }
            n2 = 1;
        }
        return hashtable;
    }

    public Hashtable parseInfoPop(String string) {
        int n2;
        if (DEBUG) {
            System.out.println("UAInfopopChecker.parseInfoPop()");
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        String string2 = "";
        String string3 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        n3 = this.getNextInfopopIDIndex(string);
        if (n3 > 0) {
            string = string.substring(n3);
        }
        int n6 = string.indexOf(begCMT);
        int n7 = -1;
        while (n7 < n6) {
            n2 = string.indexOf(endCMT, n6);
            String string4 = string.substring(n6 + begCMT.length(), n2);
            if (string4.toUpperCase().indexOf(begIDCAPS) != -1) {
                ++n6;
            } else {
                string = string.substring(0, n6) + string.substring(n2 + endCMT.length());
            }
            n6 = string.indexOf(begCMT, n6);
        }
        n2 = 0;
        while (n2 == 0) {
            n4 = string.indexOf("\"");
            n5 = string.indexOf("\"", n4 + 1);
            string2 = string.substring(n4 + 1, n5);
            if (string.indexOf(endCMT) != -1) {
                string = string.substring(string.indexOf(endCMT) + endCMT.length());
            }
            if ((string3 = string.indexOf(begCMT) != -1 ? string.substring(0, string.indexOf(begCMT)) : string) != null) {
                string3 = this.getCleanString(string3);
            }
            if (string2 != null) {
                hashtable.put(string2, string3);
                ++totalPopCount;
            }
            if ((n3 = this.getNextInfopopIDIndex(string)) > 0) {
                string = string.substring(n3);
                continue;
            }
            n2 = 1;
        }
        return hashtable;
    }

    private synchronized int getNextAnchorIndex(String string) {
        if (DEBUG) {
            System.out.println("UAInfopopChecker.getNextAnchorIndex()");
        }
        return string.toUpperCase().indexOf(anchorCAPS);
    }

    private synchronized int getNextInfopopIDIndex(String string) {
        if (DEBUG) {
            System.out.println("UAInfopopChecker.getNextInfopopIDIndex()");
        }
        return string.toUpperCase().indexOf(begIDCAPS);
    }

    private synchronized String getCleanString(String string) {
        string = string.trim();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (bl) {
                if (!Character.isWhitespace(c2)) {
                    if (!bl3) {
                        stringBuffer.append(c2);
                    }
                    if (!bl2) {
                        bl = false;
                    }
                }
            } else if (Character.isWhitespace(c2)) {
                stringBuffer.append(' ');
                bl = true;
            } else if (c2 == '<' && n2 > n3 + 3 && string.substring(n3, n3 + 3).equalsIgnoreCase("<P>")) {
                stringBuffer.append("<p>");
                n3 += 2;
                bl = true;
            } else if (c2 == '<' && n2 > n3 + begCMT.length() && string.substring(n3, n3 + begCMT.length()).equalsIgnoreCase(begCMT)) {
                n3 += begCMT.length();
                bl3 = true;
            } else if (c2 == '<') {
                bl2 = true;
                stringBuffer.append('<');
            } else if (n2 > n3 + endCMT.length() && string.substring(n3, n3 + endCMT.length()).equalsIgnoreCase(endCMT)) {
                bl2 = false;
            } else if (bl2 && c2 == '>') {
                bl2 = false;
                stringBuffer.append('>');
            } else if (!bl3) {
                stringBuffer.append(c2);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private String reportPopInfo() {
        String string;
        if (DEBUG) {
            System.out.println("UAInfopopChecker.reportPopInfo()");
        }
        String string2 = string = "\n*** List of Infopop Errors ***";
        if (reportTable.isEmpty()) {
            UAInfopopChecker.logError("UAInfopopChecker: There are no infopop files to report.");
        } else {
            Enumeration enumeration = reportTable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Hashtable hashtable = (Hashtable)reportTable.get(string3);
                if (hashtable.isEmpty()) {
                    if (DEBUG) {
                        System.out.println("UAIPC.reportPopInfo(): The anchor table is empty.");
                    }
                    string2 = string2 + "\n\nInput Filename: " + "\t" + string3 + "\nInfopop Error:  " + "\tThis file has no infopop errors.";
                    continue;
                }
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    String string4 = (String)enumeration2.nextElement();
                    Vector vector = (Vector)hashtable.get(string4);
                    boolean bl = true;
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        if ((String)vector.elementAt(n2) != "") {
                            if (bl) {
                                string2 = string2 + "\n\nInput Filename: " + "\t" + string3 + "\nInfopop Anchor: " + "\t" + string4 + "\nInfopop Error:  " + "\t" + vector.elementAt(n2);
                                bl = false;
                            } else {
                                string2 = string2 + "\n                " + "\t" + vector.elementAt(n2);
                            }
                        }
                        ++n2;
                    }
                    ++errorPopCount;
                }
            }
        }
        return string2;
    }

    private static void logError(String string) {
        errorVect.addElement("Error: " + string);
    }

    private String reportErrors() {
        String string = "\n*** Infopop Checker Error Report *** \n";
        errorVect.trimToSize();
        if (errorVect.size() == 0) {
            return "\nInfopop Checker completed successfully.";
        }
        Enumeration enumeration = errorVect.elements();
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            string2 = string2 + enumeration.nextElement() + "\n";
        }
        errorVect.trimToSize();
        String string3 = string + errorVect.size() + " error(s)\n" + string2 + "END REPORT\n" + errorVect.size() + " error(s) reported";
        return string3;
    }

    static int pseudoHashCode(char[] cArray) {
        int n2 = 0;
        int n3 = 0;
        char[] cArray2 = cArray;
        int n4 = cArray.length;
        if (n4 < 16) {
            int n5 = n4;
            while (n5 > 0) {
                n2 = n2 * 37 + cArray2[n3++];
                --n5;
            }
        } else {
            int n6 = n4 / 8;
            int n7 = n4;
            while (n7 > 0) {
                n2 = n2 * 39 + cArray2[n3];
                n7 -= n6;
                n3 += n6;
            }
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        UAInfopopChecker uAInfopopChecker = null;
        String string = null;
        reportTable = new Hashtable();
        try {
            int n2 = UAInfopopChecker.pseudoHashCode(stringArray[0].toCharArray());
            if (n2 == -981818584) {
                DEBUG = true;
                n2 = -964127032;
            }
            switch (n2) {
                case 89747534: {
                    System.out.println("Valid commands for UAInfopopChecker");
                    System.out.println("-----------------------------------");
                    System.out.println("\nTo show help:");
                    System.out.println("\tjava uamanager.UAInfopopChecker -help");
                    System.out.println("\nTo check single infopop file:");
                    System.out.println("\tjava uamanager.UAInfopopChecker blahip.html");
                    System.out.println("\twhere blahip.html represents the infopop HTML filename.");
                    System.out.println("\nOr you can use -single:");
                    System.out.println("\tjava uamanager.UAInfopopChecker -single blahip.html");
                    System.out.println("\twhere blahip.html represents the infopop HTML filename.");
                    System.out.println("\nTo check multiple infopop files:");
                    System.out.println("\tjava uamanager.UAInfopopChecker -multi listfile.lst");
                    System.out.println("\twhere listfile.lst represents a file containing a list of HTML files.");
                    System.exit(0);
                    break;
                }
                case -964127032: {
                    String string2;
                    BufferedReader bufferedReader;
                    if (DEBUG) {
                        System.out.println("\nProcessing files listed in " + stringArray[1] + "...");
                    }
                    if ((bufferedReader = new BufferedReader(new FileReader(string2 = stringArray[1]))) == null) break;
                    try {
                        while ((string = bufferedReader.readLine()) != null) {
                            if (DEBUG) {
                                System.out.println("Processing the infopop file " + string + "...");
                            }
                            uAInfopopChecker = new UAInfopopChecker(string);
                        }
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case -919304285: {
                    string = stringArray[1];
                    if (DEBUG) {
                        System.out.println("Processing the infopop file " + string + "...");
                    }
                    uAInfopopChecker = new UAInfopopChecker(string);
                    break;
                }
                default: {
                    string = stringArray[0];
                    if (DEBUG) {
                        System.out.println("Processing the infopop file " + string + "...");
                    }
                    uAInfopopChecker = new UAInfopopChecker(string);
                }
            }
            System.out.println(uAInfopopChecker.reportPopInfo());
            System.out.println("\n\nNumber of infopops with errors:     " + errorPopCount);
            System.out.println("Total number of infopops processed: " + totalPopCount);
            System.out.println(uAInfopopChecker.reportErrors());
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(99);
        }
    }

    static {
        totalPopCount = 0;
        errorPopCount = 0;
        errorVect = new Vector();
    }
}

