/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.uamanager;

import com.ibm.db2.tools.common.uamanager.HelpManager;
import com.ibm.db2.tools.common.uamanager.InfoPopGnosis;
import com.ibm.db2.tools.common.uamanager.InfoPopManager;
import com.ibm.db2.tools.common.uamanager.UAInstance;
import com.ibm.db2.tools.common.uamanager.UAManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class UAImplementation
implements UAInstance {
    static UAImplementation sharedInstance;
    private static final String VIEWPORT_STR = "javax.swing.JScrollPane";
    private static Class classObj;
    private static final boolean DEBUG = false;
    Timer mouseEnteredTimer;
    Timer mouseExitedTimer;
    InfoPopManager stipMgr = InfoPopManager.getSharedInstance();
    Window SourceWindow;
    Component compNeedsHelp;

    public JApplet getApplet() {
        return (JApplet)HelpManager.getApplet();
    }

    public static UAImplementation getImplementation() {
        if (sharedInstance != null) {
            return sharedInstance;
        }
        sharedInstance = new UAImplementation();
        try {
            classObj = Class.forName(VIEWPORT_STR);
        }
        catch (Exception exception) {
            classObj = null;
        }
        return sharedInstance;
    }

    public void showHelpInstance(Component component, String string) {
        this.compNeedsHelp = component;
        char[] cArray = System.getProperty("file.separator").toCharArray();
        if ((string = UAManager.setDirs(string, cArray[0])).endsWith(".htm") && !string.startsWith("eclipse:")) {
            string = string.substring(0, string.lastIndexOf(".htm"));
        }
        HelpManager.showHelp(string, null);
    }

    public boolean isPopupShowing() {
        return this.stipMgr.isTipVisible();
    }

    public Rectangle getTipBounds() {
        return this.stipMgr.getTipBounds();
    }

    public void showPopupInstanceNow(Window window, String string, EventObject eventObject) {
        if (this.mouseEnteredTimer != null) {
            this.mouseEnteredTimer.stop();
        }
        if (this.mouseExitedTimer != null) {
            this.mouseExitedTimer.stop();
        }
        if (eventObject == null) {
            return;
        }
        JComponent jComponent = this.getSafeOwner((Component)eventObject.getSource());
        InfoPopGnosis infoPopGnosis = new InfoPopGnosis(string);
        if (jComponent instanceof JTextArea || jComponent instanceof JComboBox || jComponent instanceof JTable || jComponent instanceof JScrollPane) {
            this.stipMgr.showDiagnosis(jComponent, 4, infoPopGnosis);
        } else {
            this.stipMgr.showDiagnosis(jComponent, 2, infoPopGnosis);
        }
    }

    public void showPopupInstanceNow(String string, JComponent jComponent) {
        if (this.mouseEnteredTimer != null) {
            this.mouseEnteredTimer.stop();
        }
        if (this.mouseExitedTimer != null) {
            this.mouseExitedTimer.stop();
        }
        JComponent jComponent2 = this.getSafeOwner(jComponent);
        InfoPopGnosis infoPopGnosis = new InfoPopGnosis(string);
        if (jComponent2 instanceof JTextArea || jComponent2 instanceof JComboBox || jComponent2 instanceof JTable || jComponent2 instanceof JScrollPane) {
            this.stipMgr.showDiagnosis(jComponent2, 4, infoPopGnosis);
        } else {
            this.stipMgr.showDiagnosis(jComponent2, 2, infoPopGnosis);
        }
    }

    public void showPopupInstance(Window window, String string, EventObject eventObject) {
        JComponent jComponent = this.getSafeOwner((Component)eventObject.getSource());
        InfoPopGnosis infoPopGnosis = new InfoPopGnosis(string);
        if (this.mouseExitedTimer != null) {
            this.mouseExitedTimer.stop();
            this.mouseExitedTimer = null;
        }
        if (this.mouseEnteredTimer == null) {
            final InfoPopGnosis infoPopGnosis2 = infoPopGnosis;
            final JComponent jComponent2 = jComponent;
            this.mouseEnteredTimer = new Timer(2000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jComponent2 instanceof JTextArea || jComponent2 instanceof JComboBox || jComponent2 instanceof JTable || jComponent2 instanceof JScrollPane) {
                        UAImplementation.this.stipMgr.showDiagnosis(jComponent2, 4, infoPopGnosis2);
                    } else {
                        UAImplementation.this.stipMgr.showDiagnosis(jComponent2, 2, infoPopGnosis2);
                    }
                }
            });
            this.mouseEnteredTimer.setRepeats(false);
            this.mouseEnteredTimer.start();
        } else {
            this.mouseEnteredTimer.stop();
            this.mouseEnteredTimer = null;
            this.showPopupInstance(window, string, eventObject);
        }
    }

    public void hideHelpInstance() {
    }

    public void hidePopupInstanceNow() {
        this.stipMgr.hideDiagnosis();
    }

    public void hidePopupInstance() {
        if (this.mouseExitedTimer == null) {
            this.mouseExitedTimer = new Timer(4000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UAImplementation.this.stipMgr.hideDiagnosis();
                }
            });
            this.mouseExitedTimer.setRepeats(false);
            this.mouseExitedTimer.start();
        } else if (this.stipMgr.isTipVisible()) {
            this.mouseExitedTimer.start();
        } else {
            this.mouseEnteredTimer.stop();
            this.mouseEnteredTimer = null;
            this.stipMgr.hideDiagnosis();
        }
    }

    private JComponent getSafeOwner(Component component) {
        JComponent jComponent = (JComponent)component;
        try {
            jComponent = this.checkForScrollPanes(jComponent);
        }
        catch (Exception exception) {
            jComponent = (JComponent)component;
        }
        if (jComponent.getParent() != null && jComponent.getParent() instanceof JComboBox) {
            jComponent = (JComponent)jComponent.getParent();
        }
        if (jComponent instanceof JScrollPane) {
            jComponent = this.checkForScrollPanes(jComponent);
        }
        return jComponent;
    }

    private JComponent checkForScrollPanes(JComponent jComponent) {
        if (classObj == null) {
            return jComponent;
        }
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(classObj, jComponent);
        if (jScrollPane != null) {
            boolean bl;
            Rectangle rectangle = jScrollPane.getBounds();
            Point point = jScrollPane.getLocationOnScreen();
            Dimension dimension = jComponent.getSize();
            Point point2 = jComponent.getLocationOnScreen();
            boolean bl2 = bl = point.x <= point2.x && point2.x <= point.x + rectangle.width && point2.x + dimension.width <= point.x + rectangle.width && point.y <= point2.y && point2.y <= point.y + rectangle.height && point2.y + dimension.height <= point.y + rectangle.height;
            if (!bl) {
                jComponent = jScrollPane;
            }
        }
        return jComponent;
    }

    public void cleanupHelpInstance() {
        if (this.mouseExitedTimer != null) {
            this.mouseExitedTimer.stop();
        }
        if (this.mouseEnteredTimer != null) {
            this.mouseEnteredTimer.stop();
        }
    }

    static {
        classObj = null;
    }
}

